/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.gazetteer;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.ProcessingResource;
import gate.Resource;
import gate.creole.AbstractLanguageAnalyser;
import gate.creole.ExecutionException;
import gate.creole.ResourceInstantiationException;
import gate.creole.gazetteer.Gazetteer;
import gate.creole.gazetteer.NodePosition;
import gate.util.InvalidOffsetException;
import gate.util.OffsetComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class FlexibleGazetteer
extends AbstractLanguageAnalyser
implements ProcessingResource {
    private Document document;
    private String outputAnnotationSetName;
    private String inputAnnotationSetName;
    private Gazetteer gazetteerInst;
    private List inputFeatureNames;
    private ArrayList changedNodes = new ArrayList();

    public Resource init() throws ResourceInstantiationException {
        if (this.gazetteerInst == null) {
            throw new ResourceInstantiationException("No Gazetteer Provided!");
        }
        return this;
    }

    public void execute() throws ExecutionException {
        Object object;
        long l;
        long l2;
        long l3;
        long l4;
        Object object2;
        long l5;
        long l6;
        Object object3;
        this.changedNodes = new ArrayList();
        this.fireProgressChanged(0);
        this.fireStatusChanged("Checking Document...");
        if (this.document == null) {
            throw new ExecutionException("No document to process!");
        }
        this.fireStatusChanged("Creating temporary Document...");
        StringBuffer stringBuffer = new StringBuffer(this.document.getContent().toString());
        Document document = null;
        boolean bl = false;
        if (this.inputFeatureNames == null || this.inputFeatureNames.size() == 0) {
            this.inputFeatureNames = new ArrayList();
        }
        Iterator iterator = this.getTokenIterator(this.document, this.inputAnnotationSetName);
        long l7 = 0L;
        this.fireStatusChanged("Replacing contents with the feature value...");
        block4: while (iterator != null && iterator.hasNext()) {
            object3 = (Annotation)iterator.next();
            if (object3.getType().equals("SpaceToken") && ((String)object3.getFeatures().get("kind")).equals("ChineseSplit")) {
                long l8 = object3.getStartNode().getOffset();
                l6 = l8 - l7;
                l5 = l6 + 1L;
                NodePosition nodePosition = new NodePosition(l8, l8, l6, l5, l7);
                bl = true;
                --l7;
                this.changedNodes.add(nodePosition);
                stringBuffer = stringBuffer.insert((int)l6, ' ');
                continue;
            }
            for (int i = 0; i < this.inputFeatureNames.size(); ++i) {
                FeatureMap featureMap;
                String string;
                object2 = ((String)this.inputFeatureNames.get(i)).split("[.]");
                if (((String[])object2).length != 2 || !object3.getType().equals(object2[0]) || (string = (String)(featureMap = object3.getFeatures()).get(object2[1])) == null) continue;
                l5 = object3.getStartNode().getOffset();
                long l9 = object3.getEndNode().getOffset();
                l4 = l9 - l5;
                l3 = l4 - (long)string.length();
                l2 = l5 - l7;
                l = l2 + (long)string.length();
                NodePosition nodePosition = new NodePosition(l5, l9, l2, l, l7 += l3);
                this.changedNodes.add(nodePosition);
                stringBuffer = stringBuffer.replace((int)l2, (int)l2 + (int)l4, string);
                continue block4;
            }
        }
        this.fireStatusChanged("New Document to be processed with Gazetteer...");
        try {
            object3 = Factory.newFeatureMap();
            object3.put("stringContent", stringBuffer.toString());
            object = Factory.newFeatureMap();
            Gate.setHiddenAttribute((FeatureMap)object, true);
            document = (Document)Factory.createResource("gate.corpora.DocumentImpl", (FeatureMap)object3, (FeatureMap)object);
        }
        catch (ResourceInstantiationException resourceInstantiationException) {
            throw new ExecutionException("Temporary document cannot be created");
        }
        object3 = Factory.newFeatureMap();
        this.gazetteerInst.setDocument(document);
        this.gazetteerInst.setAnnotationSetName(this.outputAnnotationSetName);
        this.fireStatusChanged("Executing Gazetteer...");
        this.gazetteerInst.execute();
        this.fireStatusChanged("Transfering new tags to the original one...");
        object = this.getTokenIterator(document, this.outputAnnotationSetName);
        object2 = this.outputAnnotationSetName == null ? this.document.getAnnotations() : this.document.getAnnotations(this.outputAnnotationSetName);
        l6 = 0L;
        l5 = 0L;
        int n = 0;
        while (object != null && object.hasNext()) {
            int n2;
            Annotation annotation = (Annotation)object.next();
            l4 = annotation.getStartNode().getOffset();
            l3 = annotation.getEndNode().getOffset();
            l2 = 0L;
            l = 0L;
            for (n2 = 0; n2 < this.changedNodes.size(); ++n2) {
                NodePosition nodePosition = (NodePosition)this.changedNodes.get(n2);
                if (nodePosition.getNewEndNode() < l4) continue;
                if (nodePosition.getNewStartNode() == l4) {
                    n = n2--;
                    l2 = n2 >= 0 ? ((NodePosition)this.changedNodes.get(n2)).getDeductedSpaces() : 0L;
                    l = nodePosition.getDeductedSpaces();
                    break;
                }
                n = n2--;
                if (n2 >= 0) {
                    l = l2 = ((NodePosition)this.changedNodes.get(n2)).getDeductedSpaces();
                    break;
                }
                l2 = 0L;
                l = 0L;
                break;
            }
            if (n2 == this.changedNodes.size()) {
                n = n2--;
                if (n2 >= 0) {
                    l = l2 = ((NodePosition)this.changedNodes.get(n2)).getDeductedSpaces();
                } else {
                    l2 = 0L;
                    l = 0L;
                }
            }
            try {
                object2.add(new Long(l4 + l2), new Long(l3 + l), annotation.getType(), annotation.getFeatures());
            }
            catch (InvalidOffsetException invalidOffsetException) {
                throw new ExecutionException(invalidOffsetException);
            }
        }
        Factory.deleteResource(document);
        this.fireProcessFinished();
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public Document getDocument() {
        return this.document;
    }

    public void setOutputAnnotationSetName(String string) {
        this.outputAnnotationSetName = string;
    }

    public String getOutputAnnotationSetName() {
        return this.outputAnnotationSetName;
    }

    public void setInputAnnotationSetName(String string) {
        this.inputAnnotationSetName = string;
    }

    public String getInputAnnotationSetName() {
        return this.inputAnnotationSetName;
    }

    public void setInputFeatureNames(List list) {
        this.inputFeatureNames = list;
    }

    public List getInputFeatureNames() {
        return this.inputFeatureNames;
    }

    public Gazetteer getGazetteerInst() {
        return this.gazetteerInst;
    }

    public void setGazetteerInst(Gazetteer gazetteer) {
        this.gazetteerInst = gazetteer;
    }

    public Iterator getTokenIterator(Document document, String string) {
        AnnotationSet annotationSet = string == null ? document.getAnnotations() : document.getAnnotations(string);
        AnnotationSet annotationSet2 = annotationSet.get();
        if (annotationSet2 == null) {
            return null;
        }
        ArrayList<Annotation> arrayList = new ArrayList<Annotation>(annotationSet.get());
        if (arrayList == null) {
            return null;
        }
        OffsetComparator offsetComparator = new OffsetComparator();
        Collections.sort(arrayList, offsetComparator);
        ListIterator listIterator = arrayList.listIterator();
        return listIterator;
    }
}

