/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.gazetteer;

import gate.AnnotationSet;
import gate.Factory;
import gate.FeatureMap;
import gate.Resource;
import gate.creole.ExecutionException;
import gate.creole.ExecutionInterruptedException;
import gate.creole.ResourceInstantiationException;
import gate.creole.gazetteer.AbstractGazetteer;
import gate.creole.gazetteer.FSMState;
import gate.creole.gazetteer.GazetteerList;
import gate.creole.gazetteer.GazetteerNode;
import gate.creole.gazetteer.LinearDefinition;
import gate.creole.gazetteer.LinearNode;
import gate.creole.gazetteer.Lookup;
import gate.creole.gazetteer.MappingNode;
import gate.util.GateRuntimeException;
import gate.util.InvalidOffsetException;
import gate.util.Strings;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DefaultGazetteer
extends AbstractGazetteer {
    private static final boolean DEBUG = false;
    public static final String DEF_GAZ_DOCUMENT_PARAMETER_NAME = "document";
    public static final String DEF_GAZ_ANNOT_SET_PARAMETER_NAME = "annotationSetName";
    public static final String DEF_GAZ_LISTS_URL_PARAMETER_NAME = "listsURL";
    public static final String DEF_GAZ_ENCODING_PARAMETER_NAME = "encoding";
    public static final String DEF_GAZ_CASE_SENSITIVE_PARAMETER_NAME = "caseSensitive";
    public static final String DEF_GAZ_LONGEST_MATCH_ONLY_PARAMETER_NAME = "longestMatchOnly";
    public static final String DEF_GAZ_FEATURE_SEPARATOR_PARAMETER_NAME = "gazetteerFeatureSeparator";
    protected String gazetteerFeatureSeparator;
    protected Map listsByNode;
    protected FSMState initialState;
    protected Set fsmStates;

    public Resource init() throws ResourceInstantiationException {
        this.fsmStates = new HashSet();
        this.initialState = new FSMState(this);
        if (this.listsURL == null) {
            throw new ResourceInstantiationException("No URL provided for gazetteer creation!");
        }
        this.definition = new LinearDefinition();
        this.definition.setSeparator(Strings.unescape(this.gazetteerFeatureSeparator));
        this.definition.setURL(this.listsURL);
        this.definition.load();
        int n = this.definition.size();
        this.listsByNode = this.definition.loadLists();
        Iterator iterator = this.definition.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            LinearNode linearNode = (LinearNode)iterator.next();
            this.fireStatusChanged("Reading " + linearNode.toString());
            this.fireProgressChanged(++n2 * 100 / n);
            this.readList(linearNode, true);
        }
        this.fireProcessFinished();
        return this;
    }

    protected void readList(LinearNode linearNode, boolean bl) throws ResourceInstantiationException {
        Object object;
        if (null == linearNode) {
            throw new ResourceInstantiationException(" LinearNode node is null ");
        }
        String string = linearNode.getList();
        String string2 = linearNode.getMajorType();
        String string3 = linearNode.getMinorType();
        String string4 = linearNode.getLanguage();
        GazetteerList gazetteerList = (GazetteerList)this.listsByNode.get(linearNode);
        if (null == gazetteerList) {
            throw new ResourceInstantiationException("gazetteer list not found by node");
        }
        Iterator iterator = gazetteerList.iterator();
        Lookup lookup = new Lookup(string, string2, string3, string4);
        lookup.list = linearNode.getList();
        if (null != this.mappingDefinition && null != (object = this.mappingDefinition.getNodeByList(lookup.list))) {
            lookup.oClass = ((MappingNode)object).getClassID();
            lookup.ontology = ((MappingNode)object).getOntologyID();
        }
        while (iterator.hasNext()) {
            GazetteerNode gazetteerNode = (GazetteerNode)iterator.next();
            String string5 = gazetteerNode.getEntry();
            Map map = gazetteerNode.getFeatureMap();
            if (map == null) {
                object = lookup;
            } else {
                MappingNode mappingNode;
                object = new Lookup(string, string2, string3, string4);
                ((Lookup)object).list = linearNode.getList();
                if (null != this.mappingDefinition && null != (mappingNode = this.mappingDefinition.getNodeByList(((Lookup)object).list))) {
                    ((Lookup)object).oClass = mappingNode.getClassID();
                    ((Lookup)object).ontology = mappingNode.getOntologyID();
                }
                ((Lookup)object).features = map;
            }
            if (bl) {
                this.addLookup(string5, (Lookup)object);
                continue;
            }
            this.removeLookup(string5, (Lookup)object);
        }
    }

    public void addLookup(String string, Lookup lookup) {
        FSMState fSMState = this.initialState;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            boolean bl = Character.isWhitespace(c);
            c = bl ? (char)' ' : (this.caseSensitive != false ? c : Character.toUpperCase(c));
            FSMState fSMState2 = fSMState.next(c);
            if (fSMState2 == null) {
                fSMState2 = new FSMState(this);
                fSMState.put(c, fSMState2);
                if (bl) {
                    fSMState2.put(' ', fSMState2);
                }
            }
            fSMState = fSMState2;
        }
        fSMState.addLookup(lookup);
    }

    public void removeLookup(String string, Lookup lookup) {
        FSMState fSMState = this.initialState;
        for (int i = 0; i < string.length(); ++i) {
            FSMState fSMState2;
            char c = string.charAt(i);
            if (Character.isWhitespace(c)) {
                c = ' ';
            }
            if ((fSMState2 = fSMState.next(c)) == null) {
                return;
            }
            fSMState = fSMState2;
        }
        fSMState.removeLookup(lookup);
    }

    public String getFSMgml() {
        String string = "graph[ \ndirected 1\n";
        StringBuffer stringBuffer = new StringBuffer(1024);
        StringBuffer stringBuffer2 = new StringBuffer(1024);
        for (FSMState fSMState : this.fsmStates) {
            int n = fSMState.getIndex();
            stringBuffer.append("node[ id ");
            stringBuffer.append(n);
            stringBuffer.append(" label \"");
            stringBuffer.append(n);
            if (fSMState.isFinal()) {
                stringBuffer.append(",F\\n");
                stringBuffer.append(fSMState.getLookupSet());
            }
            stringBuffer.append("\"  ]\n");
            stringBuffer2.append(fSMState.getEdgesGML());
        }
        string = string + stringBuffer.toString() + stringBuffer2.toString() + "]\n";
        return string;
    }

    public static boolean isWordInternal(char c) {
        return Character.isLetter(c) || Character.getType(c) == 8 || Character.getType(c) == 6;
    }

    public void execute() throws ExecutionException {
        this.interrupted = false;
        if (this.document == null) {
            throw new ExecutionException("No document to process!");
        }
        AnnotationSet annotationSet = this.annotationSetName == null || this.annotationSetName.equals("") ? this.document.getAnnotations() : this.document.getAnnotations(this.annotationSetName);
        this.fireStatusChanged("Performing look-up in " + this.document.getName() + "...");
        String string = this.document.getContent().toString();
        int n = string.length();
        FSMState fSMState = this.initialState;
        FSMState fSMState2 = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n4 < n) {
            char c = string.charAt(n4);
            c = Character.isWhitespace(c) ? (char)' ' : (this.caseSensitive != false ? c : Character.toUpperCase(c));
            FSMState fSMState3 = fSMState.next(c);
            if (fSMState3 == null) {
                if (fSMState2 != null) {
                    this.createLookups(fSMState2, n3, n2, annotationSet);
                    fSMState2 = null;
                }
                n3 = n4 = n3 + 1;
                fSMState = this.initialState;
            } else {
                fSMState = fSMState3;
                if (!(!fSMState.isFinal() || this.wholeWordsOnly.booleanValue() && (n3 != 0 && DefaultGazetteer.isWordInternal(string.charAt(n3 - 1)) || n4 + 1 < string.length() && DefaultGazetteer.isWordInternal(string.charAt(n4 + 1))))) {
                    if (!this.longestMatchOnly.booleanValue() && fSMState2 != null) {
                        this.createLookups(fSMState2, n3, n2, annotationSet);
                    }
                    n2 = n4;
                    fSMState2 = fSMState;
                }
                if (++n4 == string.length()) {
                    if (fSMState2 != null) {
                        this.createLookups(fSMState2, n3, n2, annotationSet);
                        fSMState2 = null;
                    }
                    n3 = n4 = n3 + 1;
                    fSMState = this.initialState;
                }
            }
            if (n4 - n5 <= 256) continue;
            this.fireProgressChanged(100 * n4 / n);
            n5 = n4;
            if (!this.isInterrupted()) continue;
            throw new ExecutionInterruptedException("The execution of the " + this.getName() + " gazetteer has been abruptly interrupted!");
        }
        if (fSMState2 != null) {
            this.createLookups(fSMState2, n3, n2, annotationSet);
        }
        this.fireProcessFinished();
        this.fireStatusChanged("Look-up complete!");
    }

    protected void createLookups(FSMState fSMState, long l, long l2, AnnotationSet annotationSet) {
        for (Lookup lookup : fSMState.getLookupSet()) {
            FeatureMap featureMap = Factory.newFeatureMap();
            featureMap.put("majorType", lookup.majorType);
            if (null != lookup.oClass && null != lookup.ontology) {
                featureMap.put("class", lookup.oClass);
                featureMap.put("ontology", lookup.ontology);
            }
            if (null != lookup.minorType) {
                featureMap.put("minorType", lookup.minorType);
            }
            if (null != lookup.features) {
                featureMap.putAll(lookup.features);
            }
            try {
                annotationSet.add(new Long(l), new Long(l2 + 1L), "Lookup", featureMap);
            }
            catch (InvalidOffsetException invalidOffsetException) {
                throw new GateRuntimeException(invalidOffsetException.toString());
            }
        }
    }

    public Set lookup(String string) {
        Set set = new HashSet();
        FSMState fSMState = this.initialState;
        for (int i = 0; i < string.length(); ++i) {
            FSMState fSMState2;
            char c = string.charAt(i);
            if (Character.isWhitespace(c)) {
                c = ' ';
            }
            if ((fSMState2 = fSMState.next(c)) == null) {
                return set;
            }
            fSMState = fSMState2;
        }
        set = fSMState.getLookupSet();
        return set;
    }

    public boolean remove(String string) {
        FSMState fSMState = this.initialState;
        for (int i = 0; i < string.length(); ++i) {
            FSMState fSMState2;
            char c = string.charAt(i);
            if (Character.isWhitespace(c)) {
                c = ' ';
            }
            if ((fSMState2 = fSMState.next(c)) == null) {
                return false;
            }
            fSMState = fSMState2;
        }
        fSMState.lookupSet = new HashSet();
        return true;
    }

    public boolean add(String string, Lookup lookup) {
        this.addLookup(string, lookup);
        return true;
    }

    public String getGazetteerFeatureSeparator() {
        return this.gazetteerFeatureSeparator;
    }

    public void setGazetteerFeatureSeparator(String string) {
        this.gazetteerFeatureSeparator = string;
    }

    public static class CharMap {
        char[] itemsKeys = null;
        Object[] itemsObjs = null;

        void resize(int n) {
            int n2;
            int n3 = this.itemsKeys.length + 1;
            char[] cArray = new char[n3];
            Object[] objectArray = new Object[n3];
            for (n2 = 0; n2 < n; ++n2) {
                cArray[n2] = this.itemsKeys[n2];
                objectArray[n2] = this.itemsObjs[n2];
            }
            for (n2 = n + 1; n2 < n3; ++n2) {
                cArray[n2] = this.itemsKeys[n2 - 1];
                objectArray[n2] = this.itemsObjs[n2 - 1];
            }
            this.itemsKeys = cArray;
            this.itemsObjs = objectArray;
        }

        Object get(char c) {
            if (this.itemsKeys == null) {
                return null;
            }
            int n = Arrays.binarySearch(this.itemsKeys, c);
            if (n < 0) {
                return null;
            }
            return this.itemsObjs[n];
        }

        Object put(char c, Object object) {
            if (this.itemsKeys == null) {
                this.itemsKeys = new char[1];
                this.itemsKeys[0] = c;
                this.itemsObjs = new Object[1];
                this.itemsObjs[0] = object;
                return object;
            }
            int n = Arrays.binarySearch(this.itemsKeys, c);
            if (n < 0) {
                this.resize(n ^= 0xFFFFFFFF);
                this.itemsKeys[n] = c;
                this.itemsObjs[n] = object;
            }
            return this.itemsObjs[n];
        }
    }

    public static interface Iter {
        public boolean hasNext();

        public char next();
    }
}

