/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.gazetteer;

import gate.FeatureMap;
import gate.creole.AbstractLanguageAnalyser;
import gate.creole.ResourceInstantiationException;
import gate.creole.gazetteer.Gazetteer;
import gate.creole.gazetteer.GazetteerEvent;
import gate.creole.gazetteer.GazetteerListener;
import gate.creole.gazetteer.LinearDefinition;
import gate.creole.gazetteer.MappingDefinition;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractGazetteer
extends AbstractLanguageAnalyser
implements Gazetteer {
    protected Set listeners = new HashSet();
    protected String annotationSetName;
    protected FeatureMap features = null;
    protected String encoding = "UTF-8";
    protected URL listsURL;
    protected Boolean caseSensitive = new Boolean(true);
    protected Boolean wholeWordsOnly = new Boolean(true);
    protected Boolean longestMatchOnly = new Boolean(true);
    protected LinearDefinition definition;
    protected MappingDefinition mappingDefinition;

    public void setAnnotationSetName(String string) {
        this.annotationSetName = string;
    }

    public String getAnnotationSetName() {
        return this.annotationSetName;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public URL getListsURL() {
        return this.listsURL;
    }

    public void setListsURL(URL uRL) {
        this.listsURL = uRL;
    }

    public void setCaseSensitive(Boolean bl) {
        this.caseSensitive = bl;
    }

    public Boolean getCaseSensitive() {
        return this.caseSensitive;
    }

    public void setMappingDefinition(MappingDefinition mappingDefinition) {
        this.mappingDefinition = mappingDefinition;
    }

    public MappingDefinition getMappingDefinition() {
        return this.mappingDefinition;
    }

    public Boolean getLongestMatchOnly() {
        return this.longestMatchOnly;
    }

    public void setLongestMatchOnly(Boolean bl) {
        this.longestMatchOnly = bl;
    }

    public LinearDefinition getLinearDefinition() {
        return this.definition;
    }

    public FeatureMap getFeatures() {
        return this.features;
    }

    public void setFeatures(FeatureMap featureMap) {
        this.features = featureMap;
    }

    public void reInit() throws ResourceInstantiationException {
        super.reInit();
        this.fireGazetteerEvent(new GazetteerEvent(this, 1));
    }

    public void fireGazetteerEvent(GazetteerEvent gazetteerEvent) {
        for (GazetteerListener gazetteerListener : this.listeners) {
            gazetteerListener.processGazetteerEvent(gazetteerEvent);
        }
    }

    public void addGazetteerListener(GazetteerListener gazetteerListener) {
        if (null != gazetteerListener) {
            this.listeners.add(gazetteerListener);
        }
    }

    public Boolean getWholeWordsOnly() {
        return this.wholeWordsOnly;
    }

    public void setWholeWordsOnly(Boolean bl) {
        this.wholeWordsOnly = bl;
    }
}

