/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.coref;

import gate.DataStore;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.creole.ANNIETransducer;
import gate.creole.POSTagger;
import gate.creole.coref.Coreferencer;
import gate.creole.gazetteer.DefaultGazetteer;
import gate.creole.orthomatcher.OrthoMatcher;
import gate.creole.splitter.SentenceSplitter;
import gate.creole.tokeniser.DefaultTokeniser;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestCoref
extends TestCase {
    public TestCoref(String string) {
        super(string);
    }

    public static void main(String[] stringArray) {
        try {
            Gate.init();
            TestCoref testCoref = new TestCoref("");
            testCoref.setUp();
            testCoref.useCase01();
            testCoref.tearDown();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static Test suite() {
        return new TestSuite(TestCoref.class);
    }

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    private void runANNIE(Document document) throws Exception {
        System.out.println("starting ANNIE modules...");
        DefaultTokeniser defaultTokeniser = (DefaultTokeniser)Factory.createResource("gate.creole.tokeniser.DefaultTokeniser");
        DefaultGazetteer defaultGazetteer = (DefaultGazetteer)Factory.createResource("gate.creole.gazetteer.DefaultGazetteer");
        SentenceSplitter sentenceSplitter = (SentenceSplitter)Factory.createResource("gate.creole.splitter.SentenceSplitter");
        POSTagger pOSTagger = (POSTagger)Factory.createResource("gate.creole.POSTagger");
        ANNIETransducer aNNIETransducer = (ANNIETransducer)Factory.createResource("gate.creole.ANNIETransducer");
        OrthoMatcher orthoMatcher = (OrthoMatcher)Factory.createResource("gate.creole.orthomatcher.OrthoMatcher");
        defaultTokeniser.init();
        defaultGazetteer.init();
        sentenceSplitter.init();
        pOSTagger.init();
        aNNIETransducer.init();
        orthoMatcher.init();
        defaultTokeniser.setDocument(document);
        defaultGazetteer.setDocument(document);
        sentenceSplitter.setDocument(document);
        pOSTagger.setDocument(document);
        aNNIETransducer.setDocument(document);
        orthoMatcher.setDocument(document);
        defaultTokeniser.execute();
        defaultGazetteer.execute();
        sentenceSplitter.execute();
        pOSTagger.execute();
        aNNIETransducer.execute();
        orthoMatcher.execute();
    }

    private Document loadDocument(String string) throws Exception {
        FeatureMap featureMap = Factory.newFeatureMap();
        featureMap.clear();
        featureMap.put("sourceUrl", string);
        Document document = (Document)Factory.createResource("gate.corpora.DocumentImpl", featureMap);
        return document;
    }

    public void useCase01() throws Exception {
        System.out.println("starting use case 01...");
        DataStore dataStore = Factory.openDataStore("gate.persist.SerialDataStore", "file:/E:/gate2/serial/debug/");
        dataStore.open();
        List list = dataStore.getLrIds("gate.corpora.DocumentImpl");
        Object e = list.get(0);
        Document document = (Document)dataStore.getLr("gate.corpora.DocumentImpl", e);
        Coreferencer coreferencer = (Coreferencer)Factory.createResource("gate.creole.coref.Coreferencer");
        coreferencer.init();
        coreferencer.setDocument(document);
        System.out.println("starting COREF...");
        coreferencer.execute();
        System.out.println("case 01 finished...");
    }
}

