/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.coref;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Document;
import gate.FeatureMap;
import gate.Node;
import gate.ProcessingResource;
import gate.Resource;
import gate.creole.ANNIEConstants;
import gate.creole.AbstractLanguageAnalyser;
import gate.creole.ExecutionException;
import gate.creole.ResourceInstantiationException;
import gate.creole.Transducer;
import gate.util.Err;
import gate.util.Files;
import gate.util.SimpleFeatureMapImpl;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import junit.framework.Assert;

public class PronominalCoref
extends AbstractLanguageAnalyser
implements ProcessingResource,
ANNIEConstants {
    public static final String COREF_DOCUMENT_PARAMETER_NAME = "document";
    public static final String COREF_ANN_SET_PARAMETER_NAME = "annotationSetName";
    private static final boolean DEBUG = false;
    private static final String QT_GRAMMAR_URL = Files.getGateResource("/creole/coref/quoted_text.jape").toString();
    private static final String PLEON_GRAMMAR_URL = Files.getGateResource("/creole/coref/pleonasm.jape").toString();
    private static final String QUOTED_TEXT_TYPE = "QuotedText";
    private static final String PLEONASTIC_TYPE = "PleonasticIt";
    private static final String PRP_CATEGORY = "PRP";
    private static final String PRP$_CATEGORY = "PRP$";
    private static final int SENTENCES_IN_SCOPE = 3;
    private static AnnotationOffsetComparator ANNOTATION_OFFSET_COMPARATOR = new AnnotationOffsetComparator();
    private String annotationSetName;
    private Transducer qtTransducer;
    private Transducer pleonTransducer;
    private AnnotationSet defaultAnnotations;
    private Sentence[] textSentences;
    private Quote[] quotedText;
    private Annotation[] pleonasticIt;
    private HashMap personGender = new HashMap();
    private HashMap anaphor2antecedent = new HashMap();
    private static final FeatureMap PRP_RESTRICTION = new SimpleFeatureMapImpl();
    private boolean resolveIt = true;

    public PronominalCoref() {
        this.qtTransducer = new Transducer();
        this.pleonTransducer = new Transducer();
    }

    public Resource init() throws ResourceInstantiationException {
        Assert.assertNotNull((Object)this.qtTransducer);
        URL uRL = null;
        try {
            uRL = new URL(QT_GRAMMAR_URL);
        }
        catch (MalformedURLException malformedURLException) {
            throw new ResourceInstantiationException(malformedURLException);
        }
        this.qtTransducer.setGrammarURL(uRL);
        this.qtTransducer.setEncoding("UTF-8");
        this.qtTransducer.init();
        URL uRL2 = null;
        try {
            uRL2 = new URL(PLEON_GRAMMAR_URL);
        }
        catch (MalformedURLException malformedURLException) {
            throw new ResourceInstantiationException(malformedURLException);
        }
        this.pleonTransducer.setGrammarURL(uRL2);
        this.pleonTransducer.setEncoding("UTF-8");
        this.pleonTransducer.init();
        return super.init();
    }

    public void reInit() throws ResourceInstantiationException {
        if (null != this.qtTransducer) {
            this.qtTransducer.reInit();
        }
        if (null != this.pleonTransducer) {
            this.pleonTransducer.reInit();
        }
        this.init();
    }

    public void setDocument(Document document) {
        this.qtTransducer.setDocument(document);
        this.pleonTransducer.setDocument(document);
        super.setDocument(document);
    }

    public void setAnnotationSetName(String string) {
        this.annotationSetName = string;
    }

    public String getAnnotationSetName() {
        return this.annotationSetName;
    }

    public void setResolveIt(Boolean bl) {
        this.resolveIt = bl;
    }

    public Boolean getResolveIt() {
        return new Boolean(this.resolveIt);
    }

    public void execute() throws ExecutionException {
        if (null == this.document) {
            throw new ExecutionException("[coreference] Document is not set!");
        }
        this.preprocess();
        SimpleFeatureMapImpl simpleFeatureMapImpl = new SimpleFeatureMapImpl();
        simpleFeatureMapImpl.put("category", PRP_CATEGORY);
        AnnotationSet annotationSet = this.defaultAnnotations.get("Token", simpleFeatureMapImpl);
        SimpleFeatureMapImpl simpleFeatureMapImpl2 = new SimpleFeatureMapImpl();
        simpleFeatureMapImpl2.put("category", PRP$_CATEGORY);
        AnnotationSet annotationSet2 = this.defaultAnnotations.get("Token", simpleFeatureMapImpl2);
        ArrayList<Annotation> arrayList = new ArrayList<Annotation>();
        if (annotationSet != null && !annotationSet.isEmpty()) {
            arrayList.addAll(annotationSet);
        }
        if (annotationSet2 != null && !annotationSet2.isEmpty()) {
            arrayList.addAll(annotationSet2);
        }
        if (arrayList.isEmpty()) {
            return;
        }
        Object[] objectArray = arrayList.toArray();
        Arrays.sort(objectArray, ANNOTATION_OFFSET_COMPARATOR);
        arrayList = null;
        annotationSet = null;
        annotationSet2 = null;
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            Annotation annotation = (Annotation)objectArray[i];
            while (this.textSentences[n].getEndOffset() < annotation.getEndNode().getOffset()) {
                ++n;
            }
            Sentence sentence = this.textSentences[n];
            Assert.assertTrue((sentence.getStartOffset() <= annotation.getStartNode().getOffset() ? 1 : 0) != 0);
            Assert.assertTrue((sentence.getEndOffset() >= annotation.getEndNode().getOffset() ? 1 : 0) != 0);
            Annotation annotation2 = this.findAntecedent(annotation, n);
            this.anaphor2antecedent.put(annotation, annotation2);
        }
    }

    public HashMap getResolvedAnaphora() {
        return this.anaphor2antecedent;
    }

    private Annotation findAntecedent(Annotation annotation, int n) {
        Assert.assertNotNull((Object)annotation);
        Assert.assertTrue((n >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)annotation.getType().equals("Token"));
        Assert.assertTrue((annotation.getFeatures().get("category").equals(PRP_CATEGORY) || annotation.getFeatures().get("category").equals(PRP$_CATEGORY) ? 1 : 0) != 0);
        String string = (String)annotation.getFeatures().get("string");
        Assert.assertNotNull((Object)string);
        if (string.equalsIgnoreCase("HE") || string.equalsIgnoreCase("HIM") || string.equalsIgnoreCase("HIS") || string.equalsIgnoreCase("HIMSELF")) {
            return this._resolve$HE$HIM$HIS$HIMSELF$(annotation, n);
        }
        if (string.equalsIgnoreCase("SHE") || string.equalsIgnoreCase("HER")) {
            return this._resolve$SHE$HER$(annotation, n);
        }
        if (string.equalsIgnoreCase("IT") || string.equalsIgnoreCase("ITS") || string.equalsIgnoreCase("ITSELF")) {
            return this._resolve$IT$ITS$ITSELF$(annotation, n);
        }
        if (string.equalsIgnoreCase("I") || string.equalsIgnoreCase("ME") || string.equalsIgnoreCase("MY") || string.equalsIgnoreCase("MYSELF")) {
            return this._resolve$I$ME$MY$MYSELF$(annotation, n);
        }
        return null;
    }

    boolean isPleonastic(Annotation annotation) {
        Annotation annotation2;
        Assert.assertNotNull((Object)annotation);
        String string = (String)annotation.getFeatures().get("string");
        Assert.assertTrue((boolean)string.equalsIgnoreCase("IT"));
        if (this.pleonasticIt.length == 0) {
            return false;
        }
        int n = Arrays.binarySearch(this.pleonasticIt, annotation, ANNOTATION_OFFSET_COMPARATOR);
        if (n < 0) {
            n = -n - 1 - 1;
        }
        if (n < 0) {
            n = 0;
        }
        boolean bl = (annotation2 = this.pleonasticIt[n]).getStartNode().getOffset().intValue() <= annotation.getStartNode().getOffset().intValue() && annotation2.getEndNode().getOffset().intValue() >= annotation.getEndNode().getOffset().intValue();
        return bl;
    }

    private Annotation _resolve$HE$HIM$HIS$HIMSELF$(Annotation annotation, int n) {
        Assert.assertTrue((boolean)annotation.getType().equals("Token"));
        Assert.assertTrue((annotation.getFeatures().get("category").equals(PRP_CATEGORY) || annotation.getFeatures().get("category").equals(PRP$_CATEGORY) ? 1 : 0) != 0);
        String string = (String)annotation.getFeatures().get("string");
        Assert.assertTrue((string.equalsIgnoreCase("HE") || string.equalsIgnoreCase("HIM") || string.equalsIgnoreCase("HIS") || string.equalsIgnoreCase("HIMSELF") ? 1 : 0) != 0);
        boolean bl = false;
        int n2 = n - 3;
        if (n2 < 0) {
            n2 = 0;
        }
        int n3 = n;
        Annotation annotation2 = null;
        while (n3 >= n2 || !bl) {
            Sentence sentence = this.textSentences[n3];
            AnnotationSet annotationSet = sentence.getPersons();
            for (Annotation annotation3 : annotationSet) {
                String string2 = (String)this.personGender.get(annotation3);
                if (null != string2 && !string2.equalsIgnoreCase("MALE") && !string2.equalsIgnoreCase("UNKNOWN")) continue;
                bl = true;
                if (null == annotation2) {
                    annotation2 = annotation3;
                    continue;
                }
                annotation2 = this._chooseAntecedent$HE$HIM$HIS$SHE$HER$HIMSELF$(annotation2, annotation3, annotation);
            }
            if (0 != n3--) continue;
            break;
        }
        return annotation2;
    }

    private Annotation _resolve$SHE$HER$(Annotation annotation, int n) {
        Assert.assertTrue((boolean)annotation.getType().equals("Token"));
        Assert.assertTrue((annotation.getFeatures().get("category").equals(PRP_CATEGORY) || annotation.getFeatures().get("category").equals(PRP$_CATEGORY) ? 1 : 0) != 0);
        String string = (String)annotation.getFeatures().get("string");
        Assert.assertTrue((string.equalsIgnoreCase("SHE") || string.equalsIgnoreCase("HER") ? 1 : 0) != 0);
        boolean bl = false;
        int n2 = n - 3;
        if (n2 < 0) {
            n2 = 0;
        }
        int n3 = n;
        Annotation annotation2 = null;
        while (n3 >= n2 || !bl) {
            Sentence sentence = this.textSentences[n3];
            AnnotationSet annotationSet = sentence.getPersons();
            for (Annotation annotation3 : annotationSet) {
                String string2 = (String)this.personGender.get(annotation3);
                if (null != string2 && !string2.equalsIgnoreCase("FEMALE") && !string2.equalsIgnoreCase("UNKNOWN")) continue;
                bl = true;
                if (null == annotation2) {
                    annotation2 = annotation3;
                    continue;
                }
                annotation2 = this._chooseAntecedent$HE$HIM$HIS$SHE$HER$HIMSELF$(annotation2, annotation3, annotation);
            }
            if (0 != n3--) continue;
            break;
        }
        return annotation2;
    }

    private Annotation _resolve$IT$ITS$ITSELF$(Annotation annotation, int n) {
        if (!this.resolveIt) {
            return null;
        }
        Assert.assertTrue((boolean)annotation.getType().equals("Token"));
        Assert.assertTrue((annotation.getFeatures().get("category").equals(PRP_CATEGORY) || annotation.getFeatures().get("category").equals(PRP$_CATEGORY) ? 1 : 0) != 0);
        String string = (String)annotation.getFeatures().get("string");
        Assert.assertTrue((string.equalsIgnoreCase("IT") || string.equalsIgnoreCase("ITS") || string.equalsIgnoreCase("ITSELF") ? 1 : 0) != 0);
        if (string.equalsIgnoreCase("IT") && this.isPleonastic(annotation)) {
            return null;
        }
        int n2 = n - 1;
        if (n2 < 0) {
            n2 = 0;
        }
        int n3 = n;
        Annotation annotation2 = null;
        while (n3 >= n2) {
            Sentence sentence = this.textSentences[n3];
            AnnotationSet annotationSet = sentence.getOrganizations();
            AnnotationSet annotationSet2 = sentence.getLocations();
            HashSet<Annotation> hashSet = new HashSet<Annotation>(annotationSet);
            hashSet.addAll(annotationSet2);
            for (Annotation annotation3 : hashSet) {
                if (null == annotation2) {
                    if (annotation3.getStartNode().getOffset() >= annotation.getStartNode().getOffset()) continue;
                    annotation2 = annotation3;
                    continue;
                }
                annotation2 = this._chooseAntecedent$IT$ITS$ITSELF$(annotation2, annotation3, annotation);
            }
            if (0 != n3--) continue;
            break;
        }
        return annotation2;
    }

    private Annotation _resolve$I$ME$MY$MYSELF$(Annotation annotation, int n) {
        Set<Annotation> set;
        Assert.assertTrue((boolean)annotation.getType().equals("Token"));
        Assert.assertTrue((annotation.getFeatures().get("category").equals(PRP_CATEGORY) || annotation.getFeatures().get("category").equals(PRP$_CATEGORY) ? 1 : 0) != 0);
        String string = (String)annotation.getFeatures().get("string");
        Assert.assertTrue((string.equalsIgnoreCase("I") || string.equalsIgnoreCase("MY") || string.equalsIgnoreCase("ME") || string.equalsIgnoreCase("MYSELF") ? 1 : 0) != 0);
        if (0 == this.quotedText.length) {
            return null;
        }
        Annotation annotation2 = null;
        int n2 = Arrays.binarySearch(this.quotedText, annotation, ANNOTATION_OFFSET_COMPARATOR);
        if (n2 < 0) {
            n2 = -n2 - 1 - 1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        Quote quote = this.quotedText[n2];
        if (annotation.getStartNode().getOffset().intValue() > quote.getEndOffset().intValue() || annotation.getEndNode().getOffset().intValue() < quote.getStartOffset().intValue()) {
            return null;
        }
        Set<Annotation> set2 = quote.getAntecedentCandidates(1);
        if (!set2.isEmpty()) {
            set = set2.iterator();
            while (set.hasNext()) {
                Iterator<Annotation> iterator = set.next();
                if (null != annotation2 && ANNOTATION_OFFSET_COMPARATOR.compare(annotation2, iterator) <= 0) continue;
                annotation2 = iterator;
            }
        }
        if (null == annotation2 && !(set = quote.getAntecedentCandidates(2)).isEmpty()) {
            for (Annotation annotation3 : set) {
                if (null != annotation2 && ANNOTATION_OFFSET_COMPARATOR.compare(annotation2, annotation3) >= 0) continue;
                annotation2 = annotation3;
            }
        }
        if (null == annotation2 && !(set = quote.getAntecedentCandidates(3)).isEmpty()) {
            for (Annotation annotation3 : set) {
                if (null != annotation2 && ANNOTATION_OFFSET_COMPARATOR.compare(annotation2, annotation3) <= 0) continue;
                annotation2 = annotation3;
            }
        }
        return annotation2;
    }

    private void preprocess() throws ExecutionException {
        Object object;
        this.personGender.clear();
        this.anaphor2antecedent.clear();
        this.defaultAnnotations = this.annotationSetName == null || this.annotationSetName.equals("") ? this.document.getAnnotations() : this.document.getAnnotations(this.annotationSetName);
        if (this.defaultAnnotations == null || this.defaultAnnotations.isEmpty()) {
            Err.prln("Coref Warning: No annotations found for processing!");
            return;
        }
        AnnotationSet annotationSet = this.defaultAnnotations.get(QUOTED_TEXT_TYPE);
        if (annotationSet != null && !annotationSet.isEmpty()) {
            this.defaultAnnotations.removeAll(annotationSet);
        }
        this.qtTransducer.execute();
        AnnotationSet annotationSet2 = this.defaultAnnotations.get(PLEONASTIC_TYPE);
        if (annotationSet2 != null && !annotationSet2.isEmpty()) {
            this.defaultAnnotations.removeAll(annotationSet2);
        }
        this.pleonTransducer.execute();
        AnnotationSet annotationSet3 = this.defaultAnnotations.get("Sentence");
        this.textSentences = new Sentence[annotationSet3.size()];
        Object[] objectArray = annotationSet3.toArray();
        Arrays.sort(objectArray, ANNOTATION_OFFSET_COMPARATOR);
        for (int i = 0; i < objectArray.length; ++i) {
            object = (Object[])objectArray[i];
            Long l = object.getStartNode().getOffset();
            Long l2 = object.getEndNode().getOffset();
            AnnotationSet annotationSet4 = this.defaultAnnotations.get("Person", l, l2);
            AnnotationSet annotationSet5 = this.defaultAnnotations.get("Organization", l, l2);
            AnnotationSet annotationSet6 = this.defaultAnnotations.get("Location", l, l2);
            this.textSentences[i] = new Sentence(i, 0, l, l2, annotationSet4, annotationSet5, annotationSet6);
            for (Annotation annotation : annotationSet4) {
                String string = this.findPersonGender(annotation);
                this.personGender.put(annotation, string);
            }
        }
        AnnotationSet annotationSet7 = this.defaultAnnotations.get(QUOTED_TEXT_TYPE);
        if (null == annotationSet7) {
            this.quotedText = new Quote[0];
        } else {
            this.quotedText = new Quote[annotationSet7.size()];
            object = annotationSet7.toArray();
            Arrays.sort(object, ANNOTATION_OFFSET_COMPARATOR);
            for (int i = 0; i < ((Object)object).length; ++i) {
                this.quotedText[i] = new Quote((Annotation)object[i], i);
            }
        }
        object = this.defaultAnnotations.get(PLEONASTIC_TYPE);
        if (null == object) {
            this.pleonasticIt = new Annotation[0];
        } else {
            this.pleonasticIt = new Annotation[object.size()];
            Object[] objectArray2 = object.toArray();
            Arrays.sort(objectArray2, ANNOTATION_OFFSET_COMPARATOR);
            for (int i = 0; i < this.pleonasticIt.length; ++i) {
                this.pleonasticIt[i] = (Annotation)objectArray2[i];
            }
        }
    }

    private String findPersonGender(Annotation annotation) {
        List list;
        String string = (String)annotation.getFeatures().get("gender");
        if (null == string && null != (list = (List)annotation.getFeatures().get("matches"))) {
            for (Integer n : list) {
                Annotation annotation2 = this.defaultAnnotations.get(n);
                Assert.assertTrue((boolean)annotation2.getType().equalsIgnoreCase("Person"));
                String string2 = (String)annotation2.getFeatures().get("gender");
                if (null == string2) continue;
                string = string2;
                break;
            }
        }
        return string;
    }

    private Annotation _chooseAntecedent$HE$HIM$HIS$SHE$HER$HIMSELF$(Annotation annotation, Annotation annotation2, Annotation annotation3) {
        Assert.assertNotNull((Object)annotation);
        Assert.assertNotNull((Object)annotation2);
        Assert.assertNotNull((Object)annotation3);
        Assert.assertTrue((annotation3.getFeatures().get("category").equals(PRP_CATEGORY) || annotation3.getFeatures().get("category").equals(PRP$_CATEGORY) ? 1 : 0) != 0);
        String string = (String)annotation3.getFeatures().get("string");
        Assert.assertTrue((string.equalsIgnoreCase("SHE") || string.equalsIgnoreCase("HER") || string.equalsIgnoreCase("HE") || string.equalsIgnoreCase("HIM") || string.equalsIgnoreCase("HIS") || string.equalsIgnoreCase("HIMSELF") ? 1 : 0) != 0);
        Long l = annotation.getStartNode().getOffset();
        Long l2 = annotation2.getStartNode().getOffset();
        Long l3 = annotation3.getStartNode().getOffset();
        long l4 = l3 - l;
        long l5 = l3 - l2;
        if (l4 == 0L) {
            return annotation2;
        }
        if (l5 == 0L) {
            return annotation;
        }
        if (l4 > 0L && l5 > 0L) {
            if (l4 < l5) {
                return annotation;
            }
            return annotation2;
        }
        if (l4 < 0L && l5 < 0L) {
            if (Math.abs(l4) < Math.abs(l5)) {
                return annotation;
            }
            return annotation2;
        }
        Assert.assertTrue((Math.abs(l4 + l5) < Math.abs(l4) + Math.abs(l5) ? 1 : 0) != 0);
        if (l4 > 0L) {
            return annotation;
        }
        return annotation2;
    }

    private Annotation _chooseAntecedent$IT$ITS$ITSELF$(Annotation annotation, Annotation annotation2, Annotation annotation3) {
        Assert.assertNotNull((Object)annotation);
        Assert.assertNotNull((Object)annotation2);
        Assert.assertNotNull((Object)annotation3);
        Assert.assertTrue((annotation3.getFeatures().get("category").equals(PRP_CATEGORY) || annotation3.getFeatures().get("category").equals(PRP$_CATEGORY) ? 1 : 0) != 0);
        String string = (String)annotation3.getFeatures().get("string");
        Assert.assertTrue((string.equalsIgnoreCase("IT") || string.equalsIgnoreCase("ITS") || string.equalsIgnoreCase("ITSELF") ? 1 : 0) != 0);
        Long l = annotation.getStartNode().getOffset();
        Long l2 = annotation2.getStartNode().getOffset();
        Long l3 = annotation3.getStartNode().getOffset();
        long l4 = l3 - l;
        long l5 = l3 - l2;
        if (l4 == 0L) {
            return annotation2;
        }
        if (l5 == 0L) {
            return annotation;
        }
        if (l4 > 0L && l5 > 0L) {
            if (l4 < l5) {
                return annotation;
            }
            return annotation2;
        }
        if (l4 > 0L) {
            Assert.assertTrue((Math.abs(l4 + l5) < Math.abs(l4) + Math.abs(l5) ? 1 : 0) != 0);
            return annotation;
        }
        if (l5 > 0L) {
            Assert.assertTrue((Math.abs(l4 + l5) < Math.abs(l4) + Math.abs(l5) ? 1 : 0) != 0);
            return annotation2;
        }
        return null;
    }

    static {
        PRP_RESTRICTION.put("category", PRP_CATEGORY);
    }

    private class Sentence {
        private int sentNumber;
        private int paraNumber;
        private Long startOffset;
        private Long endOffset;
        private AnnotationSet persons;
        private AnnotationSet organizations;
        private AnnotationSet locations;

        public Sentence(int n, int n2, Long l, Long l2, AnnotationSet annotationSet, AnnotationSet annotationSet2, AnnotationSet annotationSet3) {
            this.sentNumber = n;
            this.paraNumber = n2;
            this.startOffset = l;
            this.endOffset = l2;
            this.persons = annotationSet;
            this.organizations = annotationSet2;
            this.locations = annotationSet3;
        }

        public Long getStartOffset() {
            return this.startOffset;
        }

        public Long getEndOffset() {
            return this.endOffset;
        }

        public AnnotationSet getPersons() {
            return this.persons;
        }

        public AnnotationSet getOrganizations() {
            return this.organizations;
        }

        public AnnotationSet getLocations() {
            return this.locations;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Quote {
        public static final int ANTEC_AFTER = 1;
        public static final int ANTEC_BEFORE = 2;
        public static final int ANTEC_BACK = 3;
        private Set<Annotation> antecedentsBefore;
        private Set<Annotation> antecedentsAfter;
        private Set<Annotation> antecedentsBackInContext;
        private Annotation quoteAnnotation;
        private int quoteIndex;

        public Quote(Annotation annotation, int n) {
            this.quoteAnnotation = annotation;
            this.quoteIndex = n;
            this.init();
        }

        private void init() {
            int n;
            int n2;
            int n3;
            Assert.assertNotNull((Object)PronominalCoref.this.textSentences);
            SimpleFeatureMapImpl simpleFeatureMapImpl = new SimpleFeatureMapImpl();
            simpleFeatureMapImpl.put("category", PronominalCoref.PRP_CATEGORY);
            int n4 = Arrays.binarySearch(PronominalCoref.this.textSentences, this.quoteAnnotation.getStartNode(), ANNOTATION_OFFSET_COMPARATOR);
            int n5 = n3 = n4 >= 0 ? n4 : -n4 - 1 - 1;
            if (n3 < 0) {
                n3 = 0;
            }
            this.antecedentsBefore = this.generateAntecedentCandidates(n3, this.quoteIndex, 2);
            if (n3 > 0) {
                this.antecedentsBackInContext = this.generateAntecedentCandidates(n3 - 1, this.quoteIndex, 3);
            }
            int n6 = n2 = (n = Arrays.binarySearch(PronominalCoref.this.textSentences, this.quoteAnnotation.getEndNode(), ANNOTATION_OFFSET_COMPARATOR)) >= 0 ? n : -n - 1 - 1;
            if (n2 < 0) {
                n2 = 0;
            }
            this.antecedentsAfter = this.generateAntecedentCandidates(n2, this.quoteIndex, 1);
        }

        private Set<Annotation> generateAntecedentCandidates(int n, int n2, int n3) {
            Object object;
            Object object2;
            Object object3;
            Assert.assertTrue((n >= 0 ? 1 : 0) != 0);
            Assert.assertTrue((n2 >= 0 ? 1 : 0) != 0);
            Assert.assertTrue((n3 == 1 || n3 == 2 || n3 == 3 ? 1 : 0) != 0);
            Sentence sentence = PronominalCoref.this.textSentences[n];
            HashSet<Annotation> hashSet = new HashSet<Annotation>(sentence.getPersons());
            AnnotationSet annotationSet = null;
            switch (n3) {
                case 2: {
                    annotationSet = PronominalCoref.this.defaultAnnotations.getContained(sentence.getStartOffset(), this.getStartOffset());
                    break;
                }
                case 1: {
                    annotationSet = PronominalCoref.this.defaultAnnotations.getContained(this.getEndOffset(), sentence.getEndOffset());
                    break;
                }
                case 3: {
                    annotationSet = PronominalCoref.this.defaultAnnotations.getContained(sentence.getStartOffset(), sentence.getEndOffset());
                }
            }
            if (null != annotationSet && null != (object3 = annotationSet.get("Token", PRP_RESTRICTION))) {
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = (Annotation)object2.next();
                    String string = (String)object.getFeatures().get("string");
                    if (null == string || !string.equalsIgnoreCase("he") && !string.equalsIgnoreCase("she")) continue;
                    hashSet.add((Annotation)object);
                }
            }
            object3 = hashSet.iterator();
            while (object3.hasNext()) {
                object2 = (Annotation)object3.next();
                if (2 == n3 && object2.getStartNode().getOffset().intValue() > this.getStartOffset().intValue()) {
                    object3.remove();
                    continue;
                }
                if (1 == n3 && object2.getStartNode().getOffset().intValue() < this.getEndOffset().intValue()) {
                    object3.remove();
                    continue;
                }
                if (3 != n3 || n2 <= 0) continue;
                object = PronominalCoref.this.quotedText[n2 - 1];
                if (object2.getStartNode().getOffset() >= ((Quote)object).getEndOffset()) continue;
                object3.remove();
            }
            return hashSet;
        }

        public Long getStartOffset() {
            return this.quoteAnnotation.getStartNode().getOffset();
        }

        public Long getEndOffset() {
            return this.quoteAnnotation.getEndNode().getOffset();
        }

        public Set<Annotation> getAntecedentCandidates(int n) {
            switch (n) {
                case 1: {
                    return null != this.antecedentsAfter ? this.antecedentsAfter : new HashSet<Annotation>();
                }
                case 2: {
                    return null != this.antecedentsBefore ? this.antecedentsBefore : new HashSet<Annotation>();
                }
                case 3: {
                    return null != this.antecedentsBackInContext ? this.antecedentsBackInContext : new HashSet<Annotation>();
                }
            }
            throw new IllegalArgumentException();
        }
    }

    private static class AnnotationOffsetComparator
    implements Comparator {
        private AnnotationOffsetComparator() {
        }

        private int _getOffset(Object object) {
            if (object instanceof Annotation) {
                return ((Annotation)object).getEndNode().getOffset().intValue();
            }
            if (object instanceof Sentence) {
                return ((Sentence)object).getStartOffset().intValue();
            }
            if (object instanceof Quote) {
                return ((Quote)object).getStartOffset().intValue();
            }
            if (object instanceof Node) {
                return ((Node)object).getOffset().intValue();
            }
            throw new IllegalArgumentException();
        }

        public int compare(Object object, Object object2) {
            Assert.assertNotNull((Object)object);
            Assert.assertNotNull((Object)object2);
            Assert.assertTrue((object instanceof Annotation || object instanceof Sentence || object instanceof Quote || object instanceof Node ? 1 : 0) != 0);
            Assert.assertTrue((object2 instanceof Annotation || object2 instanceof Sentence || object2 instanceof Quote || object2 instanceof Node ? 1 : 0) != 0);
            int n = this._getOffset(object);
            int n2 = this._getOffset(object2);
            return n - n2;
        }
    }
}

