/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.coref;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Document;
import gate.FeatureMap;
import gate.ProcessingResource;
import gate.Resource;
import gate.creole.ANNIEConstants;
import gate.creole.ExecutionException;
import gate.creole.ResourceInstantiationException;
import gate.creole.coref.AbstractCoreferencer;
import gate.util.Err;
import gate.util.OffsetComparator;
import gate.util.SimpleFeatureMapImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;

public class NominalCoref
extends AbstractCoreferencer
implements ProcessingResource,
ANNIEConstants {
    public static final String COREF_DOCUMENT_PARAMETER_NAME = "document";
    public static final String COREF_ANN_SET_PARAMETER_NAME = "annotationSetName";
    private static final boolean DEBUG = false;
    private static final String PERSON_CATEGORY = "Person";
    private static final String JOBTITLE_CATEGORY = "JobTitle";
    private static final String ORGANIZATION_CATEGORY = "Organization";
    private static final String LOOKUP_CATEGORY = "Lookup";
    private static final String ORGANIZATION_NOUN_CATEGORY = "organization_noun";
    private String annotationSetName;
    private AnnotationSet defaultAnnotations;
    private HashMap anaphor2antecedent = new HashMap();

    public NominalCoref() {
        super("NOMINAL");
    }

    public Resource init() throws ResourceInstantiationException {
        return super.init();
    }

    public void reInit() throws ResourceInstantiationException {
        this.anaphor2antecedent = new HashMap();
        this.init();
    }

    public void setDocument(Document document) {
        super.setDocument(document);
    }

    public void setAnnotationSetName(String string) {
        this.annotationSetName = string;
    }

    public String getAnnotationSetName() {
        return this.annotationSetName;
    }

    public void execute() throws ExecutionException {
        HashMap hashMap = new HashMap();
        if (null == this.document) {
            throw new ExecutionException("[coreference] Document is not set!");
        }
        this.preprocess();
        Object[] objectArray = this.defaultAnnotations.get("Token").toArray();
        Arrays.sort(objectArray, new OffsetComparator());
        int n = 0;
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(PERSON_CATEGORY);
        AnnotationSet annotationSet = this.defaultAnnotations.get(hashSet);
        HashSet<String> hashSet2 = new HashSet<String>();
        hashSet2.add(JOBTITLE_CATEGORY);
        AnnotationSet annotationSet2 = this.defaultAnnotations.get(hashSet2);
        SimpleFeatureMapImpl simpleFeatureMapImpl = new SimpleFeatureMapImpl();
        simpleFeatureMapImpl.put("majorType", ORGANIZATION_NOUN_CATEGORY);
        AnnotationSet annotationSet3 = this.defaultAnnotations.get(LOOKUP_CATEGORY, simpleFeatureMapImpl);
        HashSet<String> hashSet3 = new HashSet<String>();
        hashSet3.add(ORGANIZATION_CATEGORY);
        AnnotationSet annotationSet4 = this.defaultAnnotations.get(hashSet3);
        HashSet<Annotation> hashSet4 = new HashSet<Annotation>();
        if (annotationSet != null) {
            hashSet4.addAll(annotationSet);
        }
        if (annotationSet2 != null) {
            hashSet4.addAll(annotationSet2);
        }
        if (annotationSet3 != null) {
            hashSet4.addAll(annotationSet3);
        }
        if (annotationSet4 != null) {
            hashSet4.addAll(annotationSet4);
        }
        Object[] objectArray2 = hashSet4.toArray();
        Arrays.sort(objectArray2, new OffsetComparator());
        ArrayList<Annotation> arrayList = new ArrayList<Annotation>();
        ArrayList<Annotation> arrayList2 = new ArrayList<Annotation>();
        for (int i = 0; i < objectArray2.length; ++i) {
            Annotation annotation;
            String string;
            Object[] objectArray3;
            Annotation annotation2 = (Annotation)objectArray2[i];
            n = this.advanceTokenPosition(annotation2, n, objectArray);
            if (annotation2.getType().equals(PERSON_CATEGORY)) {
                objectArray3 = this.getSortedTokens(annotation2);
                if (objectArray3.length == 1 && ((string = (String)(annotation = (Annotation)objectArray3[0]).getFeatures().get("category")).equals("PP") || string.equals("PRP") || string.equals("PRP$") || string.equals("PRPR$"))) continue;
                arrayList.add(0, annotation2);
                continue;
            }
            if (annotation2.getType().equals(JOBTITLE_CATEGORY)) {
                String string2;
                Serializable serializable;
                Annotation annotation3;
                String string3;
                objectArray3 = this.getSortedTokens(annotation2);
                annotation = (Annotation)objectArray3[objectArray3.length - 1];
                string = (String)annotation.getFeatures().get("category");
                if (!string.equals("NN") || this.overlapsAnnotations(annotation2, annotationSet) || n != 0 && ((string3 = (String)(annotation3 = (Annotation)objectArray[n - 1]).getFeatures().get("string")).equalsIgnoreCase("a") || string3.equalsIgnoreCase("an") || string3.equalsIgnoreCase("other") || string3.equalsIgnoreCase("another"))) continue;
                if (i < objectArray2.length - 1 && (serializable = (Annotation)objectArray2[i + 1]).getType().equals(PERSON_CATEGORY)) {
                    annotation3 = (Annotation)objectArray[n - 1];
                    string3 = (String)annotation3.getFeatures().get("string");
                    int n2 = this.countInterveningTokens(annotation2, (Annotation)serializable, n, objectArray);
                    if (n2 == 0 && !string3.equalsIgnoreCase("the") || n2 == 1 && !(string2 = (String)this.getFollowingToken(annotation2, n, objectArray).getFeatures().get("string")).equals(",") && !string2.equals("-")) continue;
                    this.anaphor2antecedent.put(annotation2, serializable);
                    continue;
                }
                if (arrayList.size() == 0) {
                    serializable = new SimpleFeatureMapImpl();
                    serializable.put("ENTITY_MENTION_TYPE", "NOMINAL");
                    this.defaultAnnotations.add(annotation2.getStartNode(), annotation2.getEndNode(), PERSON_CATEGORY, (FeatureMap)((Object)serializable));
                    continue;
                }
                int n3 = 0;
                Annotation annotation4 = (Annotation)arrayList.get(n3);
                string2 = (String)annotation4.getFeatures().get("gender");
                String string4 = (String)annotation2.getFeatures().get("gender");
                if (string2 != null && string4 != null && !string2.equals(string4)) continue;
                this.anaphor2antecedent.put(annotation2, annotation4);
                continue;
            }
            if (annotation2.getType().equals(ORGANIZATION_CATEGORY)) {
                arrayList2.add(0, annotation2);
                continue;
            }
            if (!annotation2.getType().equals(LOOKUP_CATEGORY) || arrayList2.size() == 0) continue;
            objectArray3 = this.defaultAnnotations.get("Token", annotation2.getStartNode().getOffset(), annotation2.getEndNode().getOffset()).toArray();
            Arrays.sort(objectArray3, new OffsetComparator());
            annotation = (Annotation)objectArray3[objectArray3.length - 1];
            if (!annotation.getFeatures().get("category").equals("NN")) continue;
            this.anaphor2antecedent.put(annotation2, arrayList2.get(0));
        }
        this.generateCorefChains(this.anaphor2antecedent);
    }

    private boolean overlapsAnnotations(Annotation annotation, AnnotationSet annotationSet) {
        for (Annotation annotation2 : annotationSet) {
            if (!annotation.overlaps(annotation2)) continue;
            return true;
        }
        return false;
    }

    private int advanceTokenPosition(Annotation annotation, int n, Object[] objectArray) {
        block3: {
            long l;
            long l2;
            block2: {
                l2 = annotation.getStartNode().getOffset();
                if (l2 <= (l = ((Annotation)objectArray[n]).getStartNode().getOffset().longValue())) break block2;
                while (l2 > l) {
                    l = ((Annotation)objectArray[++n]).getStartNode().getOffset();
                }
                break block3;
            }
            if (l2 >= l) break block3;
            while (l2 < l) {
                l = ((Annotation)objectArray[--n]).getStartNode().getOffset();
            }
        }
        return n;
    }

    private int countInterveningTokens(Annotation annotation, Annotation annotation2, int n, Object[] objectArray) {
        int n2 = 0;
        long l = annotation.getEndNode().getOffset();
        long l2 = annotation2.getStartNode().getOffset();
        long l3 = ((Annotation)objectArray[n]).getStartNode().getOffset();
        while (l3 < l2) {
            if (l3 >= l) {
                ++n2;
            }
            l3 = ((Annotation)objectArray[++n]).getStartNode().getOffset();
        }
        return n2;
    }

    private Annotation getFollowingToken(Annotation annotation, int n, Object[] objectArray) {
        long l = annotation.getEndNode().getOffset();
        long l2 = ((Annotation)objectArray[n]).getStartNode().getOffset();
        while (l2 < l) {
            l2 = ((Annotation)objectArray[++n]).getStartNode().getOffset();
        }
        return (Annotation)objectArray[n];
    }

    private String stringValue(Annotation annotation) {
        Object[] objectArray = this.getSortedTokens(annotation);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < objectArray.length; ++i) {
            Annotation annotation2 = (Annotation)objectArray[i];
            stringBuffer.append(annotation2.getFeatures().get("string"));
            if (i >= objectArray.length - 1) continue;
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    private Object[] getSortedTokens(Annotation annotation) {
        Object[] objectArray = this.defaultAnnotations.get("Token", annotation.getStartNode().getOffset(), annotation.getEndNode().getOffset()).toArray();
        Arrays.sort(objectArray, new OffsetComparator());
        return objectArray;
    }

    public HashMap getResolvedAnaphora() {
        return this.anaphor2antecedent;
    }

    private void preprocess() throws ExecutionException {
        this.anaphor2antecedent.clear();
        this.defaultAnnotations = this.annotationSetName == null || this.annotationSetName.equals("") ? this.document.getAnnotations() : this.document.getAnnotations(this.annotationSetName);
        if (this.defaultAnnotations == null || this.defaultAnnotations.isEmpty()) {
            Err.prln("Coref Warning: No annotations found for processing!");
            return;
        }
    }
}

