/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annotransfer;

import gate.Annotation;
import gate.AnnotationSet;
import gate.ProcessingResource;
import gate.Resource;
import gate.creole.AbstractLanguageAnalyser;
import gate.creole.ExecutionException;
import gate.creole.ResourceInstantiationException;
import gate.util.GateRuntimeException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class AnnotationSetTransfer
extends AbstractLanguageAnalyser
implements ProcessingResource {
    private static final boolean DEBUG = false;
    public static final String AST_DOCUMENT_PARAMETER_NAME = "document";
    public static final String AST_INPUT_AS_PARAMETER_NAME = "inputASName";
    public static final String AST_OUTPUT_AS_PARAMETER_NAME = "outputASName";
    public static final String AST_TAG_AS_PARAMETER_NAME = "tagASName";
    public static final String AST_TEXT_TAG_PARAMETER_NAME = "textTagName";
    public static final String DEFAULT_OUTPUT_SET_NAME = "Filtered";
    public static final String DEFAULT_TEXT_TAG_NAME = "BODY";
    protected String tagASName = "Original markups";
    protected String outputASName = "Filtered";
    protected String inputASName = null;
    protected String textTagName = "BODY";
    protected AnnotationSet bodyAnnotations = null;
    protected List annotationTypes;

    public Resource init() throws ResourceInstantiationException {
        return super.init();
    }

    public void reInit() throws ResourceInstantiationException {
        this.init();
    }

    public void execute() throws ExecutionException {
        if (this.document == null) {
            throw new GateRuntimeException("No document to process!");
        }
        if (this.inputASName != null && this.inputASName.equals("")) {
            this.inputASName = null;
        }
        if (this.outputASName != null && this.outputASName.equals("")) {
            this.outputASName = null;
        }
        AnnotationSet annotationSet = this.inputASName == null ? this.document.getAnnotations() : this.document.getAnnotations(this.inputASName);
        AnnotationSet annotationSet2 = this.outputASName == null ? this.document.getAnnotations() : this.document.getAnnotations(this.outputASName);
        AnnotationSet annotationSet3 = this.tagASName == null ? this.document.getAnnotations() : this.document.getAnnotations(this.tagASName);
        AnnotationSet annotationSet4 = null;
        if (this.annotationTypes != null && this.annotationTypes.size() > 0) {
            annotationSet4 = annotationSet.get(new HashSet<String>(this.annotationTypes));
        }
        if (annotationSet4 == null) {
            return;
        }
        if (this.textTagName == null || this.textTagName.equals("")) {
            annotationSet2.addAll(annotationSet4);
            return;
        }
        this.bodyAnnotations = annotationSet3.get(this.textTagName);
        if (this.bodyAnnotations == null || this.bodyAnnotations.isEmpty()) {
            annotationSet2.addAll(annotationSet4);
            return;
        }
        ArrayList<Annotation> arrayList = new ArrayList<Annotation>();
        for (Annotation annotation : this.bodyAnnotations) {
            Long l = annotation.getStartNode().getOffset();
            Long l2 = annotation.getEndNode().getOffset();
            AnnotationSet annotationSet5 = annotationSet4.getContained(l, l2);
            arrayList.addAll(annotationSet5);
        }
        annotationSet2.addAll(arrayList);
        annotationSet.removeAll(arrayList);
    }

    public void setTagASName(String string) {
        this.tagASName = "".equals(string) ? null : string;
    }

    public String getTagASName() {
        return this.tagASName;
    }

    public void setInputASName(String string) {
        this.inputASName = string;
    }

    public String getInputASName() {
        return this.inputASName;
    }

    public void setOutputASName(String string) {
        this.outputASName = string;
    }

    public String getOutputASName() {
        return this.outputASName;
    }

    public void setTextTagName(String string) {
        this.textTagName = string;
    }

    public String getTextTagName() {
        return this.textTagName;
    }

    public List getAnnotationTypes() {
        return this.annotationTypes;
    }

    public void setAnnotationTypes(List list) {
        this.annotationTypes = list;
    }
}

