/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annotdelete;

import gate.Annotation;
import gate.AnnotationSet;
import gate.ProcessingResource;
import gate.Resource;
import gate.creole.AbstractLanguageAnalyser;
import gate.creole.ExecutionException;
import gate.creole.ResourceInstantiationException;
import gate.util.GateRuntimeException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AnnotationDeletePR
extends AbstractLanguageAnalyser
implements ProcessingResource {
    public static final String TRANSD_DOCUMENT_PARAMETER_NAME = "document";
    public static final String TRANSD_ANNOT_TYPES_PARAMETER_NAME = "annotationTypes";
    public static final String TRANSD_SETS_KEEP_PARAMETER_NAME = "setsToKeep";
    public static final String TRANSD_SETS_KEEP_ORIGIANL_MARKUPS_ANNOT_SET = "keppOriginalMarkupsAS";
    protected String markupSetName = "Original markups";
    protected List annotationTypes;
    protected List setsToKeep;
    protected Boolean keepOriginalMarkupsAS;

    public Resource init() throws ResourceInstantiationException {
        return super.init();
    }

    public void reInit() throws ResourceInstantiationException {
        this.init();
    }

    public void execute() throws ExecutionException {
        if (this.document == null) {
            throw new GateRuntimeException("No document to process!");
        }
        Map map = null;
        Object v = this.document.getFeatures().get("MatchesAnnots");
        if (v instanceof Map) {
            map = (Map)v;
        }
        if (this.annotationTypes == null || this.annotationTypes.isEmpty()) {
            this.document.getAnnotations().clear();
            this.removeFromDocumentCorefData(null, map);
        } else {
            this.removeSubSet(this.document.getAnnotations(), map);
        }
        Map map2 = this.document.getNamedAnnotationSets();
        if (map2 == null || map2.isEmpty()) {
            return;
        }
        ArrayList arrayList = new ArrayList(map2.keySet());
        Iterator iterator = arrayList.iterator();
        if (this.setsToKeep == null) {
            this.setsToKeep = new ArrayList();
        }
        if (this.keepOriginalMarkupsAS.booleanValue()) {
            this.setsToKeep.add(this.markupSetName);
        } else {
            this.setsToKeep.remove(this.markupSetName);
        }
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string == null || this.setsToKeep != null && this.setsToKeep.contains(string)) continue;
            if (this.annotationTypes == null || this.annotationTypes.isEmpty()) {
                this.document.removeAnnotationSet(string);
                this.removeFromDocumentCorefData(string, map);
                continue;
            }
            this.removeSubSet(this.document.getAnnotations(string), map);
        }
        if (map != null) {
            this.document.getFeatures().put("MatchesAnnots", map);
        }
    }

    private void removeFromDocumentCorefData(String string, Map map) {
        if (map == null) {
            return;
        }
        if (string == null) {
            List list = (List)map.get(string);
            if (list == null || list.size() == 0) {
                return;
            }
            map.put(string, new ArrayList());
        } else {
            map.remove(string);
        }
    }

    private void removeAnnotationsFromCorefData(AnnotationSet annotationSet, String string, Map map) {
        if (map == null) {
            return;
        }
        List list = (List)map.get(string);
        if (list == null) {
            return;
        }
        ArrayList<Annotation> arrayList = new ArrayList<Annotation>(annotationSet);
        for (int i = 0; i < arrayList.size(); ++i) {
            Annotation annotation = arrayList.get(i);
            Iterator iterator = list.iterator();
            ArrayList arrayList2 = new ArrayList();
            while (iterator.hasNext() && !(arrayList2 = (ArrayList)iterator.next()).remove(annotation.getId())) {
            }
            if (arrayList2.size() != 0) continue;
            list.remove(arrayList2);
        }
        if (list.size() == 0) {
            map.remove(string);
        }
    }

    private void removeSubSet(AnnotationSet annotationSet, Map map) {
        AnnotationSet annotationSet2 = annotationSet.get(new HashSet<String>(this.annotationTypes));
        if (annotationSet2 == null || annotationSet2.isEmpty()) {
            return;
        }
        annotationSet.removeAll(annotationSet2);
        this.removeAnnotationsFromCorefData(annotationSet2, annotationSet.getName(), map);
    }

    public void setMarkupASName(String string) {
        this.markupSetName = string;
    }

    public String getMarkupASName() {
        return this.markupSetName;
    }

    public List getAnnotationTypes() {
        return this.annotationTypes;
    }

    public void setAnnotationTypes(List list) {
        this.annotationTypes = list;
    }

    public List getSetsToKeep() {
        return this.setsToKeep;
    }

    public void setSetsToKeep(List list) {
        this.setsToKeep = list;
    }

    public Boolean getKeepOriginalMarkupsAS() {
        return this.keepOriginalMarkupsAS;
    }

    public void setKeepOriginalMarkupsAS(Boolean bl) {
        this.keepOriginalMarkupsAS = bl;
    }
}

