/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.lucene;

import gate.creole.ir.SearchException;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubQueryParser {
    public static void main(String[] stringArray) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            block2: while (true) {
                System.out.print("Query: ");
                String string = bufferedReader.readLine();
                if (string.length() != -1) {
                    ArrayList<String> arrayList = SubQueryParser.parseQuery(string);
                    int n = 0;
                    while (true) {
                        if (n >= arrayList.size()) continue block2;
                        System.out.println("=>" + arrayList.get(n));
                        ++n;
                    }
                }
                break;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static String findWildCardString(int n, String string) {
        String string2 = "";
        if (n + 1 < string.length() && (string.charAt(n + 1) == '*' || string.charAt(n + 1) == '+')) {
            string2 = string.charAt(n + 1) + "";
            for (int i = n + 2; i < string.length() && Character.isDigit(string.charAt(i)); ++i) {
                string2 = string2 + string.charAt(i);
            }
        }
        return string2;
    }

    private static String extractWildcards(String string) throws SearchException {
        block0: while (true) {
            char c = ' ';
            char c2 = ' ';
            for (int i = 0; i < string.length(); ++i) {
                c2 = c;
                c = string.charAt(i);
                if (!SubQueryParser.isOpenBracket(c, c2)) continue;
                int n = SubQueryParser.findBracketClosingPosition(i + 1, string);
                if (n == -1) {
                    throw new SearchException("Invalid Query");
                }
                String string2 = SubQueryParser.findWildCardString(n, string);
                int n2 = 0;
                boolean bl = false;
                int n3 = 1;
                if (string2.length() == 0) continue;
                if (string2.length() == 1) {
                    n2 = 1;
                } else {
                    bl = string2.charAt(0) != '*';
                    n3 = Integer.parseInt(string2.substring(1, string2.length()));
                    n2 = string2.length();
                }
                String string3 = string.substring(0, i);
                String string4 = string.substring(n + n2 + 1, string.length());
                String string5 = string.substring(i, n + 1);
                String string6 = "(";
                for (int j = 1; j <= n3; ++j) {
                    string6 = string6 + "(";
                    for (int k = 0; k < j; ++k) {
                        string6 = string6 + string5;
                    }
                    string6 = string6 + ")";
                    if (j + 1 > n3) continue;
                    string6 = string6 + " | ";
                }
                if (!bl) {
                    string6 = string6 + "| {__o__}";
                }
                string6 = string6 + ")";
                string = string3 + string6 + string4;
                continue block0;
            }
            break;
        }
        return string;
    }

    public static ArrayList<String> parseQuery(String string) throws SearchException {
        ArrayList<String> arrayList = new ArrayList<String>();
        string = string.trim();
        string = "( " + string + " )";
        string = SubQueryParser.extractWildcards(string);
        arrayList.add(string);
        for (int i = 0; i < arrayList.size(); ++i) {
            int n;
            String string2 = (String)arrayList.get(i);
            char c = ' ';
            char c2 = ' ';
            boolean bl = false;
            int n2 = 0;
            String string3 = "";
            for (n = 0; n < string2.length(); ++n) {
                c2 = c;
                c = string2.charAt(n);
                if (SubQueryParser.isOpenBracket(c, c2)) {
                    int n3 = SubQueryParser.findBracketClosingPosition(n + 1, string2);
                    if (n3 == -1) {
                        throw new SearchException("Error in Query!");
                    }
                    ArrayList<String> arrayList2 = SubQueryParser.findOrTokens(string2.substring(n + 1, n3));
                    if (arrayList2.size() > 1) {
                        String string4 = "";
                        if (!bl && string3.length() > 0) {
                            string4 = string3;
                            string3 = "";
                        } else {
                            string4 = i == arrayList.size() - 1 ? "" : arrayList.get(arrayList.size() - 1);
                        }
                        arrayList = SubQueryParser.duplicate(arrayList, string4, n2, arrayList2.size());
                        arrayList = SubQueryParser.writeTokens(arrayList2, arrayList, n2);
                        bl = true;
                        if (n2 == 0) {
                            n2 = 1;
                        }
                        n2 *= arrayList2.size();
                    } else {
                        if (n2 == 0) {
                            if (string3.length() == 0) {
                                arrayList.add("");
                            } else {
                                arrayList.add(string3);
                            }
                            bl = true;
                            string3 = "";
                            n2 = 1;
                        }
                        arrayList = SubQueryParser.writeStringInAll(string2.substring(n + 1, n3), n2, arrayList);
                    }
                    n = n3;
                    continue;
                }
                if (SubQueryParser.isClosingBracket(c, c2)) {
                    throw new SearchException("Error in Query!");
                }
                if (bl) {
                    arrayList = SubQueryParser.writeCharInAll(c, n2, arrayList);
                    continue;
                }
                string3 = string3 + "" + c;
            }
            n = SubQueryParser.scanQueryForOrOrBracket(string2) ? 1 : 0;
            if (n == 0) continue;
            arrayList.remove(i);
            --i;
        }
        ArrayList<String> arrayList3 = new ArrayList<String>();
        for (int i = 0; i < arrayList.size(); ++i) {
            String string5 = (String)arrayList.get(i);
            if (string5.trim().length() == 0 || arrayList3.contains(string5.trim())) continue;
            arrayList3.add(string5.trim());
        }
        return arrayList3;
    }

    public static boolean scanQueryForOrOrBracket(String string) {
        int n = 0;
        int n2 = 0;
        do {
            if ((n = string.indexOf(124, n)) == 0) {
                return true;
            }
            if (n > 0 && string.charAt(n - 1) != '\\') {
                return true;
            }
            if ((n2 = string.indexOf(40, n2)) == 0) {
                return true;
            }
            if (n2 <= 0 || string.charAt(n2 - 1) == '\\') continue;
            return true;
        } while (n >= 0 && n2 >= 0);
        return false;
    }

    private static ArrayList<String> writeTokens(ArrayList<String> arrayList, ArrayList<String> arrayList2, int n) {
        int n2;
        if (n == 0) {
            n = 1;
        }
        ArrayList<String> arrayList3 = new ArrayList<String>();
        for (n2 = 0; n2 < n; ++n2) {
            for (int i = 1; i <= arrayList.size(); ++i) {
                String string = arrayList.get(i - 1);
                if (string.trim().equals("{__o__}")) {
                    string = " ";
                }
                String string2 = arrayList2.get(arrayList2.size() - (n2 * arrayList.size() + i));
                arrayList3.add(string2);
                string2 = string2 + string;
                arrayList2.set(arrayList2.size() - (n2 * arrayList.size() + i), string2);
            }
        }
        for (n2 = 0; n2 < arrayList3.size(); ++n2) {
            arrayList2.remove(arrayList3.get(n2));
        }
        return arrayList2;
    }

    private static ArrayList<String> duplicate(ArrayList<String> arrayList, String string, int n, int n2) {
        int n3;
        if (string == null) {
            string = "";
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (n == 0) {
            arrayList2.add(string);
        } else {
            for (n3 = 0; n3 < n; ++n3) {
                arrayList2.add(arrayList.get(arrayList.size() - (n3 + 1)));
            }
        }
        for (n3 = 0; n3 < arrayList2.size(); ++n3) {
            for (int i = 0; i < n2; ++i) {
                arrayList.add((String)arrayList2.get(n3));
            }
        }
        return arrayList;
    }

    public static ArrayList<String> findOrTokens(String string) {
        int n = 0;
        char c = ' ';
        char c2 = ' ';
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = "";
        for (int i = 0; i < string.length(); ++i) {
            c = c2;
            c2 = string.charAt(i);
            if (SubQueryParser.isOpenBracket(c2, c)) {
                ++n;
                string2 = string2 + "" + c2;
                continue;
            }
            if (SubQueryParser.isClosingBracket(c2, c) && n > 0) {
                --n;
                string2 = string2 + "" + c2;
                continue;
            }
            if (SubQueryParser.isOrSym(c2, c)) {
                if (n > 0) {
                    string2 = string2 + "" + c2;
                    continue;
                }
                arrayList.add(string2);
                string2 = "";
                continue;
            }
            string2 = string2 + "" + c2;
        }
        if (string2.length() > 0) {
            arrayList.add(string2);
        }
        return arrayList;
    }

    private static int findBracketClosingPosition(int n, String string) {
        int n2 = 0;
        char c = ' ';
        char c2 = ' ';
        for (int i = n; i < string.length(); ++i) {
            c = c2;
            c2 = string.charAt(i);
            if (SubQueryParser.isOpenBracket(c2, c)) {
                ++n2;
                continue;
            }
            if (!SubQueryParser.isClosingBracket(c2, c)) continue;
            if (n2 > 0) {
                --n2;
                continue;
            }
            return i;
        }
        return -1;
    }

    private static ArrayList<String> writeCharInAll(char c, int n, ArrayList<String> arrayList) {
        for (int i = 0; i < n; ++i) {
            String string = arrayList.get(arrayList.size() - (i + 1));
            string = string + "" + c;
            arrayList.set(arrayList.size() - (i + 1), string);
        }
        return arrayList;
    }

    private static ArrayList<String> writeStringInAll(String string, int n, ArrayList<String> arrayList) {
        for (int i = 0; i < n; ++i) {
            String string2 = arrayList.get(arrayList.size() - (i + 1));
            string2 = string2 + "" + string;
            arrayList.set(arrayList.size() - (i + 1), string2);
        }
        return arrayList;
    }

    private static boolean isOpenBracket(char c, char c2) {
        return c == '(' && c2 != '\\';
    }

    private static boolean isClosingBracket(char c, char c2) {
        return c == ')' && c2 != '\\';
    }

    private static boolean isOrSym(char c, char c2) {
        return c == '|' && c2 != '\\';
    }
}

