/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.lucene;

import gate.creole.annic.Hit;
import gate.creole.annic.Pattern;
import gate.creole.annic.PatternAnnotation;
import gate.creole.annic.SearchException;
import gate.creole.annic.Searcher;
import gate.creole.annic.apache.lucene.document.Document;
import gate.creole.annic.apache.lucene.index.Term;
import gate.creole.annic.apache.lucene.search.Hits;
import gate.creole.annic.apache.lucene.search.IndexSearcher;
import gate.creole.annic.apache.lucene.search.TermQuery;
import gate.creole.annic.lucene.LuceneQueryResult;
import gate.creole.annic.lucene.LuceneQueryResultList;
import gate.creole.annic.lucene.LuceneSearchThread;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LuceneSearcher
implements Searcher {
    private ArrayList indexLocations = null;
    private String query = null;
    private LuceneQueryResultList resultList = null;
    private int contextWindow = 5;
    private ArrayList annicPatterns = new ArrayList();
    public HashMap annotationTypesMap = new HashMap();
    private Map parameters = null;
    private String corpusToSearchIn = null;
    private Hits luceneHits = null;
    private boolean wasDeleteQuery = false;
    private ArrayList luceneSearchThreads = null;
    private boolean success = false;
    private int luceneSearchThreadIndex = 0;
    private boolean fwdIterationEnded = false;
    private HashMap queryTokens = new HashMap();

    public Hit[] next(int n) throws SearchException {
        this.annotationTypesMap = new HashMap();
        this.annicPatterns = new ArrayList();
        if (!this.success) {
            this.annicPatterns = new ArrayList();
            return this.getHits();
        }
        if (this.fwdIterationEnded) {
            this.annicPatterns = new ArrayList();
            return this.getHits();
        }
        try {
            if (this.wasDeleteQuery) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = 0; i < this.luceneHits.length(); ++i) {
                    Document document = this.luceneHits.doc(i);
                    String string = document.get("DOCUMENT_ID");
                    if (arrayList.contains(string = string.substring(0, string.lastIndexOf("-")))) continue;
                    arrayList.add(string);
                }
                Hit[] hitArray = new Hit[arrayList.size()];
                for (int i = 0; i < hitArray.length; ++i) {
                    hitArray[i] = new Hit((String)arrayList.get(i), 0, 0, "");
                }
                return hitArray;
            }
            while (this.luceneSearchThreadIndex < this.luceneSearchThreads.size()) {
                LuceneSearchThread luceneSearchThread = (LuceneSearchThread)this.luceneSearchThreads.get(this.luceneSearchThreadIndex);
                ArrayList arrayList = luceneSearchThread.next(n);
                if (arrayList != null) {
                    if (n != -1) {
                        n -= arrayList.size();
                    }
                    this.annicPatterns.addAll(arrayList);
                    if (n == 0) {
                        return this.getHits();
                    }
                }
                ++this.luceneSearchThreadIndex;
            }
            this.fwdIterationEnded = true;
            return this.getHits();
        }
        catch (Exception exception) {
            throw new SearchException(exception);
        }
    }

    public boolean search(String string, Map map) throws SearchException {
        String string2;
        this.luceneHits = null;
        this.annicPatterns = new ArrayList();
        this.annotationTypesMap = new HashMap();
        this.luceneSearchThreads = new ArrayList();
        this.luceneSearchThreadIndex = 0;
        this.success = false;
        this.fwdIterationEnded = false;
        this.wasDeleteQuery = false;
        if (map == null) {
            throw new SearchException("Parameters cannot be null");
        }
        this.parameters = map;
        if (map.size() == 2 && map.get("INDEX_LOCATION_URL") != null) {
            String string3 = (String)map.get("CORPUS_ID");
            string2 = new File(((URL)map.get("INDEX_LOCATION_URL")).getFile()).getAbsolutePath();
            if (string3 != null && string2 != null) {
                this.wasDeleteQuery = true;
                Term term = new Term("CORPUS_ID", string3);
                TermQuery termQuery = new TermQuery(term);
                try {
                    IndexSearcher indexSearcher = new IndexSearcher(string2);
                    this.luceneHits = indexSearcher.search(termQuery);
                    this.success = this.luceneHits.length() > 0;
                    return this.success;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    throw new SearchException(iOException);
                }
            }
        }
        if (map.get("INDEX_LOCATIONS") == null) {
            throw new SearchException("Parameter INDEX_LOCATIONS has not been provided!");
        }
        this.indexLocations = new ArrayList((List)map.get("INDEX_LOCATIONS"));
        if (this.indexLocations.size() == 0) {
            throw new SearchException("Corpus is not initialized");
        }
        if (map.get("CONTEXT_WINDOW") == null) {
            throw new SearchException("Parameter CONTEXT_WINDOW is not provided!");
        }
        this.contextWindow = (Integer)map.get("CONTEXT_WINDOW");
        if (this.getContextWindow() <= 0) {
            throw new SearchException("Context Window must be atleast 1 or > 1");
        }
        if (string == null) {
            throw new SearchException("Query is not initialized");
        }
        this.query = string;
        this.corpusToSearchIn = (String)map.get("CORPUS_ID");
        this.annicPatterns = new ArrayList();
        this.annotationTypesMap = new HashMap();
        this.resultList = null;
        this.luceneSearchThreads = new ArrayList();
        for (int i = 0; i < this.indexLocations.size(); ++i) {
            LuceneSearchThread luceneSearchThread = new LuceneSearchThread();
            string2 = (String)this.indexLocations.get(i);
            if (!luceneSearchThread.search(string, this.contextWindow, string2, this.corpusToSearchIn, this)) continue;
            this.luceneSearchThreads.add(luceneSearchThread);
        }
        this.success = this.luceneSearchThreads.size() > 0;
        return this.success;
    }

    private void createAnnicPatterns() {
        ArrayList arrayList = null;
        arrayList = this.resultList == null ? new ArrayList() : new ArrayList(this.resultList.getQueryResultsList());
        for (int i = 0; i < arrayList.size(); ++i) {
            LuceneQueryResult luceneQueryResult = (LuceneQueryResult)arrayList.get(i);
            ArrayList arrayList2 = luceneQueryResult.getFirstTermPositions();
            if (arrayList2 == null || arrayList2.size() <= 0) continue;
            ArrayList arrayList3 = luceneQueryResult.patternLength();
            ArrayList arrayList4 = this.locatePatterns((String)luceneQueryResult.getDocumentID(), luceneQueryResult.getGateAnnotations(), arrayList2, arrayList3, luceneQueryResult.getQuery());
            if (arrayList4 == null) continue;
            this.annicPatterns.addAll(arrayList4);
        }
    }

    private ArrayList locatePatterns(String string, ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3, String string2) {
        ArrayList<Pattern> arrayList4 = new ArrayList<Pattern>();
        for (int i = 0; i < arrayList.size(); ++i) {
            int n;
            ArrayList arrayList5 = (ArrayList)arrayList.get(i);
            if (arrayList5.size() == 0) continue;
            int n2 = Integer.MAX_VALUE;
            int n3 = -1;
            for (int j = 0; j < arrayList5.size(); ++j) {
                PatternAnnotation patternAnnotation = (PatternAnnotation)arrayList5.get(j);
                if (patternAnnotation.getStartOffset() < n2) {
                    n2 = patternAnnotation.getStartOffset();
                }
                if (patternAnnotation.getEndOffset() <= n3) continue;
                n3 = patternAnnotation.getEndOffset();
            }
            char[] cArray = new char[n3 - n2];
            for (n = 0; n < cArray.length; ++n) {
                cArray[n] = 32;
            }
            for (n = 0; n < arrayList5.size(); ++n) {
                PatternAnnotation patternAnnotation = (PatternAnnotation)arrayList5.get(n);
                if (patternAnnotation.getText() == null) continue;
                int n4 = patternAnnotation.getStartOffset() - n2;
                for (int j = 0; j < patternAnnotation.getText().length() && n4 < cArray.length; ++j, ++n4) {
                    cArray[n4] = patternAnnotation.getText().charAt(j);
                }
                if (this.annotationTypesMap.keySet().contains(patternAnnotation.getType())) {
                    ArrayList arrayList6 = (ArrayList)this.annotationTypesMap.get(patternAnnotation.getType());
                    HashMap<String, String> hashMap = patternAnnotation.getFeatures();
                    if (hashMap != null) {
                        for (String string3 : hashMap.keySet()) {
                            if (arrayList6.contains(string3)) continue;
                            arrayList6.add(string3);
                        }
                    }
                    this.annotationTypesMap.put(patternAnnotation.getType(), arrayList6);
                    continue;
                }
                HashMap<String, String> hashMap = patternAnnotation.getFeatures();
                ArrayList<String> arrayList7 = new ArrayList<String>();
                arrayList7.add("All");
                if (hashMap != null) {
                    arrayList7.addAll(hashMap.keySet());
                }
                this.annotationTypesMap.put(patternAnnotation.getType(), arrayList7);
            }
            n = (Integer)arrayList2.get(i);
            int n5 = (Integer)arrayList3.get(i);
            int n6 = Integer.MAX_VALUE;
            for (int j = 0; j < arrayList5.size(); ++j) {
                PatternAnnotation patternAnnotation = (PatternAnnotation)arrayList5.get(j);
                if (patternAnnotation.getPosition() != n || patternAnnotation.getStartOffset() >= n6) continue;
                n6 = patternAnnotation.getStartOffset();
            }
            if (n6 == Integer.MAX_VALUE) {
                System.out.println("Ignoring!");
                continue;
            }
            if (n6 < n2 || n5 > n3) continue;
            Pattern pattern = new Pattern(string, new String(cArray), n6, n5, n2, n3, arrayList5, string2);
            arrayList4.add(pattern);
        }
        return arrayList4;
    }

    public String getQuery() {
        return this.query;
    }

    public Integer getContextWindow() {
        return new Integer(this.contextWindow);
    }

    public Hit[] getHits() {
        if (this.annicPatterns == null) {
            this.annicPatterns = new ArrayList();
        }
        Hit[] hitArray = new Hit[this.annicPatterns.size()];
        for (int i = 0; i < this.annicPatterns.size(); ++i) {
            hitArray[i] = (Pattern)this.annicPatterns.get(i);
        }
        return hitArray;
    }

    public Map getAnnotationTypesMap() {
        return this.annotationTypesMap;
    }

    public Map getParameters() {
        return this.parameters;
    }

    public synchronized ArrayList getQueryTokens(String string) {
        return (ArrayList)this.queryTokens.get(string);
    }

    public synchronized void addQueryTokens(String string, ArrayList arrayList) {
        this.queryTokens.put(string, arrayList);
    }

    public void exportResults(File file) {
        throw new RuntimeException("ExportResults method is not implemented yet!");
    }
}

