/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.lucene;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import gate.creole.annic.Pattern;
import gate.creole.annic.PatternAnnotation;
import gate.creole.annic.SearchException;
import gate.creole.annic.apache.lucene.analysis.Token;
import gate.creole.annic.apache.lucene.search.Hits;
import gate.creole.annic.apache.lucene.search.Query;
import gate.creole.annic.lucene.LuceneIndexSearcher;
import gate.creole.annic.lucene.LuceneQueryResult;
import gate.creole.annic.lucene.LuceneSearcher;
import gate.creole.annic.lucene.PatternValidator;
import gate.creole.annic.lucene.QueryParser;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;

public class LuceneSearchThread {
    private static boolean DEBUG = false;
    private int contextWindow;
    private String indexLocation;
    private QueryParser queryParser;
    private String baseTokenAnnotationType;
    private LuceneSearcher luceneSearcher;
    public boolean finished = false;
    private int documentIDIndex = 0;
    private int queryItemIndex = 0;
    private ArrayList documentIDsList = new ArrayList();
    private HashMap searchResultInfoMap = new HashMap();
    private int ftpIndex = 0;
    private boolean success = false;
    private boolean fwdIterationEnded = false;
    private String documentIDInUse = null;
    private ArrayList tokenStreamInUse = null;
    private String query = null;
    private ArrayList ftp;

    private String getCompatibleName(String string) {
        return string.replaceAll("[\\/:\\*\\?\"<>|]", "_");
    }

    public boolean search(String string, int n, String string2, String string3, LuceneSearcher luceneSearcher) throws SearchException {
        this.query = string;
        this.contextWindow = n;
        this.indexLocation = string2;
        this.queryParser = new QueryParser();
        this.luceneSearcher = luceneSearcher;
        this.searchResultInfoMap = new HashMap();
        this.documentIDIndex = 0;
        this.queryItemIndex = 0;
        this.documentIDsList = new ArrayList();
        this.ftpIndex = -1;
        this.success = false;
        this.fwdIterationEnded = false;
        try {
            String string4 = "";
            for (int i = 0; i < string2.length(); ++i) {
                string4 = string2.charAt(i) == '\\' ? string4 + "/" : string4 + string2.charAt(i);
            }
            string2 = string4;
            File file = new File(string2);
            if (!file.isDirectory()) {
                System.out.println("Skipping the invalid Index Location :" + string2);
                return false;
            }
            if (!string2.endsWith("/")) {
                string2 = string2 + "/";
            }
            if (!(file = new File(string2 + "LuceneIndexDefinition.xml")).exists()) {
                System.out.println("Index Definition file not found - Skipping the invalid Index Location :" + string2 + "LuceneIndexDefinition.xml");
                return false;
            }
            FileReader fileReader = new FileReader(string2 + "LuceneIndexDefinition.xml");
            XStream xStream = new XStream((HierarchicalStreamDriver)new StaxDriver());
            HashMap hashMap = (HashMap)xStream.fromXML((Reader)fileReader);
            fileReader.close();
            this.baseTokenAnnotationType = (String)hashMap.get("BASE_TOKEN_ANNOTATION_TYPE");
            String string5 = (String)hashMap.get("CorpusIndexFeature");
            if (string5 == null || !string5.equals("AnnicIR")) {
                System.out.println("This corpus was not indexed by Annic Index PR - Skipping the invalid Index");
                return false;
            }
            Query[] queryArray = this.queryParser.parse("contents", string, this.baseTokenAnnotationType, string3);
            if (this.queryParser.needValidation()) {
                if (DEBUG) {
                    System.out.println("Validation enabled!");
                }
            } else if (DEBUG) {
                System.out.println("Validation disabled!");
            }
            LuceneIndexSearcher luceneIndexSearcher = new LuceneIndexSearcher(string2);
            for (int i = 0; i < queryArray.length; ++i) {
                luceneIndexSearcher.initializeTermPositions();
                Hits hits = luceneIndexSearcher.search(queryArray[i]);
                ArrayList[] arrayListArray = luceneIndexSearcher.getFirstTermPositions();
                if (arrayListArray[0].size() == 0) continue;
                for (int j = 0; j < hits.length(); ++j) {
                    int n2 = arrayListArray[0].indexOf(new Integer(hits.id(j)));
                    ArrayList arrayList = (ArrayList)arrayListArray[1].get(n2);
                    int n3 = (Integer)arrayListArray[2].get(n2);
                    int n4 = (Integer)arrayListArray[3].get(n2);
                    String string6 = hits.doc(j).get("DOCUMENT_ID");
                    QueryItem queryItem = new QueryItem();
                    queryItem.id = hits.id(j);
                    queryItem.ftp = arrayList;
                    queryItem.patLen = n3;
                    queryItem.qType = n4;
                    queryItem.query = queryArray[i];
                    queryItem.queryString = this.queryParser.getQueryString(i);
                    ArrayList<QueryItem> arrayList2 = (ArrayList<QueryItem>)this.searchResultInfoMap.get(string6);
                    if (arrayList2 == null) {
                        arrayList2 = new ArrayList<QueryItem>();
                        arrayList2.add(queryItem);
                        this.searchResultInfoMap.put(string6, arrayList2);
                        this.documentIDsList.add(string6);
                        continue;
                    }
                    if (this.doesAlreadyExist(queryItem, arrayList2)) continue;
                    arrayList2.add(queryItem);
                    this.searchResultInfoMap.put(string6, arrayList2);
                }
            }
            luceneIndexSearcher.close();
            this.success = this.searchResultInfoMap.size() > 0;
        }
        catch (Exception exception) {
            throw new SearchException(exception);
        }
        return this.success;
    }

    public ArrayList next(int n) throws Exception {
        if (!this.success) {
            return null;
        }
        if (this.fwdIterationEnded) {
            return null;
        }
        int n2 = n;
        ArrayList arrayList = new ArrayList();
        while (this.documentIDIndex < this.documentIDsList.size()) {
            block12: {
                String string = (String)this.documentIDsList.get(this.documentIDIndex);
                ArrayList arrayList2 = (ArrayList)this.searchResultInfoMap.get(string);
                if (this.documentIDInUse == null || !this.documentIDInUse.equals(string) || this.tokenStreamInUse == null) {
                    this.documentIDInUse = string;
                    try {
                        this.tokenStreamInUse = this.getTokenStreamFromDisk(this.indexLocation, this.getCompatibleName(string));
                    }
                    catch (Exception exception) {
                        break block12;
                    }
                }
                while (this.queryItemIndex < arrayList2.size()) {
                    QueryItem queryItem = (QueryItem)arrayList2.get(this.queryItemIndex);
                    int n3 = queryItem.qType;
                    int n4 = queryItem.patLen;
                    if (this.ftp == null) {
                        this.ftp = queryItem.ftp;
                    } else {
                        n3 = 1;
                        n4 = 1;
                    }
                    PatternResult patternResult = this.getTokenStream(this.tokenStreamInUse, n4, n3, this.contextWindow, queryItem.queryString, this.baseTokenAnnotationType, n2);
                    if (patternResult != null && patternResult.numberOfPatterns != 0) {
                        if (n2 != -1) {
                            n2 -= patternResult.numberOfPatterns;
                        }
                        ArrayList arrayList3 = this.createAnnicPatterns(new LuceneQueryResult(this.removeUnitNumber(string), patternResult.firstTermPositions, patternResult.patternLegths, queryItem.qType, patternResult.gateAnnotations, queryItem.queryString));
                        arrayList.addAll(arrayList3);
                        if (n != -1 && n2 == 0) {
                            return arrayList;
                        }
                    }
                    ++this.queryItemIndex;
                    this.ftpIndex = -1;
                    this.ftp = null;
                }
            }
            ++this.documentIDIndex;
            this.queryItemIndex = 0;
            this.ftp = null;
        }
        this.fwdIterationEnded = true;
        return arrayList;
    }

    private ArrayList createAnnicPatterns(LuceneQueryResult luceneQueryResult) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = luceneQueryResult.getFirstTermPositions();
        if (arrayList2 != null && arrayList2.size() > 0) {
            ArrayList arrayList3 = luceneQueryResult.patternLength();
            ArrayList arrayList4 = this.locatePatterns((String)luceneQueryResult.getDocumentID(), luceneQueryResult.getGateAnnotations(), arrayList2, arrayList3, luceneQueryResult.getQuery());
            if (arrayList4 != null) {
                arrayList.addAll(arrayList4);
            }
        }
        return arrayList;
    }

    private ArrayList locatePatterns(String string, ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3, String string2) {
        ArrayList<Pattern> arrayList4 = new ArrayList<Pattern>();
        for (int i = 0; i < arrayList.size(); ++i) {
            int n;
            ArrayList arrayList5 = (ArrayList)arrayList.get(i);
            if (arrayList5.size() == 0) continue;
            int n2 = Integer.MAX_VALUE;
            int n3 = -1;
            for (int j = 0; j < arrayList5.size(); ++j) {
                PatternAnnotation patternAnnotation = (PatternAnnotation)arrayList5.get(j);
                if (patternAnnotation.getStartOffset() < n2) {
                    n2 = patternAnnotation.getStartOffset();
                }
                if (patternAnnotation.getEndOffset() <= n3) continue;
                n3 = patternAnnotation.getEndOffset();
            }
            char[] cArray = new char[n3 - n2];
            for (n = 0; n < cArray.length; ++n) {
                cArray[n] = 32;
            }
            for (n = 0; n < arrayList5.size(); ++n) {
                PatternAnnotation patternAnnotation = (PatternAnnotation)arrayList5.get(n);
                if (patternAnnotation.getText() == null) continue;
                int n4 = patternAnnotation.getStartOffset() - n2;
                for (int j = 0; j < patternAnnotation.getText().length() && n4 < cArray.length; ++j, ++n4) {
                    cArray[n4] = patternAnnotation.getText().charAt(j);
                }
                if (this.luceneSearcher.annotationTypesMap.keySet().contains(patternAnnotation.getType())) {
                    ArrayList arrayList6 = (ArrayList)this.luceneSearcher.annotationTypesMap.get(patternAnnotation.getType());
                    HashMap<String, String> hashMap = patternAnnotation.getFeatures();
                    if (hashMap != null) {
                        for (String string3 : hashMap.keySet()) {
                            if (arrayList6.contains(string3)) continue;
                            arrayList6.add(string3);
                        }
                    }
                    this.luceneSearcher.annotationTypesMap.put(patternAnnotation.getType(), arrayList6);
                    continue;
                }
                HashMap<String, String> hashMap = patternAnnotation.getFeatures();
                ArrayList<String> arrayList7 = new ArrayList<String>();
                arrayList7.add("All");
                if (hashMap != null) {
                    arrayList7.addAll(hashMap.keySet());
                }
                this.luceneSearcher.annotationTypesMap.put(patternAnnotation.getType(), arrayList7);
            }
            n = (Integer)arrayList2.get(i);
            int n5 = (Integer)arrayList3.get(i);
            int n6 = Integer.MAX_VALUE;
            for (int j = 0; j < arrayList5.size(); ++j) {
                PatternAnnotation patternAnnotation = (PatternAnnotation)arrayList5.get(j);
                if (patternAnnotation.getPosition() != n || patternAnnotation.getStartOffset() >= n6) continue;
                n6 = patternAnnotation.getStartOffset();
            }
            if (n6 == Integer.MAX_VALUE || n6 < n2 || n5 > n3) continue;
            Pattern pattern = new Pattern(string, new String(cArray), n6, n5, n2, n3, arrayList5, string2);
            arrayList4.add(pattern);
        }
        return arrayList4;
    }

    private String removeUnitNumber(String string) {
        int n = string.lastIndexOf("-");
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    private ArrayList getTokenStreamFromDisk(String string, String string2) throws Exception {
        if (string.startsWith("file:/")) {
            string = string.substring(6, string.length());
        }
        File file = new File(new File(string, "serialized-files"), string2 + ".annic");
        FileInputStream fileInputStream = new FileInputStream(file);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        ObjectInputStream objectInputStream = new ObjectInputStream(bufferedInputStream);
        ArrayList arrayList = (ArrayList)objectInputStream.readObject();
        if (objectInputStream != null) {
            objectInputStream.close();
        }
        return arrayList;
    }

    private PatternResult getTokenStream(ArrayList arrayList, int n, int n2, int n3, String string, String string2, int n4) {
        if (n2 == 1) {
            return this.getTokenStream(arrayList, n, n3, string, string2, n4);
        }
        String string3 = (String)this.ftp.get(0);
        String string4 = (String)this.ftp.get(1);
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (int i = 0; i < arrayList.size(); ++i) {
            Token token = (Token)arrayList.get(i);
            String string5 = token.termText();
            String string6 = token.type();
            if (string4.equals("*")) {
                if (!string5.equals(string3) || !string4.equals(string6)) continue;
                arrayList2.add(new Integer(token.getPosition()));
                continue;
            }
            if (!string3.equals(string5) || !string4.equals(string6)) continue;
            arrayList2.add(new Integer(token.getPosition()));
        }
        this.ftp = arrayList2;
        return this.getTokenStream(arrayList, 1, n3, string, string2, n4);
    }

    private PatternResult getTokenStream(ArrayList arrayList, int n, int n2, String string, String string2, int n3) {
        int n4;
        ArrayList<Serializable> arrayList2 = new ArrayList<Serializable>();
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        ++this.ftpIndex;
        int n5 = this.ftpIndex;
        while (this.ftpIndex < this.ftp.size() && (n3 == -1 || n3 > 0)) {
            block29: {
                Token token;
                int n6;
                Serializable serializable;
                int n7;
                Token token2;
                int n8 = (Integer)this.ftp.get(this.ftpIndex);
                for (n4 = 0; n4 < arrayList.size() && (token2 = (Token)arrayList.get(n4)).getPosition() != n8; ++n4) {
                }
                int n9 = 0;
                int n10 = -1;
                for (n7 = n4 - 1; n7 >= 0; --n7) {
                    Token token3 = (Token)arrayList.get(n7);
                    if (token3.getPosition() < n8 && token3.termText().equals(string2) && token3.type().equals("*")) {
                        ++n9;
                        n10 = token3.startOffset();
                        n4 = n7;
                    }
                    if (n9 == n2) break;
                }
                --n8;
                if (n10 > -1) {
                    boolean bl = false;
                    for (n7 = n4; n7 < arrayList.size(); ++n7) {
                        Token token4 = (Token)arrayList.get(n7);
                        if (token4.getPosition() == n8) {
                            bl = true;
                            continue;
                        }
                        if (bl) break;
                    }
                }
                int n11 = n10 == -1 ? -1 : n7 - 1;
                int n12 = -1;
                int n13 = 0;
                if (this.queryParser.needValidation()) {
                    try {
                        int n14;
                        ArrayList arrayList4 = this.luceneSearcher.getQueryTokens(string);
                        if (arrayList4 == null) {
                            arrayList4 = new QueryParser().findTokens(string);
                            this.luceneSearcher.addQueryTokens(string, arrayList4);
                        }
                        if ((n12 = ((PatternValidator)((Object)(serializable = new PatternValidator()))).validate(arrayList4, arrayList, n7, new QueryParser())) == -1) {
                            this.ftp.remove(this.ftpIndex);
                            --this.ftpIndex;
                            break block29;
                        }
                        n6 = 0;
                        n13 = ((Token)arrayList.get(n14)).getPosition();
                        for (n14 = n11 + 1; n14 < arrayList.size(); ++n14) {
                            token = (Token)arrayList.get(n14);
                            if (token.endOffset() == n12) {
                                n13 = token.getPosition();
                                n6 = 1;
                                continue;
                            }
                            if (n6 != 0) break;
                        }
                        arrayList3.add(new Integer(n12));
                        n7 = n14;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                } else {
                    n9 = 0;
                    while (n9 < n && n7 < arrayList.size()) {
                        Token token5 = (Token)arrayList.get(n7);
                        if (token5.termText().equals(string2) && token5.type().equals("*")) {
                            ++n9;
                            n12 = token5.endOffset();
                            n13 = token5.getPosition();
                        }
                        ++n7;
                    }
                    arrayList3.add(new Integer(n12));
                    ++n7;
                }
                int n15 = n12;
                while (n7 < arrayList.size() && ((Token)(serializable = (Token)arrayList.get(n7))).getPosition() != n13 + 1) {
                    ++n7;
                }
                n9 = 0;
                while (n7 < arrayList.size()) {
                    serializable = (Token)arrayList.get(n7);
                    if (((Token)serializable).startOffset() >= n12 && ((Token)serializable).termText().equals(string2) && ((Token)serializable).type().equals("*")) {
                        ++n9;
                        n15 = ((Token)serializable).endOffset();
                    }
                    if (n9 == n2) break;
                    ++n7;
                }
                if (n7 < arrayList.size()) {
                    n13 = ((Token)arrayList.get(n7)).getPosition();
                    while (n7 < arrayList.size() && ((Token)(serializable = (Token)arrayList.get(n7))).getPosition() == n13) {
                        ++n7;
                    }
                }
                if (n7 >= arrayList.size()) {
                    n7 = arrayList.size() - 1;
                }
                serializable = new ArrayList();
                PatternAnnotation patternAnnotation = null;
                for (n6 = n4; n6 <= n7; ++n6) {
                    token = (Token)arrayList.get(n6);
                    String string3 = token.termText();
                    int n16 = token.startOffset();
                    int n17 = token.endOffset();
                    String string4 = token.type();
                    int n18 = token.getPosition();
                    if (string4.equals("*")) {
                        patternAnnotation = new PatternAnnotation();
                        patternAnnotation.setType(string3);
                        patternAnnotation.setStOffset(n16);
                        patternAnnotation.setEnOffset(n17);
                        patternAnnotation.setPosition(n18);
                        if (patternAnnotation.getEndOffset() > n15) continue;
                        ((ArrayList)serializable).add(patternAnnotation);
                        continue;
                    }
                    int n19 = string4.indexOf(".");
                    String string5 = string4.substring(n19 + 1, string4.length());
                    if (string5.equals("string")) {
                        patternAnnotation.setText(string3);
                    }
                    patternAnnotation.addFeature(string5, string3);
                }
                arrayList2.add(serializable);
                if (n3 != -1) {
                    --n3;
                }
            }
            ++this.ftpIndex;
        }
        if (n3 == 0 && this.ftpIndex < this.ftp.size()) {
            --this.ftpIndex;
        }
        PatternResult patternResult = new PatternResult();
        patternResult.gateAnnotations = arrayList2;
        patternResult.firstTermPositions = new ArrayList();
        for (n4 = 0; n4 < patternResult.gateAnnotations.size(); ++n4) {
            patternResult.firstTermPositions.add(this.ftp.get(n4 + n5));
        }
        patternResult.patternLegths = arrayList3;
        patternResult.numberOfPatterns = patternResult.gateAnnotations.size();
        return patternResult;
    }

    private boolean doesAlreadyExist(QueryItem queryItem, ArrayList arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            QueryItem queryItem2 = (QueryItem)arrayList.get(i);
            if (!queryItem2.equals(queryItem)) continue;
            return true;
        }
        return false;
    }

    private boolean areTheyEqual(ArrayList arrayList, ArrayList arrayList2, int n) {
        if (n == 1) {
            if (arrayList.size() == arrayList2.size()) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    int n2;
                    int n3 = (Integer)arrayList.get(i);
                    if (n3 == (n2 = ((Integer)arrayList2.get(i)).intValue())) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        String string = (String)arrayList.get(0);
        String string2 = (String)arrayList.get(1);
        String string3 = (String)arrayList2.get(0);
        String string4 = (String)arrayList2.get(1);
        return string3.equals(string) && string4.equals(string2);
    }

    public String getQuery() {
        return this.query;
    }

    private class QueryItem {
        float score;
        int id;
        ArrayList ftp;
        int patLen;
        int qType;
        Query query;
        String queryString;

        private QueryItem() {
        }

        public boolean equals(Object object) {
            if (object instanceof QueryItem) {
                QueryItem queryItem = (QueryItem)object;
                return queryItem.score == this.score && queryItem.id == this.id && queryItem.patLen == this.patLen && queryItem.qType == this.qType && queryItem.queryString.equals(this.queryString) && LuceneSearchThread.this.areTheyEqual(queryItem.ftp, this.ftp, this.qType);
            }
            return false;
        }
    }

    private class PatternResult {
        int numberOfPatterns;
        ArrayList gateAnnotations;
        ArrayList firstTermPositions;
        ArrayList patternLegths;

        private PatternResult() {
        }
    }
}

