/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.lucene;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import gate.Corpus;
import gate.Document;
import gate.Factory;
import gate.creole.annic.IndexException;
import gate.creole.annic.Indexer;
import gate.creole.annic.apache.lucene.analysis.Analyzer;
import gate.creole.annic.apache.lucene.index.IndexReader;
import gate.creole.annic.apache.lucene.index.IndexWriter;
import gate.creole.annic.apache.lucene.index.Term;
import gate.creole.annic.lucene.LuceneAnalyzer;
import gate.creole.annic.lucene.LuceneDocument;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneIndexer
implements Indexer {
    protected boolean DEBUG = false;
    protected Corpus corpus;
    protected Map parameters;
    protected Map noOfIndexUnitsPerDocument;

    public LuceneIndexer(URL uRL) throws IOException {
        if (uRL != null) {
            this.readParametersFromDisk(uRL);
        }
    }

    protected void checkIndexParameters(Map map) throws IndexException {
        this.parameters = map;
        this.noOfIndexUnitsPerDocument = new HashMap();
        if (map == null) {
            throw new IndexException("No parameters provided!");
        }
        URL uRL = (URL)map.get("INDEX_LOCATION_URL");
        if (uRL == null) {
            throw new IndexException("You must provide a URL for INDEX_LOCATION");
        }
        if (!uRL.getProtocol().equalsIgnoreCase("file")) {
            throw new IndexException("Index Output Directory must be set to the empty directory on the file system");
        }
        File file = new File(uRL.getFile());
        if (file.exists() && !file.isDirectory()) {
            throw new IndexException("Path doesn't exist");
        }
        String string = (String)map.get("BASE_TOKEN_ANNOTATION_TYPE");
        String string2 = (String)map.get("INDEX_UNIT_ANNOTATION_TYPE");
        if (this.DEBUG) {
            System.out.println("BTAT : " + string);
            System.out.println("IUAT : " + string2);
        }
        if (string == null || string.trim().length() == 0) {
            throw new IndexException("Base Token Annotation Type not set properly");
        }
    }

    protected Map getIndexParameters() {
        return this.parameters;
    }

    @Override
    public void createIndex(Map map) throws IndexException {
        this.checkIndexParameters(map);
        URL uRL = (URL)this.parameters.get("INDEX_LOCATION_URL");
        try {
            File file = new File(uRL.getFile());
            IndexWriter indexWriter = new IndexWriter(file.getAbsolutePath(), (Analyzer)new LuceneAnalyzer(), true);
            if (this.corpus != null) {
                for (int i = 0; i < this.corpus.size(); ++i) {
                    Document document = (Document)this.corpus.get(i);
                    String string = document.getLRPersistenceId() == null ? document.getName() : document.getLRPersistenceId().toString();
                    System.out.print("Indexing : " + string + " ...");
                    String string2 = this.corpus.getLRPersistenceId() == null ? this.corpus.getName() : this.corpus.getLRPersistenceId().toString();
                    gate.creole.annic.apache.lucene.document.Document[] documentArray = this.getLuceneDoc(string2, document, uRL.toString());
                    if (documentArray == null) {
                        String string3 = (String)this.parameters.get("INDEX_UNIT_ANNOTATION_TYPE");
                        System.err.println("Ignoring Document : There are no annotations of type :" + string3);
                    } else {
                        for (int j = 0; j < documentArray.length; ++j) {
                            if (documentArray[j] == null) continue;
                            indexWriter.addDocument(documentArray[j]);
                        }
                        this.noOfIndexUnitsPerDocument.put(string, new Integer(documentArray.length));
                    }
                    if (document.getLRPersistenceId() != null) {
                        Factory.deleteResource(document);
                    }
                    System.out.println("Done");
                }
            }
            indexWriter.close();
            this.writeParametersToDisk();
        }
        catch (IOException iOException) {
            throw new IndexException(iOException);
        }
    }

    @Override
    public void optimizeIndex() throws IndexException {
        try {
            String string = ((URL)this.parameters.get("INDEX_LOCATION_URL")).toString();
            IndexWriter indexWriter = new IndexWriter(string, (Analyzer)new LuceneAnalyzer(), false);
            indexWriter.optimize();
            indexWriter.close();
        }
        catch (IOException iOException) {
            throw new IndexException(iOException);
        }
    }

    @Override
    public void deleteIndex() throws IndexException {
        boolean bl = true;
        if (this.parameters == null) {
            return;
        }
        File file = new File(((URL)this.parameters.get("INDEX_LOCATION_URL")).getFile());
        if (file.exists() && file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (file2.isDirectory()) {
                    File[] fileArray2 = file2.listFiles();
                    for (int j = 0; j < fileArray2.length; ++j) {
                        File file3 = fileArray2[j];
                        file3.delete();
                    }
                }
                file2.delete();
            }
        }
        this.noOfIndexUnitsPerDocument = new HashMap();
        bl = file.delete();
        if (!bl) {
            throw new IndexException("Can't delete directory" + file.getAbsolutePath());
        }
    }

    @Override
    public void add(String string, List<Document> list) throws IndexException {
        String string2 = new File(((URL)this.parameters.get("INDEX_LOCATION_URL")).getFile()).getAbsolutePath();
        IndexWriter indexWriter = null;
        try {
            indexWriter = new IndexWriter(string2, (Analyzer)new LuceneAnalyzer(), false);
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    Document document = list.get(i);
                    String string3 = document.getLRPersistenceId() == null ? document.getName() : document.getLRPersistenceId().toString();
                    System.out.print("Indexing : " + string3 + " ...");
                    gate.creole.annic.apache.lucene.document.Document[] documentArray = this.getLuceneDoc(string, document, string2);
                    if (documentArray == null) continue;
                    for (int j = 0; j < documentArray.length; ++j) {
                        indexWriter.addDocument(documentArray[j]);
                    }
                    this.noOfIndexUnitsPerDocument.put(string3, new Integer(documentArray.length));
                    System.out.println("Done");
                }
            }
        }
        catch (IOException iOException) {
            throw new IndexException(iOException);
        }
        finally {
            try {
                indexWriter.close();
                this.writeParametersToDisk();
            }
            catch (IOException iOException) {
                throw new IndexException(iOException);
            }
        }
    }

    @Override
    public void remove(List list) throws IndexException {
        String string = new File(((URL)this.parameters.get("INDEX_LOCATION_URL")).getFile()).getAbsolutePath();
        try {
            IndexReader indexReader = IndexReader.open(string);
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    String string2 = list.get(i).toString();
                    Integer n = (Integer)this.noOfIndexUnitsPerDocument.get(string2);
                    if (n == null) continue;
                    System.out.print("Removing => " + string2 + "...");
                    for (int j = 0; j < n; ++j) {
                        String string3 = string2 + "-" + j;
                        Term term = new Term("DOCUMENT_ID", string3);
                        indexReader.delete(term);
                        File file = new File(new File(string, "serialized-files"), string3 + ".annic");
                        if (!file.exists()) continue;
                        file.delete();
                    }
                    this.noOfIndexUnitsPerDocument.remove(string2);
                    System.out.println("Done ");
                }
            }
            indexReader.close();
            this.writeParametersToDisk();
        }
        catch (IOException iOException) {
            throw new IndexException(iOException);
        }
    }

    private gate.creole.annic.apache.lucene.document.Document[] getLuceneDoc(String string, Document document, String string2) throws IndexException {
        String string3 = (String)this.parameters.get("ANNOTATION_SET_NAME");
        String string4 = (String)this.parameters.get("BASE_TOKEN_ANNOTATION_TYPE");
        ArrayList arrayList = new ArrayList((List)this.parameters.get("FEATURES_TO_EXCLUDE"));
        String string5 = (String)this.parameters.get("INDEX_UNIT_ANNOTATION_TYPE");
        String string6 = document.getLRPersistenceId() == null ? document.getName() : document.getLRPersistenceId().toString();
        return new LuceneDocument().createDocument(string, document, string6, string3, arrayList, string2, string4, string5);
    }

    @Override
    public Corpus getCorpus() {
        return this.corpus;
    }

    @Override
    public void setCorpus(Corpus corpus) throws IndexException {
        this.corpus = corpus;
        if (corpus == null) {
            throw new IndexException("Corpus is not initialized");
        }
        corpus.getFeatures().put("CorpusIndexFeature", "AnnicIR");
    }

    private void readParametersFromDisk(URL uRL) throws IOException {
        String string = uRL.toString();
        String string2 = new URL(string).getFile();
        File file = new File(string2, "LuceneIndexDefinition.xml");
        if (!file.exists()) {
            return;
        }
        FileReader fileReader = new FileReader(file);
        XStream xStream = new XStream((HierarchicalStreamDriver)new StaxDriver());
        this.parameters = (HashMap)xStream.fromXML((Reader)fileReader);
        this.noOfIndexUnitsPerDocument = (HashMap)this.parameters.get("NO_OF_INDEX_UNITS_PER_DOCUMENT");
        fileReader.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeParametersToDisk() throws IOException {
        Object object2;
        String string = ((URL)this.parameters.get("INDEX_LOCATION_URL")).toString();
        String string2 = new URL(string).getFile();
        if (!string2.endsWith("/") && !string2.endsWith("\\")) {
            string2 = string2 + "/";
        }
        File file = new File(string2 + "LuceneIndexDefinition.xml");
        FileWriter fileWriter = new FileWriter(file);
        HashMap hashMap = new HashMap();
        for (Object object2 : this.parameters.keySet()) {
            hashMap.put(object2, this.parameters.get(object2));
        }
        hashMap.put("CorpusIndexFeature", "AnnicIR");
        if (this.corpus != null) {
            hashMap.put("CORPUS_SIZE", new Integer(this.corpus.getDocumentNames().size()));
        }
        hashMap.put("NO_OF_INDEX_UNITS_PER_DOCUMENT", this.noOfIndexUnitsPerDocument);
        object2 = new XStream();
        try {
            object2.toXML(hashMap, (Writer)fileWriter);
        }
        finally {
            fileWriter.close();
        }
    }

    @Override
    public Map getParameters() {
        return this.parameters;
    }
}

