/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.lucene;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Document;
import gate.creole.annic.apache.lucene.analysis.Token;
import gate.creole.annic.apache.lucene.document.Field;
import gate.creole.annic.lucene.LuceneReader;
import gate.util.Err;
import gate.util.OffsetComparator;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;

public class LuceneDocument {
    public static final String separator = "\u0000";

    public gate.creole.annic.apache.lucene.document.Document[] createDocument(String string, Document document, String string2, String string3, ArrayList arrayList, String string4, String string5, String string6) {
        AnnotationSet annotationSet;
        AnnotationSet annotationSet2 = annotationSet = string3 == null || string3.trim().length() == 0 ? document.getAnnotations() : document.getAnnotations(string3);
        if (annotationSet.get(string5) == null) {
            Err.println("\nIgnoring the document : " + document.getName() + " since the document does not have annotations of type " + string5);
            return null;
        }
        ArrayList[] arrayListArray = this.getTokens(document, annotationSet, arrayList, string5, string6);
        if (arrayListArray == null) {
            return null;
        }
        gate.creole.annic.apache.lucene.document.Document[] documentArray = new gate.creole.annic.apache.lucene.document.Document[arrayListArray.length];
        for (int i = 0; i < arrayListArray.length; ++i) {
            gate.creole.annic.apache.lucene.document.Document document2 = new gate.creole.annic.apache.lucene.document.Document();
            LuceneReader luceneReader = new LuceneReader(document, arrayListArray[i]);
            document2.add(Field.Keyword("DOCUMENT_ID", string2 + "-" + i));
            if (string != null) {
                document2.add(Field.Keyword("CORPUS_ID", string));
            }
            document2.add(Field.Text("contents", luceneReader));
            try {
                this.writeOnDisk(arrayListArray[i], string2 + "-" + i, string4);
            }
            catch (Exception exception) {
                Err.println("\nIgnoring the document : " + document.getName() + " since its token stream cannot be written on the disk");
                Err.println("Reason: " + exception.getMessage());
                return null;
            }
            documentArray[i] = document2;
        }
        return documentArray;
    }

    private String getCompatibleName(String string) {
        return string.replaceAll("[\\/:\\*\\?\"<>|]", "_");
    }

    private void writeOnDisk(ArrayList arrayList, String string, String string2) throws Exception {
        File file;
        File file2;
        string = this.getCompatibleName(string);
        if (string2.startsWith("file:/")) {
            string2 = string2.substring(6, string2.length());
        }
        if (string2.charAt(1) != ':') {
            string2 = "/" + string2;
        }
        if (!(file2 = new File(file = new File(string2), "serialized-files")).exists()) {
            boolean bl = file2.mkdir();
        }
        if (!file2.exists()) {
            throw new IOException("Directory could not be created :" + file2.getAbsolutePath());
        }
        File file3 = new File(file2, string + ".annic");
        ObjectOutputStream objectOutputStream = null;
        FileOutputStream fileOutputStream = new FileOutputStream(file3);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        objectOutputStream = new ObjectOutputStream(bufferedOutputStream);
        objectOutputStream.writeObject(arrayList);
        if (objectOutputStream != null) {
            objectOutputStream.close();
        }
    }

    private ArrayList[] getTokens(Document document, AnnotationSet annotationSet, ArrayList arrayList, String string, String string2) {
        Object object2;
        ArrayList[] arrayListArray;
        HashSet<Object> hashSet = new HashSet<Object>();
        AnnotationSet annotationSet2 = annotationSet.get(string2);
        if (string2 == null || string2.trim().length() == 0 || annotationSet2 == null) {
            arrayListArray = new OffsetGroup();
            arrayListArray.startOffset = new Long(0L);
            arrayListArray.endOffset = document.getContent().size();
            hashSet.add(arrayListArray);
        } else {
            for (Object object2 : annotationSet2) {
                OffsetGroup offsetGroup = new OffsetGroup();
                offsetGroup.startOffset = object2.getStartNode().getOffset();
                offsetGroup.endOffset = object2.getEndNode().getOffset();
                hashSet.add(offsetGroup);
            }
        }
        arrayListArray = new ArrayList[hashSet.size()];
        object2 = hashSet.iterator();
        int n = 0;
        while (object2.hasNext()) {
            OffsetGroup offsetGroup = (OffsetGroup)object2.next();
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            ArrayList<Annotation> arrayList3 = new ArrayList<Annotation>(annotationSet.getContained(offsetGroup.startOffset, offsetGroup.endOffset));
            if (arrayList3 == null) {
                return null;
            }
            OffsetComparator offsetComparator = new OffsetComparator();
            Collections.sort(arrayList3, offsetComparator);
            int n2 = -1;
            for (int i = 0; i < arrayList3.size(); ++i) {
                Object object3;
                int n3 = 1;
                Annotation annotation = arrayList3.get(i);
                String string3 = annotation.getType();
                if (arrayList.contains(string3)) continue;
                int n4 = annotation.getStartNode().getOffset().intValue();
                int n5 = annotation.getEndNode().getOffset().intValue();
                String string4 = document.getContent().toString().substring(n4, n5);
                if (string4 == null) continue;
                Token token = new Token(string3, n4, n5, "*");
                if (i > 0 && annotation.getStartNode().getOffset().longValue() == arrayList3.get(i - 1).getStartNode().getOffset().longValue()) {
                    token.setPositionIncrement(0);
                    n3 = 0;
                }
                token.setPosition(n2 += n3);
                arrayList2.add(token);
                if (!string3.equals(string) || annotation.getFeatures().get("string") == null) {
                    object3 = new Token(string4, n4, n5, string3 + ".string");
                    ((Token)object3).setPositionIncrement(0);
                    ((Token)object3).setPosition(n2);
                    arrayList2.add(object3);
                }
                object3 = annotation.getFeatures();
                for (String string5 : object3.keySet()) {
                    Object v;
                    if (arrayList.contains(string3 + "." + string5) || (v = object3.get(string5)) == null) continue;
                    String string6 = v.toString();
                    Token token2 = new Token(string6, n4, n5, string3 + "." + string5);
                    token2.setPositionIncrement(0);
                    token2.setPosition(n2);
                    arrayList2.add(token2);
                }
            }
            arrayListArray[n] = arrayList2;
            ++n;
        }
        return arrayListArray;
    }

    private class OffsetGroup {
        Long startOffset;
        Long endOffset;

        private OffsetGroup() {
        }
    }
}

