/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.store;

import gate.creole.annic.apache.lucene.store.Directory;
import gate.creole.annic.apache.lucene.store.FSDirectory;
import gate.creole.annic.apache.lucene.store.InputStream;
import gate.creole.annic.apache.lucene.store.Lock;
import gate.creole.annic.apache.lucene.store.OutputStream;
import gate.creole.annic.apache.lucene.store.RAMFile;
import gate.creole.annic.apache.lucene.store.RAMInputStream;
import gate.creole.annic.apache.lucene.store.RAMOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public final class RAMDirectory
extends Directory {
    Hashtable files = new Hashtable();

    public RAMDirectory() {
    }

    public RAMDirectory(Directory directory) throws IOException {
        this(directory, false);
    }

    private RAMDirectory(Directory directory, boolean bl) throws IOException {
        String[] stringArray = directory.list();
        for (int i = 0; i < stringArray.length; ++i) {
            OutputStream outputStream = this.createFile(stringArray[i]);
            InputStream inputStream = directory.openFile(stringArray[i]);
            int n = (int)inputStream.length();
            byte[] byArray = new byte[n];
            inputStream.readBytes(byArray, 0, n);
            outputStream.writeBytes(byArray, n);
            inputStream.close();
            outputStream.close();
        }
        if (bl) {
            directory.close();
        }
    }

    public RAMDirectory(File file) throws IOException {
        this(FSDirectory.getDirectory(file, false), true);
    }

    public RAMDirectory(String string) throws IOException {
        this(FSDirectory.getDirectory(string, false), true);
    }

    public final String[] list() {
        String[] stringArray = new String[this.files.size()];
        int n = 0;
        Enumeration enumeration = this.files.keys();
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = (String)enumeration.nextElement();
        }
        return stringArray;
    }

    public final boolean fileExists(String string) {
        RAMFile rAMFile = (RAMFile)this.files.get(string);
        return rAMFile != null;
    }

    public final long fileModified(String string) throws IOException {
        RAMFile rAMFile = (RAMFile)this.files.get(string);
        return rAMFile.lastModified;
    }

    public void touchFile(String string) throws IOException {
        long l;
        RAMFile rAMFile = (RAMFile)this.files.get(string);
        long l2 = System.currentTimeMillis();
        do {
            try {
                Thread.sleep(0L, 1);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (l2 == (l = System.currentTimeMillis()));
        rAMFile.lastModified = l;
    }

    public final long fileLength(String string) {
        RAMFile rAMFile = (RAMFile)this.files.get(string);
        return rAMFile.length;
    }

    public final void deleteFile(String string) {
        this.files.remove(string);
    }

    public final void renameFile(String string, String string2) {
        RAMFile rAMFile = (RAMFile)this.files.get(string);
        this.files.remove(string);
        this.files.put(string2, rAMFile);
    }

    public final OutputStream createFile(String string) {
        RAMFile rAMFile = new RAMFile();
        this.files.put(string, rAMFile);
        return new RAMOutputStream(rAMFile);
    }

    public final InputStream openFile(String string) {
        RAMFile rAMFile = (RAMFile)this.files.get(string);
        return new RAMInputStream(rAMFile);
    }

    public final Lock makeLock(final String string) {
        return new Lock(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean obtain() throws IOException {
                Hashtable hashtable = RAMDirectory.this.files;
                synchronized (hashtable) {
                    if (!RAMDirectory.this.fileExists(string)) {
                        RAMDirectory.this.createFile(string).close();
                        return true;
                    }
                    return false;
                }
            }

            public void release() {
                RAMDirectory.this.deleteFile(string);
            }

            public boolean isLocked() {
                return RAMDirectory.this.fileExists(string);
            }
        };
    }

    public final void close() {
    }
}

