/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.store;

import gate.creole.annic.apache.lucene.store.Directory;
import gate.creole.annic.apache.lucene.store.FSInputStream;
import gate.creole.annic.apache.lucene.store.FSOutputStream;
import gate.creole.annic.apache.lucene.store.InputStream;
import gate.creole.annic.apache.lucene.store.Lock;
import gate.creole.annic.apache.lucene.store.OutputStream;
import gate.creole.annic.apache.lucene.util.Constants;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Hashtable;

public final class FSDirectory
extends Directory {
    private static final Hashtable DIRECTORIES = new Hashtable();
    private static final boolean DISABLE_LOCKS = Boolean.getBoolean("disableLuceneLocks") || Constants.JAVA_1_1;
    public static final String LOCK_DIR = System.getProperty("gate.creole.annic.apache.lucene.lockdir", System.getProperty("java.io.tmpdir"));
    private static MessageDigest DIGESTER;
    private byte[] buffer = null;
    private File directory = null;
    private int refCount;
    private File lockDir;
    private static final char[] HEX_DIGITS;

    public static FSDirectory getDirectory(String string, boolean bl) throws IOException {
        return FSDirectory.getDirectory(new File(string), bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FSDirectory getDirectory(File file, boolean bl) throws IOException {
        FSDirectory fSDirectory;
        file = new File(file.getCanonicalPath());
        Object object = DIRECTORIES;
        synchronized (object) {
            fSDirectory = (FSDirectory)DIRECTORIES.get(file);
            if (fSDirectory == null) {
                fSDirectory = new FSDirectory(file, bl);
                DIRECTORIES.put(file, fSDirectory);
            } else if (bl) {
                fSDirectory.create();
            }
        }
        object = fSDirectory;
        synchronized (object) {
            ++fSDirectory.refCount;
        }
        return fSDirectory;
    }

    private FSDirectory(File file, boolean bl) throws IOException {
        this.directory = file;
        this.lockDir = LOCK_DIR == null ? this.directory : new File(LOCK_DIR);
        if (bl) {
            this.create();
        }
        if (!this.directory.isDirectory()) {
            throw new IOException(file + " not a directory");
        }
    }

    private synchronized void create() throws IOException {
        if (!this.directory.exists() && !this.directory.mkdirs()) {
            throw new IOException("Cannot create directory: " + this.directory);
        }
        String[] stringArray = this.directory.list();
        for (int i = 0; i < stringArray.length; ++i) {
            File file = new File(this.directory, stringArray[i]);
            if (file.isDirectory() || file.delete()) continue;
            throw new IOException("Cannot delete " + stringArray[i]);
        }
        String string = this.getLockPrefix().toString();
        stringArray = this.lockDir.list();
        for (int i = 0; i < stringArray.length; ++i) {
            File file;
            if (!stringArray[i].startsWith(string) || (file = new File(this.lockDir, stringArray[i])).delete()) continue;
            throw new IOException("Cannot delete " + stringArray[i]);
        }
    }

    public final String[] list() throws IOException {
        return this.directory.list();
    }

    public final boolean fileExists(String string) throws IOException {
        File file = new File(this.directory, string);
        return file.exists();
    }

    public final long fileModified(String string) throws IOException {
        File file = new File(this.directory, string);
        return file.lastModified();
    }

    public static final long fileModified(File file, String string) throws IOException {
        File file2 = new File(file, string);
        return file2.lastModified();
    }

    public void touchFile(String string) throws IOException {
        File file = new File(this.directory, string);
        file.setLastModified(System.currentTimeMillis());
    }

    public final long fileLength(String string) throws IOException {
        File file = new File(this.directory, string);
        return file.length();
    }

    public final void deleteFile(String string) throws IOException {
        File file = new File(this.directory, string);
        if (!file.delete()) {
            throw new IOException("Cannot delete " + string);
        }
    }

    public final synchronized void renameFile(String string, String string2) throws IOException {
        File file = new File(this.directory, string);
        File file2 = new File(this.directory, string2);
        if (file2.exists() && !file2.delete()) {
            throw new IOException("Cannot delete " + string2);
        }
        if (!file.renameTo(file2)) {
            FileInputStream fileInputStream = null;
            java.io.OutputStream outputStream = null;
            try {
                int n;
                fileInputStream = new FileInputStream(file);
                outputStream = new FileOutputStream(file2);
                if (this.buffer == null) {
                    this.buffer = new byte[1024];
                }
                while ((n = ((java.io.InputStream)fileInputStream).read(this.buffer)) >= 0) {
                    outputStream.write(this.buffer, 0, n);
                }
                file.delete();
            }
            catch (IOException iOException) {
                throw new IOException("Cannot rename " + string + " to " + string2);
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        ((java.io.InputStream)fileInputStream).close();
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException("Cannot close input stream: " + iOException.getMessage());
                    }
                }
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException("Cannot close output stream: " + iOException.getMessage());
                    }
                }
            }
        }
    }

    public final OutputStream createFile(String string) throws IOException {
        return new FSOutputStream(new File(this.directory, string));
    }

    public final InputStream openFile(String string) throws IOException {
        return new FSInputStream(new File(this.directory, string));
    }

    public final Lock makeLock(String string) {
        StringBuffer stringBuffer = this.getLockPrefix();
        stringBuffer.append("-");
        stringBuffer.append(string);
        final File file = new File(this.lockDir, stringBuffer.toString());
        return new Lock(){

            public boolean obtain() throws IOException {
                if (DISABLE_LOCKS) {
                    return true;
                }
                if (!FSDirectory.this.lockDir.exists() && !FSDirectory.this.lockDir.mkdirs()) {
                    throw new IOException("Cannot create lock directory: " + FSDirectory.this.lockDir);
                }
                return file.createNewFile();
            }

            public void release() {
                if (DISABLE_LOCKS) {
                    return;
                }
                file.delete();
            }

            public boolean isLocked() {
                if (DISABLE_LOCKS) {
                    return false;
                }
                return file.exists();
            }

            public String toString() {
                return "Lock@" + file;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuffer getLockPrefix() {
        byte[] byArray;
        String string;
        try {
            string = this.directory.getCanonicalPath();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
        Object object = DIGESTER;
        synchronized (object) {
            byArray = DIGESTER.digest(string.getBytes());
        }
        object = new StringBuffer();
        ((StringBuffer)object).append("lucene-");
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            ((StringBuffer)object).append(HEX_DIGITS[by >> 4 & 0xF]);
            ((StringBuffer)object).append(HEX_DIGITS[by & 0xF]);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void close() throws IOException {
        if (--this.refCount <= 0) {
            Hashtable hashtable = DIRECTORIES;
            synchronized (hashtable) {
                DIRECTORIES.remove(this.directory);
            }
        }
    }

    public File getFile() {
        return this.directory;
    }

    public String toString() {
        return "FSDirectory@" + this.directory;
    }

    static {
        try {
            DIGESTER = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException.toString());
        }
        HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    }
}

