/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.search.spans;

import gate.creole.annic.apache.lucene.index.IndexReader;
import gate.creole.annic.apache.lucene.index.Term;
import gate.creole.annic.apache.lucene.search.Explanation;
import gate.creole.annic.apache.lucene.search.IndexSearcher;
import gate.creole.annic.apache.lucene.search.Query;
import gate.creole.annic.apache.lucene.search.Scorer;
import gate.creole.annic.apache.lucene.search.Searcher;
import gate.creole.annic.apache.lucene.search.Similarity;
import gate.creole.annic.apache.lucene.search.Weight;
import gate.creole.annic.apache.lucene.search.spans.SpanQuery;
import gate.creole.annic.apache.lucene.search.spans.SpanScorer;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;

class SpanWeight
implements Weight {
    private Searcher searcher;
    private float value;
    private float idf;
    private float queryNorm;
    private float queryWeight;
    private Collection terms;
    private SpanQuery query;

    public SpanWeight(SpanQuery spanQuery, Searcher searcher) {
        this.searcher = searcher;
        this.query = spanQuery;
        this.terms = spanQuery.getTerms();
    }

    public Query getQuery() {
        return this.query;
    }

    public float getValue() {
        return this.value;
    }

    public float sumOfSquaredWeights() throws IOException {
        this.idf = this.query.getSimilarity(this.searcher).idf(this.terms, this.searcher);
        this.queryWeight = this.idf * this.query.getBoost();
        return this.queryWeight * this.queryWeight;
    }

    public void normalize(float f) {
        this.queryNorm = f;
        this.queryWeight *= f;
        this.value = this.queryWeight * this.idf;
    }

    public Scorer scorer(IndexReader indexReader, IndexSearcher indexSearcher) throws IOException {
        return new SpanScorer(this.query.getSpans(indexReader), this, this.query.getSimilarity(indexSearcher), indexReader.norms(this.query.getField()));
    }

    public Scorer scorer(IndexReader indexReader) throws IOException {
        return new SpanScorer(this.query.getSpans(indexReader), this, this.query.getSimilarity(this.searcher), indexReader.norms(this.query.getField()));
    }

    public Explanation explain(IndexReader indexReader, int n) throws IOException {
        Serializable serializable;
        Explanation explanation = new Explanation();
        explanation.setDescription("weight(" + this.getQuery() + " in " + n + "), product of:");
        String string = ((SpanQuery)this.getQuery()).getField();
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.terms.iterator();
        while (iterator.hasNext()) {
            serializable = (Term)iterator.next();
            stringBuffer.append(((Term)serializable).text());
            stringBuffer.append("=");
            stringBuffer.append(this.searcher.docFreq((Term)serializable));
            if (!iterator.hasNext()) continue;
            stringBuffer.append(" ");
        }
        serializable = new Explanation(this.idf, "idf(" + string + ": " + stringBuffer + ")");
        Explanation explanation2 = new Explanation();
        explanation2.setDescription("queryWeight(" + this.getQuery() + "), product of:");
        Explanation explanation3 = new Explanation(this.getQuery().getBoost(), "boost");
        if (this.getQuery().getBoost() != 1.0f) {
            explanation2.addDetail(explanation3);
        }
        explanation2.addDetail((Explanation)serializable);
        Explanation explanation4 = new Explanation(this.queryNorm, "queryNorm");
        explanation2.addDetail(explanation4);
        explanation2.setValue(explanation3.getValue() * ((Explanation)serializable).getValue() * explanation4.getValue());
        explanation.addDetail(explanation2);
        Explanation explanation5 = new Explanation();
        explanation5.setDescription("fieldWeight(" + string + ":" + this.query.toString(string) + " in " + n + "), product of:");
        Explanation explanation6 = this.scorer(indexReader).explain(n);
        explanation5.addDetail(explanation6);
        explanation5.addDetail((Explanation)serializable);
        Explanation explanation7 = new Explanation();
        byte[] byArray = indexReader.norms(string);
        float f = byArray != null ? Similarity.decodeNorm(byArray[n]) : 0.0f;
        explanation7.setValue(f);
        explanation7.setDescription("fieldNorm(field=" + string + ", doc=" + n + ")");
        explanation5.addDetail(explanation7);
        explanation5.setValue(explanation6.getValue() * ((Explanation)serializable).getValue() * explanation7.getValue());
        explanation.addDetail(explanation5);
        explanation.setValue(explanation2.getValue() * explanation5.getValue());
        if (explanation2.getValue() == 1.0f) {
            return explanation5;
        }
        return explanation;
    }
}

