/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.search.spans;

import gate.creole.annic.apache.lucene.index.IndexReader;
import gate.creole.annic.apache.lucene.index.Term;
import gate.creole.annic.apache.lucene.index.TermPositions;
import gate.creole.annic.apache.lucene.search.spans.SpanQuery;
import gate.creole.annic.apache.lucene.search.spans.Spans;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class SpanTermQuery
extends SpanQuery {
    private Term term;

    public SpanTermQuery(Term term) {
        this.term = term;
    }

    public Term getTerm() {
        return this.term;
    }

    public String getField() {
        return this.term.field();
    }

    public Collection getTerms() {
        ArrayList<Term> arrayList = new ArrayList<Term>();
        arrayList.add(this.term);
        return arrayList;
    }

    public String toString(String string) {
        if (this.term.field().equals(string)) {
            return this.term.text();
        }
        return this.term.toString();
    }

    public Spans getSpans(final IndexReader indexReader) throws IOException {
        return new Spans(){
            private TermPositions positions;
            private int doc;
            private int freq;
            private int count;
            private int position;
            {
                this.positions = indexReader.termPositions(SpanTermQuery.this.term);
                this.doc = -1;
            }

            public boolean next() throws IOException {
                if (this.count == this.freq) {
                    if (!this.positions.next()) {
                        this.doc = Integer.MAX_VALUE;
                        return false;
                    }
                    this.doc = this.positions.doc();
                    this.freq = this.positions.freq();
                    this.count = 0;
                }
                this.position = this.positions.nextPosition();
                ++this.count;
                return true;
            }

            public boolean skipTo(int n) throws IOException {
                if (!this.positions.skipTo(n)) {
                    this.doc = Integer.MAX_VALUE;
                    return false;
                }
                this.doc = this.positions.doc();
                this.freq = this.positions.freq();
                this.count = 0;
                this.position = this.positions.nextPosition();
                ++this.count;
                return true;
            }

            public int doc() {
                return this.doc;
            }

            public int start() {
                return this.position;
            }

            public int end() {
                return this.position + 1;
            }

            public String toString() {
                return "spans(" + SpanTermQuery.this.toString() + ")@" + (this.doc == -1 ? "START" : (this.doc == Integer.MAX_VALUE ? "END" : this.doc + "-" + this.position));
            }
        };
    }
}

