/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.search.spans;

import gate.creole.annic.apache.lucene.search.Explanation;
import gate.creole.annic.apache.lucene.search.IndexSearcher;
import gate.creole.annic.apache.lucene.search.Scorer;
import gate.creole.annic.apache.lucene.search.Similarity;
import gate.creole.annic.apache.lucene.search.Weight;
import gate.creole.annic.apache.lucene.search.spans.Spans;
import java.io.IOException;

public class SpanScorer
extends Scorer {
    private Spans spans;
    private Weight weight;
    private byte[] norms;
    private float value;
    private boolean firstTime = true;
    private boolean more = true;
    private int doc;
    private float freq;

    SpanScorer(Spans spans, Weight weight, Similarity similarity, byte[] byArray) throws IOException {
        super(similarity);
        this.spans = spans;
        this.norms = byArray;
        this.weight = weight;
        this.value = weight.getValue();
    }

    public boolean next() throws IOException {
        if (this.firstTime) {
            this.more = this.spans.next();
            this.firstTime = false;
        }
        if (!this.more) {
            return false;
        }
        this.freq = 0.0f;
        this.doc = this.spans.doc();
        while (this.more && this.doc == this.spans.doc()) {
            int n = this.spans.end() - this.spans.start();
            this.freq += this.getSimilarity().sloppyFreq(n);
            this.more = this.spans.next();
        }
        return this.more || this.freq != 0.0f;
    }

    public int doc() {
        return this.doc;
    }

    public float score(IndexSearcher indexSearcher) throws IOException {
        return this.score();
    }

    public float score() throws IOException {
        float f = this.getSimilarity().tf(this.freq) * this.value;
        return f * Similarity.decodeNorm(this.norms[this.doc]);
    }

    public boolean skipTo(int n) throws IOException {
        this.more = this.spans.skipTo(n);
        if (!this.more) {
            return false;
        }
        this.freq = 0.0f;
        this.doc = this.spans.doc();
        while (this.more && this.spans.doc() == n) {
            this.freq += this.getSimilarity().sloppyFreq(this.spans.end() - this.spans.start());
            this.more = this.spans.next();
        }
        return this.more || this.freq != 0.0f;
    }

    public Explanation explain(int n) throws IOException {
        Explanation explanation = new Explanation();
        this.skipTo(n);
        float f = this.doc() == n ? this.freq : 0.0f;
        explanation.setValue(this.getSimilarity().tf(f));
        explanation.setDescription("tf(phraseFreq=" + f + ")");
        return explanation;
    }
}

