/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.search.spans;

import gate.creole.annic.apache.lucene.index.IndexReader;
import gate.creole.annic.apache.lucene.search.spans.SpanQuery;
import gate.creole.annic.apache.lucene.search.spans.Spans;
import gate.creole.annic.apache.lucene.util.PriorityQueue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class SpanOrQuery
extends SpanQuery {
    private List clauses;
    private String field;

    public SpanOrQuery(SpanQuery[] spanQueryArray) {
        this.clauses = new ArrayList(spanQueryArray.length);
        for (int i = 0; i < spanQueryArray.length; ++i) {
            SpanQuery spanQuery = spanQueryArray[i];
            if (i == 0) {
                this.field = spanQuery.getField();
            } else if (!spanQuery.getField().equals(this.field)) {
                throw new IllegalArgumentException("Clauses must have same field.");
            }
            this.clauses.add(spanQuery);
        }
    }

    public SpanQuery[] getClauses() {
        return this.clauses.toArray(new SpanQuery[this.clauses.size()]);
    }

    public String getField() {
        return this.field;
    }

    public Collection getTerms() {
        ArrayList arrayList = new ArrayList();
        for (SpanQuery spanQuery : this.clauses) {
            arrayList.addAll(spanQuery.getTerms());
        }
        return arrayList;
    }

    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("spanOr([");
        Iterator iterator = this.clauses.iterator();
        while (iterator.hasNext()) {
            SpanQuery spanQuery = (SpanQuery)iterator.next();
            stringBuffer.append(spanQuery.toString(string));
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("])");
        return stringBuffer.toString();
    }

    public Spans getSpans(final IndexReader indexReader) throws IOException {
        if (this.clauses.size() == 1) {
            return ((SpanQuery)this.clauses.get(0)).getSpans(indexReader);
        }
        return new Spans(){
            private List all;
            private SpanQueue queue;
            private boolean firstTime;
            {
                this.all = new ArrayList(SpanOrQuery.this.clauses.size());
                this.queue = new SpanQueue(SpanOrQuery.this.clauses.size());
                Iterator iterator = SpanOrQuery.this.clauses.iterator();
                while (iterator.hasNext()) {
                    this.all.add(((SpanQuery)iterator.next()).getSpans(indexReader));
                }
                this.firstTime = true;
            }

            public boolean next() throws IOException {
                if (this.firstTime) {
                    for (int i = 0; i < this.all.size(); ++i) {
                        Spans spans = (Spans)this.all.get(i);
                        if (spans.next()) {
                            this.queue.put(spans);
                            continue;
                        }
                        this.all.remove(i--);
                    }
                    this.firstTime = false;
                    return this.queue.size() != 0;
                }
                if (this.queue.size() == 0) {
                    return false;
                }
                if (this.top().next()) {
                    this.queue.adjustTop();
                    return true;
                }
                this.all.remove(this.queue.pop());
                return this.queue.size() != 0;
            }

            private Spans top() {
                return (Spans)this.queue.top();
            }

            public boolean skipTo(int n) throws IOException {
                if (this.firstTime) {
                    for (int i = 0; i < this.all.size(); ++i) {
                        Spans spans = (Spans)this.all.get(i);
                        if (spans.skipTo(n)) {
                            this.queue.put(spans);
                            continue;
                        }
                        this.all.remove(i--);
                    }
                    this.firstTime = false;
                } else {
                    while (this.queue.size() != 0 && this.top().doc() < n) {
                        if (this.top().skipTo(n)) {
                            this.queue.adjustTop();
                            continue;
                        }
                        this.all.remove(this.queue.pop());
                    }
                }
                return this.queue.size() != 0;
            }

            public int doc() {
                return this.top().doc();
            }

            public int start() {
                return this.top().start();
            }

            public int end() {
                return this.top().end();
            }

            public String toString() {
                return "spans(" + SpanOrQuery.this + ")@" + (this.firstTime ? "START" : (this.queue.size() > 0 ? this.doc() + ":" + this.start() + "-" + this.end() : "END"));
            }
        };
    }

    private class SpanQueue
    extends PriorityQueue {
        public SpanQueue(int n) {
            this.initialize(n);
        }

        protected final boolean lessThan(Object object, Object object2) {
            Spans spans = (Spans)object;
            Spans spans2 = (Spans)object2;
            if (spans.doc() == spans2.doc()) {
                if (spans.start() == spans2.start()) {
                    return spans.end() < spans2.end();
                }
                return spans.start() < spans2.start();
            }
            return spans.doc() < spans2.doc();
        }
    }
}

