/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.search.spans;

import gate.creole.annic.apache.lucene.index.IndexReader;
import gate.creole.annic.apache.lucene.search.spans.SpanQuery;
import gate.creole.annic.apache.lucene.search.spans.Spans;
import java.io.IOException;
import java.util.Collection;

public class SpanNotQuery
extends SpanQuery {
    private SpanQuery include;
    private SpanQuery exclude;

    public SpanNotQuery(SpanQuery spanQuery, SpanQuery spanQuery2) {
        this.include = spanQuery;
        this.exclude = spanQuery2;
        if (!spanQuery.getField().equals(spanQuery2.getField())) {
            throw new IllegalArgumentException("Clauses must have same field.");
        }
    }

    public SpanQuery getInclude() {
        return this.include;
    }

    public SpanQuery getExclude() {
        return this.exclude;
    }

    public String getField() {
        return this.include.getField();
    }

    public Collection getTerms() {
        return this.include.getTerms();
    }

    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("spanNot(");
        stringBuffer.append(this.include.toString(string));
        stringBuffer.append(", ");
        stringBuffer.append(this.exclude.toString(string));
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public Spans getSpans(final IndexReader indexReader) throws IOException {
        return new Spans(){
            private Spans includeSpans;
            private boolean moreInclude;
            private Spans excludeSpans;
            private boolean moreExclude;
            {
                this.includeSpans = SpanNotQuery.this.include.getSpans(indexReader);
                this.moreInclude = true;
                this.excludeSpans = SpanNotQuery.this.exclude.getSpans(indexReader);
                this.moreExclude = true;
            }

            public boolean next() throws IOException {
                if (this.moreInclude) {
                    this.moreInclude = this.includeSpans.next();
                }
                while (this.moreInclude && this.moreExclude) {
                    if (this.includeSpans.doc() > this.excludeSpans.doc()) {
                        this.moreExclude = this.excludeSpans.skipTo(this.includeSpans.doc());
                    }
                    while (this.moreExclude && this.includeSpans.doc() == this.excludeSpans.doc() && this.excludeSpans.end() <= this.includeSpans.start()) {
                        this.moreExclude = this.excludeSpans.next();
                    }
                    if (!this.moreExclude || this.includeSpans.doc() != this.excludeSpans.doc() || this.includeSpans.end() <= this.excludeSpans.start()) break;
                    this.moreInclude = this.includeSpans.next();
                }
                return this.moreInclude;
            }

            public boolean skipTo(int n) throws IOException {
                if (this.moreInclude) {
                    this.moreInclude = this.includeSpans.skipTo(n);
                }
                if (!this.moreInclude) {
                    return false;
                }
                if (this.moreExclude && this.includeSpans.doc() > this.excludeSpans.doc()) {
                    this.moreExclude = this.excludeSpans.skipTo(this.includeSpans.doc());
                }
                while (this.moreExclude && this.includeSpans.doc() == this.excludeSpans.doc() && this.excludeSpans.end() <= this.includeSpans.start()) {
                    this.moreExclude = this.excludeSpans.next();
                }
                if (!this.moreExclude || this.includeSpans.doc() != this.excludeSpans.doc() || this.includeSpans.end() <= this.excludeSpans.start()) {
                    return true;
                }
                return this.next();
            }

            public int doc() {
                return this.includeSpans.doc();
            }

            public int start() {
                return this.includeSpans.start();
            }

            public int end() {
                return this.includeSpans.end();
            }

            public String toString() {
                return "spans(" + SpanNotQuery.this.toString() + ")";
            }
        };
    }
}

