/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.search.spans;

import gate.creole.annic.apache.lucene.index.IndexReader;
import gate.creole.annic.apache.lucene.search.spans.NearSpans;
import gate.creole.annic.apache.lucene.search.spans.SpanOrQuery;
import gate.creole.annic.apache.lucene.search.spans.SpanQuery;
import gate.creole.annic.apache.lucene.search.spans.Spans;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class SpanNearQuery
extends SpanQuery {
    private List clauses;
    private int slop;
    private boolean inOrder;
    private String field;

    public SpanNearQuery(SpanQuery[] spanQueryArray, int n, boolean bl) {
        this.clauses = new ArrayList(spanQueryArray.length);
        for (int i = 0; i < spanQueryArray.length; ++i) {
            SpanQuery spanQuery = spanQueryArray[i];
            if (i == 0) {
                this.field = spanQuery.getField();
            } else if (!spanQuery.getField().equals(this.field)) {
                throw new IllegalArgumentException("Clauses must have same field.");
            }
            this.clauses.add(spanQuery);
        }
        this.slop = n;
        this.inOrder = bl;
    }

    public SpanQuery[] getClauses() {
        return this.clauses.toArray(new SpanQuery[this.clauses.size()]);
    }

    public int getSlop() {
        return this.slop;
    }

    public boolean isInOrder() {
        return this.inOrder;
    }

    public String getField() {
        return this.field;
    }

    public Collection getTerms() {
        ArrayList arrayList = new ArrayList();
        for (SpanQuery spanQuery : this.clauses) {
            arrayList.addAll(spanQuery.getTerms());
        }
        return arrayList;
    }

    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("spanNear([");
        Iterator iterator = this.clauses.iterator();
        while (iterator.hasNext()) {
            SpanQuery spanQuery = (SpanQuery)iterator.next();
            stringBuffer.append(spanQuery.toString(string));
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("], ");
        stringBuffer.append(this.slop);
        stringBuffer.append(", ");
        stringBuffer.append(this.inOrder);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public Spans getSpans(IndexReader indexReader) throws IOException {
        if (this.clauses.size() == 0) {
            return new SpanOrQuery(this.getClauses()).getSpans(indexReader);
        }
        if (this.clauses.size() == 1) {
            return ((SpanQuery)this.clauses.get(0)).getSpans(indexReader);
        }
        return new NearSpans(this, indexReader);
    }
}

