/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.search.spans;

import gate.creole.annic.apache.lucene.index.IndexReader;
import gate.creole.annic.apache.lucene.search.spans.SpanQuery;
import gate.creole.annic.apache.lucene.search.spans.Spans;
import java.io.IOException;
import java.util.Collection;

public class SpanFirstQuery
extends SpanQuery {
    private SpanQuery match;
    private int end;

    public SpanFirstQuery(SpanQuery spanQuery, int n) {
        this.match = spanQuery;
        this.end = n;
    }

    public SpanQuery getMatch() {
        return this.match;
    }

    public int getEnd() {
        return this.end;
    }

    public String getField() {
        return this.match.getField();
    }

    public Collection getTerms() {
        return this.match.getTerms();
    }

    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("spanFirst(");
        stringBuffer.append(this.match.toString(string));
        stringBuffer.append(", ");
        stringBuffer.append(this.end);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public Spans getSpans(final IndexReader indexReader) throws IOException {
        return new Spans(){
            private Spans spans;
            {
                this.spans = SpanFirstQuery.this.match.getSpans(indexReader);
            }

            public boolean next() throws IOException {
                while (this.spans.next()) {
                    if (this.end() > SpanFirstQuery.this.end) continue;
                    return true;
                }
                return false;
            }

            public boolean skipTo(int n) throws IOException {
                if (!this.spans.skipTo(n)) {
                    return false;
                }
                if (this.spans.end() <= SpanFirstQuery.this.end) {
                    return true;
                }
                return this.next();
            }

            public int doc() {
                return this.spans.doc();
            }

            public int start() {
                return this.spans.start();
            }

            public int end() {
                return this.spans.end();
            }

            public String toString() {
                return "spans(" + SpanFirstQuery.this.toString() + ")";
            }
        };
    }
}

