/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.search.spans;

import gate.creole.annic.apache.lucene.index.IndexReader;
import gate.creole.annic.apache.lucene.search.spans.SpanNearQuery;
import gate.creole.annic.apache.lucene.search.spans.SpanQuery;
import gate.creole.annic.apache.lucene.search.spans.Spans;
import gate.creole.annic.apache.lucene.util.PriorityQueue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

class NearSpans
implements Spans {
    private SpanNearQuery query;
    private List ordered = new ArrayList();
    private int slop;
    private boolean inOrder;
    private SpansCell first;
    private SpansCell last;
    private int totalLength;
    private CellQueue queue;
    private SpansCell max;
    private boolean more = true;
    private boolean firstTime = true;

    public NearSpans(SpanNearQuery spanNearQuery, IndexReader indexReader) throws IOException {
        this.query = spanNearQuery;
        this.slop = spanNearQuery.getSlop();
        this.inOrder = spanNearQuery.isInOrder();
        SpanQuery[] spanQueryArray = spanNearQuery.getClauses();
        this.queue = new CellQueue(spanQueryArray.length);
        for (int i = 0; i < spanQueryArray.length; ++i) {
            SpansCell spansCell = new SpansCell(spanQueryArray[i].getSpans(indexReader), i);
            this.ordered.add(spansCell);
        }
    }

    public boolean next() throws IOException {
        if (this.firstTime) {
            this.initList(true);
            this.listToQueue();
            this.firstTime = false;
        } else if (this.more) {
            this.more = this.min().next();
            if (this.more) {
                this.queue.adjustTop();
            }
        }
        while (this.more) {
            boolean bl = false;
            if (this.min().doc() != this.max.doc()) {
                this.queueToList();
                bl = true;
            }
            while (this.more && this.first.doc() < this.last.doc()) {
                this.more = this.first.skipTo(this.last.doc());
                this.firstToLast();
                bl = true;
            }
            if (!this.more) {
                return false;
            }
            if (bl) {
                this.listToQueue();
                bl = false;
            }
            if (this.atMatch()) {
                return true;
            }
            if (this.inOrder && this.checkSlop()) {
                this.more = this.firstNonOrderedNextToPartialList();
                if (!this.more) continue;
                this.partialListToQueue();
                continue;
            }
            this.more = this.min().next();
            if (!this.more) continue;
            this.queue.adjustTop();
        }
        return false;
    }

    public boolean skipTo(int n) throws IOException {
        if (this.firstTime) {
            this.initList(false);
            SpansCell spansCell = this.first;
            while (this.more && spansCell != null) {
                this.more = spansCell.skipTo(n);
                spansCell = spansCell.next;
            }
            if (this.more) {
                this.listToQueue();
            }
            this.firstTime = false;
        } else {
            while (this.more && this.min().doc() < n) {
                this.more = this.min().skipTo(n);
                if (!this.more) continue;
                this.queue.adjustTop();
            }
        }
        if (this.more) {
            if (this.atMatch()) {
                return true;
            }
            return this.next();
        }
        return false;
    }

    private SpansCell min() {
        return (SpansCell)this.queue.top();
    }

    public int doc() {
        return this.min().doc();
    }

    public int start() {
        return this.min().start();
    }

    public int end() {
        return this.max.end();
    }

    public String toString() {
        return "spans(" + this.query.toString() + ")@" + (this.firstTime ? "START" : (this.more ? this.doc() + ":" + this.start() + "-" + this.end() : "END"));
    }

    private void initList(boolean bl) throws IOException {
        for (int i = 0; this.more && i < this.ordered.size(); ++i) {
            SpansCell spansCell = (SpansCell)this.ordered.get(i);
            if (bl) {
                this.more = spansCell.next();
            }
            if (!this.more) continue;
            this.addToList(spansCell);
        }
    }

    private void addToList(SpansCell spansCell) {
        if (this.last != null) {
            this.last.next = spansCell;
        } else {
            this.first = spansCell;
        }
        this.last = spansCell;
        spansCell.next = null;
    }

    private void firstToLast() {
        this.last.next = this.first;
        this.last = this.first;
        this.first = this.first.next;
        this.last.next = null;
    }

    private void queueToList() {
        this.first = null;
        this.last = null;
        while (this.queue.top() != null) {
            this.addToList((SpansCell)this.queue.pop());
        }
    }

    private boolean firstNonOrderedNextToPartialList() throws IOException {
        this.first = null;
        this.last = null;
        int n = 0;
        while (this.queue.top() != null) {
            SpansCell spansCell = (SpansCell)this.queue.pop();
            this.addToList(spansCell);
            if (spansCell.index == n) {
                ++n;
                continue;
            }
            return spansCell.next();
        }
        throw new RuntimeException("Unexpected: ordered");
    }

    private void listToQueue() {
        this.queue.clear();
        this.partialListToQueue();
    }

    private void partialListToQueue() {
        SpansCell spansCell = this.first;
        while (spansCell != null) {
            this.queue.put(spansCell);
            spansCell = spansCell.next;
        }
    }

    private boolean atMatch() {
        return this.min().doc() == this.max.doc() && this.checkSlop() && (!this.inOrder || this.matchIsOrdered());
    }

    private boolean checkSlop() {
        int n = this.max.end() - this.min().start();
        return n - this.totalLength <= this.slop;
    }

    private boolean matchIsOrdered() {
        int n = -1;
        for (int i = 0; i < this.ordered.size(); ++i) {
            int n2 = ((SpansCell)this.ordered.get(i)).start();
            if (n2 <= n) {
                return false;
            }
            n = n2;
        }
        return true;
    }

    private class SpansCell
    implements Spans {
        private Spans spans;
        private SpansCell next;
        private int length = -1;
        private int index;

        public SpansCell(Spans spans, int n) {
            this.spans = spans;
            this.index = n;
        }

        public boolean next() throws IOException {
            boolean bl;
            if (this.length != -1) {
                NearSpans.this.totalLength -= this.length;
            }
            if (bl = this.spans.next()) {
                this.length = this.end() - this.start();
                NearSpans.this.totalLength += this.length;
                if (NearSpans.this.max == null || this.doc() > NearSpans.this.max.doc() || this.doc() == NearSpans.this.max.doc() && this.end() > NearSpans.this.max.end()) {
                    NearSpans.this.max = this;
                }
            }
            return bl;
        }

        public boolean skipTo(int n) throws IOException {
            boolean bl;
            if (this.length != -1) {
                NearSpans.this.totalLength -= this.length;
            }
            if (bl = this.spans.skipTo(n)) {
                this.length = this.end() - this.start();
                NearSpans.this.totalLength += this.length;
                if (NearSpans.this.max == null || this.doc() > NearSpans.this.max.doc() || this.doc() == NearSpans.this.max.doc() && this.end() > NearSpans.this.max.end()) {
                    NearSpans.this.max = this;
                }
            }
            return bl;
        }

        public int doc() {
            return this.spans.doc();
        }

        public int start() {
            return this.spans.start();
        }

        public int end() {
            return this.spans.end();
        }

        public String toString() {
            return this.spans.toString() + "#" + this.index;
        }
    }

    private class CellQueue
    extends PriorityQueue {
        public CellQueue(int n) {
            this.initialize(n);
        }

        protected final boolean lessThan(Object object, Object object2) {
            SpansCell spansCell = (SpansCell)object;
            SpansCell spansCell2 = (SpansCell)object2;
            if (spansCell.doc() == spansCell2.doc()) {
                if (spansCell.start() == spansCell2.start()) {
                    if (spansCell.end() == spansCell2.end()) {
                        return spansCell.index > spansCell2.index;
                    }
                    return spansCell.end() < spansCell2.end();
                }
                return spansCell.start() < spansCell2.start();
            }
            return spansCell.doc() < spansCell2.doc();
        }
    }
}

