/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.search;

import gate.creole.annic.apache.lucene.document.Document;
import gate.creole.annic.apache.lucene.index.Term;
import gate.creole.annic.apache.lucene.search.Explanation;
import gate.creole.annic.apache.lucene.search.Filter;
import gate.creole.annic.apache.lucene.search.HitCollector;
import gate.creole.annic.apache.lucene.search.IndexSearcher;
import gate.creole.annic.apache.lucene.search.Query;
import gate.creole.annic.apache.lucene.search.Searchable;
import gate.creole.annic.apache.lucene.search.Sort;
import gate.creole.annic.apache.lucene.search.TopDocs;
import gate.creole.annic.apache.lucene.search.TopFieldDocs;
import java.io.IOException;
import java.rmi.Naming;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;

public class RemoteSearchable
extends UnicastRemoteObject
implements Searchable {
    private Searchable local;

    public RemoteSearchable(Searchable searchable) throws RemoteException {
        this.local = searchable;
    }

    public void search(Query query, Filter filter, HitCollector hitCollector) throws IOException {
        this.local.search(query, filter, hitCollector);
    }

    public void close() throws IOException {
        this.local.close();
    }

    public int docFreq(Term term) throws IOException {
        return this.local.docFreq(term);
    }

    public int maxDoc() throws IOException {
        return this.local.maxDoc();
    }

    public TopDocs search(Query query, Filter filter, int n) throws IOException {
        return this.local.search(query, filter, n);
    }

    public TopFieldDocs search(Query query, Filter filter, int n, Sort sort) throws IOException {
        return this.local.search(query, filter, n, sort);
    }

    public Document doc(int n) throws IOException {
        return this.local.doc(n);
    }

    public Query rewrite(Query query) throws IOException {
        return this.local.rewrite(query);
    }

    public Explanation explain(Query query, int n) throws IOException {
        return this.local.explain(query, n);
    }

    public static void main(String[] stringArray) throws Exception {
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
        }
        IndexSearcher indexSearcher = new IndexSearcher(stringArray[0]);
        RemoteSearchable remoteSearchable = new RemoteSearchable(indexSearcher);
        Naming.rebind("//localhost/Searchable", remoteSearchable);
    }
}

