/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.search;

import gate.creole.annic.apache.lucene.index.IndexReader;
import gate.creole.annic.apache.lucene.index.Term;
import gate.creole.annic.apache.lucene.index.TermEnum;
import gate.creole.annic.apache.lucene.search.BooleanQuery;
import gate.creole.annic.apache.lucene.search.Query;
import gate.creole.annic.apache.lucene.search.TermQuery;
import java.io.IOException;

public class RangeQuery
extends Query {
    private Term lowerTerm;
    private Term upperTerm;
    private boolean inclusive;

    public RangeQuery(Term term, Term term2, boolean bl) {
        if (term == null && term2 == null) {
            throw new IllegalArgumentException("At least one term must be non-null");
        }
        if (term != null && term2 != null && term.field() != term2.field()) {
            throw new IllegalArgumentException("Both terms must be for the same field");
        }
        this.lowerTerm = term != null ? term : new Term(term2.field(), "");
        this.upperTerm = term2;
        this.inclusive = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Query rewrite(IndexReader indexReader) throws IOException {
        BooleanQuery booleanQuery = new BooleanQuery();
        TermEnum termEnum = indexReader.terms(this.lowerTerm);
        try {
            boolean bl = false;
            if (!this.inclusive) {
                bl = true;
            }
            String string = this.getField();
            do {
                Term term;
                if ((term = termEnum.term()) == null) return booleanQuery;
                if (term.field() != string) return booleanQuery;
                if (bl && term.text().compareTo(this.lowerTerm.text()) <= 0) continue;
                bl = false;
                if (this.upperTerm != null) {
                    int n = this.upperTerm.text().compareTo(term.text());
                    if (n < 0) return booleanQuery;
                    if (!this.inclusive && n == 0) {
                        return booleanQuery;
                    }
                }
                TermQuery termQuery = new TermQuery(term);
                termQuery.setBoost(this.getBoost());
                booleanQuery.add(termQuery, false, false);
            } while (termEnum.next());
            return booleanQuery;
        }
        finally {
            termEnum.close();
        }
    }

    public Query combine(Query[] queryArray) {
        return Query.mergeBooleanQueries(queryArray);
    }

    public String getField() {
        return this.lowerTerm != null ? this.lowerTerm.field() : this.upperTerm.field();
    }

    public Term getLowerTerm() {
        return this.lowerTerm;
    }

    public Term getUpperTerm() {
        return this.upperTerm;
    }

    public boolean isInclusive() {
        return this.inclusive;
    }

    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.getField().equals(string)) {
            stringBuffer.append(this.getField());
            stringBuffer.append(":");
        }
        stringBuffer.append(this.inclusive ? "[" : "{");
        stringBuffer.append(this.lowerTerm != null ? this.lowerTerm.text() : "null");
        stringBuffer.append(" TO ");
        stringBuffer.append(this.upperTerm != null ? this.upperTerm.text() : "null");
        stringBuffer.append(this.inclusive ? "]" : "}");
        if (this.getBoost() != 1.0f) {
            stringBuffer.append("^");
            stringBuffer.append(Float.toString(this.getBoost()));
        }
        return stringBuffer.toString();
    }
}

