/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.search;

import gate.creole.annic.apache.lucene.analysis.Analyzer;
import gate.creole.annic.apache.lucene.analysis.Token;
import gate.creole.annic.apache.lucene.analysis.TokenStream;
import gate.creole.annic.apache.lucene.index.TermFreqVector;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class QueryTermVector
implements TermFreqVector {
    private String[] terms = new String[0];
    private int[] termFreqs = new int[0];

    public String getField() {
        return null;
    }

    public QueryTermVector(String[] stringArray) {
        this.processTerms(stringArray);
    }

    public QueryTermVector(String string, Analyzer analyzer) {
        TokenStream tokenStream;
        if (analyzer != null && (tokenStream = analyzer.tokenStream("", new StringReader(string))) != null) {
            Token token = null;
            ArrayList<String> arrayList = new ArrayList<String>();
            try {
                while ((token = tokenStream.next()) != null) {
                    arrayList.add(token.termText());
                }
                this.processTerms(arrayList.toArray(new String[arrayList.size()]));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void processTerms(String[] stringArray) {
        if (stringArray != null) {
            int n;
            Arrays.sort(stringArray);
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>(stringArray.length);
            ArrayList<Object> arrayList = new ArrayList<Object>(stringArray.length);
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>(stringArray.length);
            int n2 = 0;
            for (n = 0; n < stringArray.length; ++n) {
                String string = stringArray[n];
                Integer n3 = (Integer)hashMap.get(string);
                if (n3 == null) {
                    hashMap.put(string, new Integer(n2++));
                    arrayList.add(string);
                    arrayList2.add(new Integer(1));
                    continue;
                }
                Integer n4 = (Integer)arrayList2.get(n3);
                arrayList2.set(n3, new Integer(n4 + 1));
            }
            this.terms = arrayList.toArray(this.terms);
            this.termFreqs = new int[arrayList2.size()];
            n = 0;
            for (Integer n3 : arrayList2) {
                this.termFreqs[n++] = n3;
            }
        }
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('{');
        for (int i = 0; i < this.terms.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.terms[i]).append('/').append(this.termFreqs[i]);
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    public int size() {
        return this.terms.length;
    }

    public String[] getTerms() {
        return this.terms;
    }

    public int[] getTermFrequencies() {
        return this.termFreqs;
    }

    public int indexOf(String string) {
        int n = Arrays.binarySearch(this.terms, string);
        return n >= 0 ? n : -1;
    }

    public int[] indexesOf(String[] stringArray, int n, int n2) {
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = this.indexOf(stringArray[i]);
        }
        return nArray;
    }
}

