/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.search;

import gate.creole.annic.apache.lucene.index.IndexReader;
import gate.creole.annic.apache.lucene.index.Term;
import gate.creole.annic.apache.lucene.index.TermEnum;
import gate.creole.annic.apache.lucene.search.BooleanQuery;
import gate.creole.annic.apache.lucene.search.Query;
import gate.creole.annic.apache.lucene.search.TermQuery;
import java.io.IOException;

public class PrefixQuery
extends Query {
    private Term prefix;

    public PrefixQuery(Term term) {
        this.prefix = term;
    }

    public Term getPrefix() {
        return this.prefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query rewrite(IndexReader indexReader) throws IOException {
        BooleanQuery booleanQuery = new BooleanQuery();
        TermEnum termEnum = indexReader.terms(this.prefix);
        try {
            Term term;
            String string = this.prefix.text();
            String string2 = this.prefix.field();
            while ((term = termEnum.term()) != null && term.text().startsWith(string) && term.field() == string2) {
                TermQuery termQuery = new TermQuery(term);
                termQuery.setBoost(this.getBoost());
                booleanQuery.add(termQuery, false, false);
                if (termEnum.next()) continue;
                break;
            }
        }
        finally {
            termEnum.close();
        }
        return booleanQuery;
    }

    public Query combine(Query[] queryArray) {
        return Query.mergeBooleanQueries(queryArray);
    }

    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.prefix.field().equals(string)) {
            stringBuffer.append(this.prefix.field());
            stringBuffer.append(":");
        }
        stringBuffer.append(this.prefix.text());
        stringBuffer.append('*');
        if (this.getBoost() != 1.0f) {
            stringBuffer.append("^");
            stringBuffer.append(Float.toString(this.getBoost()));
        }
        return stringBuffer.toString();
    }
}

