/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.search;

import gate.creole.annic.apache.lucene.index.TermPositions;
import gate.creole.annic.apache.lucene.search.Explanation;
import gate.creole.annic.apache.lucene.search.IndexSearcher;
import gate.creole.annic.apache.lucene.search.PhrasePositions;
import gate.creole.annic.apache.lucene.search.PhraseQueue;
import gate.creole.annic.apache.lucene.search.Scorer;
import gate.creole.annic.apache.lucene.search.Similarity;
import gate.creole.annic.apache.lucene.search.Weight;
import java.io.IOException;
import java.util.Vector;

abstract class PhraseScorer
extends Scorer {
    private Weight weight;
    protected byte[] norms;
    protected float value;
    private boolean firstTime = true;
    private boolean more = true;
    protected PhraseQueue pq;
    protected PhrasePositions first;
    protected PhrasePositions last;
    private float freq;
    protected IndexSearcher searcher;

    PhraseScorer(Weight weight, TermPositions[] termPositionsArray, Vector vector, Similarity similarity, byte[] byArray, IndexSearcher indexSearcher) throws IOException {
        super(similarity);
        this.norms = byArray;
        this.weight = weight;
        this.value = weight.getValue();
        this.searcher = indexSearcher;
        for (int i = 0; i < termPositionsArray.length; ++i) {
            PhrasePositions phrasePositions = new PhrasePositions(termPositionsArray[i], (Integer)vector.get(i));
            if (this.last != null) {
                this.last.next = phrasePositions;
            } else {
                this.first = phrasePositions;
            }
            this.last = phrasePositions;
        }
        this.pq = new PhraseQueue(termPositionsArray.length);
    }

    PhraseScorer(Weight weight, TermPositions[] termPositionsArray, Vector vector, Similarity similarity, byte[] byArray) throws IOException {
        super(similarity);
        this.norms = byArray;
        this.weight = weight;
        this.value = weight.getValue();
        for (int i = 0; i < termPositionsArray.length; ++i) {
            PhrasePositions phrasePositions = new PhrasePositions(termPositionsArray[i], (Integer)vector.get(i));
            if (this.last != null) {
                this.last.next = phrasePositions;
            } else {
                this.first = phrasePositions;
            }
            this.last = phrasePositions;
        }
        this.pq = new PhraseQueue(termPositionsArray.length);
    }

    PhraseScorer(Weight weight, TermPositions[] termPositionsArray, Similarity similarity, byte[] byArray) throws IOException {
        super(similarity);
        this.norms = byArray;
        this.weight = weight;
        this.value = weight.getValue();
        for (int i = 0; i < termPositionsArray.length; ++i) {
            PhrasePositions phrasePositions = new PhrasePositions(termPositionsArray[i], i);
            if (this.last != null) {
                this.last.next = phrasePositions;
            } else {
                this.first = phrasePositions;
            }
            this.last = phrasePositions;
        }
        this.pq = new PhraseQueue(termPositionsArray.length);
    }

    public int doc() {
        return this.first.doc;
    }

    public boolean next() throws IOException {
        if (this.firstTime) {
            this.init();
            this.firstTime = false;
        } else if (this.more) {
            this.more = this.last.next();
        }
        return this.doNext();
    }

    private boolean doNext() throws IOException {
        while (this.more) {
            while (this.more && this.first.doc < this.last.doc) {
                this.more = this.first.skipTo(this.last.doc);
                this.firstToLast();
            }
            if (!this.more) continue;
            this.freq = this.phraseFreq();
            if (this.freq == 0.0f) {
                this.more = this.last.next();
                continue;
            }
            return true;
        }
        return false;
    }

    public float score(IndexSearcher indexSearcher) throws IOException {
        return this.score();
    }

    public float score() throws IOException {
        float f = this.getSimilarity().tf(this.freq) * this.value;
        return f * Similarity.decodeNorm(this.norms[this.first.doc]);
    }

    public boolean skipTo(int n) throws IOException {
        PhrasePositions phrasePositions = this.first;
        while (this.more && phrasePositions != null) {
            this.more = phrasePositions.skipTo(n);
            phrasePositions = phrasePositions.next;
        }
        if (this.more) {
            this.sort();
        }
        return this.doNext();
    }

    protected abstract float phraseFreq() throws IOException;

    private void init() throws IOException {
        PhrasePositions phrasePositions = this.first;
        while (this.more && phrasePositions != null) {
            this.more = phrasePositions.next();
            phrasePositions = phrasePositions.next;
        }
        if (this.more) {
            this.sort();
        }
    }

    private void sort() {
        this.pq.clear();
        PhrasePositions phrasePositions = this.first;
        while (phrasePositions != null) {
            this.pq.put(phrasePositions);
            phrasePositions = phrasePositions.next;
        }
        this.pqToList();
    }

    protected final void pqToList() {
        this.first = null;
        this.last = null;
        while (this.pq.top() != null) {
            PhrasePositions phrasePositions = (PhrasePositions)this.pq.pop();
            if (this.last != null) {
                this.last.next = phrasePositions;
            } else {
                this.first = phrasePositions;
            }
            this.last = phrasePositions;
            phrasePositions.next = null;
        }
    }

    protected final void firstToLast() {
        this.last.next = this.first;
        this.last = this.first;
        this.first = this.first.next;
        this.last.next = null;
    }

    public Explanation explain(int n) throws IOException {
        Explanation explanation = new Explanation();
        while (this.next() && this.doc() < n) {
        }
        float f = this.doc() == n ? this.freq : 0.0f;
        explanation.setValue(this.getSimilarity().tf(f));
        explanation.setDescription("tf(phraseFreq=" + f + ")");
        return explanation;
    }

    public String toString() {
        return "scorer(" + this.weight + ")";
    }
}

