/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.search;

import gate.creole.annic.apache.lucene.index.IndexReader;
import gate.creole.annic.apache.lucene.index.MultipleTermPositions;
import gate.creole.annic.apache.lucene.index.Term;
import gate.creole.annic.apache.lucene.index.TermPositions;
import gate.creole.annic.apache.lucene.search.BooleanQuery;
import gate.creole.annic.apache.lucene.search.ExactPhraseScorer;
import gate.creole.annic.apache.lucene.search.Explanation;
import gate.creole.annic.apache.lucene.search.IndexSearcher;
import gate.creole.annic.apache.lucene.search.Query;
import gate.creole.annic.apache.lucene.search.Scorer;
import gate.creole.annic.apache.lucene.search.Searcher;
import gate.creole.annic.apache.lucene.search.Similarity;
import gate.creole.annic.apache.lucene.search.SloppyPhraseScorer;
import gate.creole.annic.apache.lucene.search.TermQuery;
import gate.creole.annic.apache.lucene.search.Weight;
import java.io.IOException;
import java.util.ArrayList;

public class PhrasePrefixQuery
extends Query {
    private String field;
    private ArrayList termArrays = new ArrayList();
    private int slop = 0;

    public void setSlop(int n) {
        this.slop = n;
    }

    public int getSlop() {
        return this.slop;
    }

    public void add(Term term) {
        this.add(new Term[]{term});
    }

    public void add(Term[] termArray) {
        if (this.termArrays.size() == 0) {
            this.field = termArray[0].field();
        }
        for (int i = 0; i < termArray.length; ++i) {
            if (termArray[i].field() == this.field) continue;
            throw new IllegalArgumentException("All phrase terms must be in the same field (" + this.field + "): " + termArray[i]);
        }
        this.termArrays.add(termArray);
    }

    protected Weight createWeight(Searcher searcher) {
        if (this.termArrays.size() == 1) {
            Term[] termArray = (Term[])this.termArrays.get(0);
            BooleanQuery booleanQuery = new BooleanQuery();
            for (int i = 0; i < termArray.length; ++i) {
                booleanQuery.add(new TermQuery(termArray[i]), false, false);
            }
            booleanQuery.setBoost(this.getBoost());
            return booleanQuery.createWeight(searcher);
        }
        return new PhrasePrefixWeight(searcher);
    }

    public final String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.field.equals(string)) {
            stringBuffer.append(this.field);
            stringBuffer.append(":");
        }
        stringBuffer.append("\"");
        for (Term[] termArray : this.termArrays) {
            stringBuffer.append(termArray[0].text() + (termArray.length > 0 ? "*" : ""));
        }
        stringBuffer.append("\"");
        if (this.slop != 0) {
            stringBuffer.append("~");
            stringBuffer.append(this.slop);
        }
        if (this.getBoost() != 1.0f) {
            stringBuffer.append("^");
            stringBuffer.append(Float.toString(this.getBoost()));
        }
        return stringBuffer.toString();
    }

    private class PhrasePrefixWeight
    implements Weight {
        private Searcher searcher;
        private float value;
        private float idf;
        private float queryNorm;
        private float queryWeight;

        public PhrasePrefixWeight(Searcher searcher) {
            this.searcher = searcher;
        }

        public Query getQuery() {
            return PhrasePrefixQuery.this;
        }

        public float getValue() {
            return this.value;
        }

        public float sumOfSquaredWeights() throws IOException {
            for (Term[] termArray : PhrasePrefixQuery.this.termArrays) {
                for (int i = 0; i < termArray.length; ++i) {
                    this.idf += PhrasePrefixQuery.this.getSimilarity(this.searcher).idf(termArray[i], this.searcher);
                }
            }
            this.queryWeight = this.idf * PhrasePrefixQuery.this.getBoost();
            return this.queryWeight * this.queryWeight;
        }

        public void normalize(float f) {
            this.queryNorm = f;
            this.queryWeight *= f;
            this.value = this.queryWeight * this.idf;
        }

        public Scorer scorer(IndexReader indexReader, IndexSearcher indexSearcher) throws IOException {
            return this.scorer(indexReader);
        }

        public Scorer scorer(IndexReader indexReader) throws IOException {
            if (PhrasePrefixQuery.this.termArrays.size() == 0) {
                return null;
            }
            TermPositions[] termPositionsArray = new TermPositions[PhrasePrefixQuery.this.termArrays.size()];
            for (int i = 0; i < termPositionsArray.length; ++i) {
                Term[] termArray = (Term[])PhrasePrefixQuery.this.termArrays.get(i);
                TermPositions termPositions = termArray.length > 1 ? new MultipleTermPositions(indexReader, termArray) : indexReader.termPositions(termArray[0]);
                if (termPositions == null) {
                    return null;
                }
                termPositionsArray[i] = termPositions;
            }
            if (PhrasePrefixQuery.this.slop == 0) {
                return new ExactPhraseScorer(this, termPositionsArray, PhrasePrefixQuery.this.getSimilarity(this.searcher), indexReader.norms(PhrasePrefixQuery.this.field));
            }
            return new SloppyPhraseScorer((Weight)this, termPositionsArray, PhrasePrefixQuery.this.getSimilarity(this.searcher), PhrasePrefixQuery.this.slop, indexReader.norms(PhrasePrefixQuery.this.field));
        }

        public Explanation explain(IndexReader indexReader, int n) throws IOException {
            Explanation explanation = new Explanation();
            explanation.setDescription("weight(" + this.getQuery() + " in " + n + "), product of:");
            Explanation explanation2 = new Explanation(this.idf, "idf(" + this.getQuery() + ")");
            Explanation explanation3 = new Explanation();
            explanation3.setDescription("queryWeight(" + this.getQuery() + "), product of:");
            Explanation explanation4 = new Explanation(PhrasePrefixQuery.this.getBoost(), "boost");
            if (PhrasePrefixQuery.this.getBoost() != 1.0f) {
                explanation3.addDetail(explanation4);
            }
            explanation3.addDetail(explanation2);
            Explanation explanation5 = new Explanation(this.queryNorm, "queryNorm");
            explanation3.addDetail(explanation5);
            explanation3.setValue(explanation4.getValue() * explanation2.getValue() * explanation5.getValue());
            explanation.addDetail(explanation3);
            Explanation explanation6 = new Explanation();
            explanation6.setDescription("fieldWeight(" + this.getQuery() + " in " + n + "), product of:");
            Explanation explanation7 = this.scorer(indexReader).explain(n);
            explanation6.addDetail(explanation7);
            explanation6.addDetail(explanation2);
            Explanation explanation8 = new Explanation();
            byte[] byArray = indexReader.norms(PhrasePrefixQuery.this.field);
            float f = byArray != null ? Similarity.decodeNorm(byArray[n]) : 0.0f;
            explanation8.setValue(f);
            explanation8.setDescription("fieldNorm(field=" + PhrasePrefixQuery.this.field + ", doc=" + n + ")");
            explanation6.addDetail(explanation8);
            explanation6.setValue(explanation7.getValue() * explanation2.getValue() * explanation8.getValue());
            explanation.addDetail(explanation6);
            explanation.setValue(explanation3.getValue() * explanation6.getValue());
            if (explanation3.getValue() == 1.0f) {
                return explanation6;
            }
            return explanation;
        }
    }
}

