/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.search;

import gate.creole.annic.apache.lucene.index.Term;
import gate.creole.annic.apache.lucene.search.FieldDocSortedHitQueue;
import gate.creole.annic.apache.lucene.search.Filter;
import gate.creole.annic.apache.lucene.search.HitCollector;
import gate.creole.annic.apache.lucene.search.HitQueue;
import gate.creole.annic.apache.lucene.search.MultiSearcher;
import gate.creole.annic.apache.lucene.search.MultiSearcherThread;
import gate.creole.annic.apache.lucene.search.Query;
import gate.creole.annic.apache.lucene.search.ScoreDoc;
import gate.creole.annic.apache.lucene.search.Searchable;
import gate.creole.annic.apache.lucene.search.Sort;
import gate.creole.annic.apache.lucene.search.TopDocs;
import gate.creole.annic.apache.lucene.search.TopFieldDocs;
import java.io.IOException;

public class ParallelMultiSearcher
extends MultiSearcher {
    private Searchable[] searchables;
    private int[] starts;

    public ParallelMultiSearcher(Searchable[] searchableArray) throws IOException {
        super(searchableArray);
        this.searchables = searchableArray;
        this.starts = this.getStarts();
    }

    public int docFreq(Term term) throws IOException {
        int n = 0;
        for (int i = 0; i < this.searchables.length; ++i) {
            n += this.searchables[i].docFreq(term);
        }
        return n;
    }

    public TopDocs search(Query query, Filter filter, int n) throws IOException {
        int n2;
        HitQueue hitQueue = new HitQueue(n);
        int n3 = 0;
        MultiSearcherThread[] multiSearcherThreadArray = new MultiSearcherThread[this.searchables.length];
        for (n2 = 0; n2 < this.searchables.length; ++n2) {
            multiSearcherThreadArray[n2] = new MultiSearcherThread(this.searchables[n2], query, filter, n, hitQueue, n2, this.starts, "MultiSearcher thread #" + (n2 + 1));
            multiSearcherThreadArray[n2].start();
        }
        for (n2 = 0; n2 < this.searchables.length; ++n2) {
            try {
                multiSearcherThreadArray[n2].join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            IOException iOException = multiSearcherThreadArray[n2].getIOException();
            if (iOException == null) {
                n3 += multiSearcherThreadArray[n2].hits();
                continue;
            }
            throw iOException;
        }
        ScoreDoc[] scoreDocArray = new ScoreDoc[hitQueue.size()];
        for (int i = hitQueue.size() - 1; i >= 0; --i) {
            scoreDocArray[i] = (ScoreDoc)hitQueue.pop();
        }
        return new TopDocs(n3, scoreDocArray);
    }

    public TopFieldDocs search(Query query, Filter filter, int n, Sort sort) throws IOException {
        int n2;
        FieldDocSortedHitQueue fieldDocSortedHitQueue = new FieldDocSortedHitQueue(null, n);
        int n3 = 0;
        MultiSearcherThread[] multiSearcherThreadArray = new MultiSearcherThread[this.searchables.length];
        for (n2 = 0; n2 < this.searchables.length; ++n2) {
            multiSearcherThreadArray[n2] = new MultiSearcherThread(this.searchables[n2], query, filter, n, fieldDocSortedHitQueue, sort, n2, this.starts, "MultiSearcher thread #" + (n2 + 1));
            multiSearcherThreadArray[n2].start();
        }
        for (n2 = 0; n2 < this.searchables.length; ++n2) {
            try {
                multiSearcherThreadArray[n2].join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            IOException iOException = multiSearcherThreadArray[n2].getIOException();
            if (iOException == null) {
                n3 += multiSearcherThreadArray[n2].hits();
                continue;
            }
            throw iOException;
        }
        ScoreDoc[] scoreDocArray = new ScoreDoc[fieldDocSortedHitQueue.size()];
        for (int i = fieldDocSortedHitQueue.size() - 1; i >= 0; --i) {
            scoreDocArray[i] = (ScoreDoc)fieldDocSortedHitQueue.pop();
        }
        return new TopFieldDocs(n3, scoreDocArray, fieldDocSortedHitQueue.getFields());
    }

    public void search(Query query, Filter filter, final HitCollector hitCollector) throws IOException {
        for (int i = 0; i < this.searchables.length; ++i) {
            final int n = this.starts[i];
            this.searchables[i].search(query, filter, new HitCollector(){

                public void collect(int n2, float f) {
                    hitCollector.collect(n2 + n, f);
                }
            });
        }
    }

    public Query rewrite(Query query) throws IOException {
        Query[] queryArray = new Query[this.searchables.length];
        for (int i = 0; i < this.searchables.length; ++i) {
            queryArray[i] = this.searchables[i].rewrite(query);
        }
        return query.combine(queryArray);
    }
}

