/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.search;

import gate.creole.annic.apache.lucene.index.IndexReader;
import gate.creole.annic.apache.lucene.index.Term;
import gate.creole.annic.apache.lucene.search.BooleanQuery;
import gate.creole.annic.apache.lucene.search.FilteredTermEnum;
import gate.creole.annic.apache.lucene.search.Query;
import gate.creole.annic.apache.lucene.search.TermQuery;
import java.io.IOException;

public abstract class MultiTermQuery
extends Query {
    private Term term;

    public MultiTermQuery(Term term) {
        this.term = term;
    }

    public Term getTerm() {
        return this.term;
    }

    protected abstract FilteredTermEnum getEnum(IndexReader var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query rewrite(IndexReader indexReader) throws IOException {
        FilteredTermEnum filteredTermEnum = this.getEnum(indexReader);
        BooleanQuery booleanQuery = new BooleanQuery();
        try {
            do {
                Term term;
                if ((term = filteredTermEnum.term()) == null) continue;
                TermQuery termQuery = new TermQuery(term);
                termQuery.setBoost(this.getBoost() * filteredTermEnum.difference());
                booleanQuery.add(termQuery, false, false);
            } while (filteredTermEnum.next());
        }
        finally {
            filteredTermEnum.close();
        }
        return booleanQuery;
    }

    public Query combine(Query[] queryArray) {
        return Query.mergeBooleanQueries(queryArray);
    }

    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.term.field().equals(string)) {
            stringBuffer.append(this.term.field());
            stringBuffer.append(":");
        }
        stringBuffer.append(this.term.text());
        if (this.getBoost() != 1.0f) {
            stringBuffer.append("^");
            stringBuffer.append(Float.toString(this.getBoost()));
        }
        return stringBuffer.toString();
    }
}

