/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.search;

import gate.creole.annic.apache.lucene.search.FieldDocSortedHitQueue;
import gate.creole.annic.apache.lucene.search.Filter;
import gate.creole.annic.apache.lucene.search.HitQueue;
import gate.creole.annic.apache.lucene.search.Query;
import gate.creole.annic.apache.lucene.search.ScoreDoc;
import gate.creole.annic.apache.lucene.search.Searchable;
import gate.creole.annic.apache.lucene.search.Sort;
import gate.creole.annic.apache.lucene.search.TopDocs;
import gate.creole.annic.apache.lucene.search.TopFieldDocs;
import gate.creole.annic.apache.lucene.util.PriorityQueue;
import java.io.IOException;

class MultiSearcherThread
extends Thread {
    private Searchable searchable;
    private Query query;
    private Filter filter;
    private int nDocs;
    private TopDocs docs;
    private int i;
    private PriorityQueue hq;
    private int[] starts;
    private IOException ioe;
    private Sort sort;

    public MultiSearcherThread(Searchable searchable, Query query, Filter filter, int n, HitQueue hitQueue, int n2, int[] nArray, String string) {
        super(string);
        this.searchable = searchable;
        this.query = query;
        this.filter = filter;
        this.nDocs = n;
        this.hq = hitQueue;
        this.i = n2;
        this.starts = nArray;
    }

    public MultiSearcherThread(Searchable searchable, Query query, Filter filter, int n, FieldDocSortedHitQueue fieldDocSortedHitQueue, Sort sort, int n2, int[] nArray, String string) {
        super(string);
        this.searchable = searchable;
        this.query = query;
        this.filter = filter;
        this.nDocs = n;
        this.hq = fieldDocSortedHitQueue;
        this.i = n2;
        this.starts = nArray;
        this.sort = sort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.docs = this.sort == null ? this.searchable.search(this.query, this.filter, this.nDocs) : this.searchable.search(this.query, this.filter, this.nDocs, this.sort);
        }
        catch (IOException iOException) {
            this.ioe = iOException;
        }
        if (this.ioe == null) {
            if (this.sort != null) {
                ((FieldDocSortedHitQueue)this.hq).setFields(((TopFieldDocs)this.docs).fields);
            }
            ScoreDoc[] scoreDocArray = this.docs.scoreDocs;
            for (int i = 0; i < scoreDocArray.length; ++i) {
                ScoreDoc scoreDoc = scoreDocArray[i];
                scoreDoc.doc += this.starts[this.i];
                PriorityQueue priorityQueue = this.hq;
                synchronized (priorityQueue) {
                    if (!this.hq.insert(scoreDoc)) {
                        break;
                    }
                    continue;
                }
            }
        }
    }

    public int hits() {
        return this.docs.totalHits;
    }

    public IOException getIOException() {
        return this.ioe;
    }
}

