/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.search;

import gate.creole.annic.apache.lucene.document.Document;
import gate.creole.annic.apache.lucene.index.Term;
import gate.creole.annic.apache.lucene.search.Explanation;
import gate.creole.annic.apache.lucene.search.FieldDocSortedHitQueue;
import gate.creole.annic.apache.lucene.search.Filter;
import gate.creole.annic.apache.lucene.search.HitCollector;
import gate.creole.annic.apache.lucene.search.HitQueue;
import gate.creole.annic.apache.lucene.search.Query;
import gate.creole.annic.apache.lucene.search.ScoreDoc;
import gate.creole.annic.apache.lucene.search.Searchable;
import gate.creole.annic.apache.lucene.search.Searcher;
import gate.creole.annic.apache.lucene.search.Sort;
import gate.creole.annic.apache.lucene.search.TopDocs;
import gate.creole.annic.apache.lucene.search.TopFieldDocs;
import gate.creole.annic.apache.lucene.util.PriorityQueue;
import java.io.IOException;

public class MultiSearcher
extends Searcher {
    private Searchable[] searchables;
    private int[] starts;
    private int maxDoc = 0;

    public MultiSearcher(Searchable[] searchableArray) throws IOException {
        this.searchables = searchableArray;
        this.starts = new int[searchableArray.length + 1];
        for (int i = 0; i < searchableArray.length; ++i) {
            this.starts[i] = this.maxDoc;
            this.maxDoc += searchableArray[i].maxDoc();
        }
        this.starts[searchableArray.length] = this.maxDoc;
    }

    protected int[] getStarts() {
        return this.starts;
    }

    public void close() throws IOException {
        for (int i = 0; i < this.searchables.length; ++i) {
            this.searchables[i].close();
        }
    }

    public int docFreq(Term term) throws IOException {
        int n = 0;
        for (int i = 0; i < this.searchables.length; ++i) {
            n += this.searchables[i].docFreq(term);
        }
        return n;
    }

    public Document doc(int n) throws IOException {
        int n2 = this.subSearcher(n);
        return this.searchables[n2].doc(n - this.starts[n2]);
    }

    public int searcherIndex(int n) {
        return this.subSearcher(n);
    }

    public int subSearcher(int n) {
        int n2 = 0;
        int n3 = this.searchables.length - 1;
        while (n3 >= n2) {
            int n4 = n2 + n3 >> 1;
            int n5 = this.starts[n4];
            if (n < n5) {
                n3 = n4 - 1;
                continue;
            }
            if (n > n5) {
                n2 = n4 + 1;
                continue;
            }
            while (n4 + 1 < this.searchables.length && this.starts[n4 + 1] == n5) {
                ++n4;
            }
            return n4;
        }
        return n3;
    }

    public int subDoc(int n) {
        return n - this.starts[this.subSearcher(n)];
    }

    public int maxDoc() throws IOException {
        return this.maxDoc;
    }

    public TopDocs search(Query query, Filter filter, int n) throws IOException {
        HitQueue hitQueue = new HitQueue(n);
        int n2 = 0;
        block0: for (int i = 0; i < this.searchables.length; ++i) {
            TopDocs topDocs = this.searchables[i].search(query, filter, n);
            n2 += topDocs.totalHits;
            ScoreDoc[] scoreDocArray = topDocs.scoreDocs;
            for (int j = 0; j < scoreDocArray.length; ++j) {
                ScoreDoc scoreDoc = scoreDocArray[j];
                scoreDoc.doc += this.starts[i];
                if (!hitQueue.insert(scoreDoc)) continue block0;
            }
        }
        ScoreDoc[] scoreDocArray = new ScoreDoc[hitQueue.size()];
        for (int i = hitQueue.size() - 1; i >= 0; --i) {
            scoreDocArray[i] = (ScoreDoc)hitQueue.pop();
        }
        return new TopDocs(n2, scoreDocArray);
    }

    public TopFieldDocs search(Query query, Filter filter, int n, Sort sort) throws IOException {
        PriorityQueue priorityQueue = null;
        int n2 = 0;
        block0: for (int i = 0; i < this.searchables.length; ++i) {
            TopFieldDocs topFieldDocs = this.searchables[i].search(query, filter, n, sort);
            if (priorityQueue == null) {
                priorityQueue = new FieldDocSortedHitQueue(topFieldDocs.fields, n);
            }
            n2 += topFieldDocs.totalHits;
            ScoreDoc[] scoreDocArray = topFieldDocs.scoreDocs;
            for (int j = 0; j < scoreDocArray.length; ++j) {
                ScoreDoc scoreDoc = scoreDocArray[j];
                scoreDoc.doc += this.starts[i];
                if (!priorityQueue.insert(scoreDoc)) continue block0;
            }
        }
        ScoreDoc[] scoreDocArray = new ScoreDoc[priorityQueue.size()];
        for (int i = priorityQueue.size() - 1; i >= 0; --i) {
            scoreDocArray[i] = (ScoreDoc)priorityQueue.pop();
        }
        return new TopFieldDocs(n2, scoreDocArray, ((FieldDocSortedHitQueue)priorityQueue).getFields());
    }

    public void search(Query query, Filter filter, final HitCollector hitCollector) throws IOException {
        for (int i = 0; i < this.searchables.length; ++i) {
            final int n = this.starts[i];
            this.searchables[i].search(query, filter, new HitCollector(){

                public void collect(int n2, float f) {
                    hitCollector.collect(n2 + n, f);
                }
            });
        }
    }

    public Query rewrite(Query query) throws IOException {
        Query[] queryArray = new Query[this.searchables.length];
        for (int i = 0; i < this.searchables.length; ++i) {
            queryArray[i] = this.searchables[i].rewrite(query);
        }
        return query.combine(queryArray);
    }

    public Explanation explain(Query query, int n) throws IOException {
        int n2 = this.subSearcher(n);
        return this.searchables[n2].explain(query, n - this.starts[n2]);
    }
}

