/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.search;

import gate.creole.annic.apache.lucene.document.Document;
import gate.creole.annic.apache.lucene.index.IndexReader;
import gate.creole.annic.apache.lucene.index.Term;
import gate.creole.annic.apache.lucene.search.Explanation;
import gate.creole.annic.apache.lucene.search.FieldDoc;
import gate.creole.annic.apache.lucene.search.FieldSortedHitQueue;
import gate.creole.annic.apache.lucene.search.Filter;
import gate.creole.annic.apache.lucene.search.HitCollector;
import gate.creole.annic.apache.lucene.search.HitQueue;
import gate.creole.annic.apache.lucene.search.Query;
import gate.creole.annic.apache.lucene.search.ScoreDoc;
import gate.creole.annic.apache.lucene.search.Scorer;
import gate.creole.annic.apache.lucene.search.Searcher;
import gate.creole.annic.apache.lucene.search.Sort;
import gate.creole.annic.apache.lucene.search.TopDocs;
import gate.creole.annic.apache.lucene.search.TopFieldDocs;
import gate.creole.annic.apache.lucene.store.Directory;
import java.io.IOException;
import java.util.BitSet;

public class IndexSearcher
extends Searcher {
    IndexReader reader;
    private boolean closeReader;

    public IndexSearcher(String string) throws IOException {
        this(IndexReader.open(string), true);
    }

    public IndexSearcher(Directory directory) throws IOException {
        this(IndexReader.open(directory), true);
    }

    public IndexSearcher(IndexReader indexReader) {
        this(indexReader, false);
    }

    private IndexSearcher(IndexReader indexReader, boolean bl) {
        this.reader = indexReader;
        this.closeReader = bl;
    }

    public void close() throws IOException {
        if (this.closeReader) {
            this.reader.close();
        }
    }

    public int docFreq(Term term) throws IOException {
        return this.reader.docFreq(term);
    }

    public Document doc(int n) throws IOException {
        return this.reader.document(n);
    }

    public int maxDoc() throws IOException {
        return this.reader.maxDoc();
    }

    public TopDocs search(Query query, Filter filter, int n) throws IOException {
        Scorer scorer = query.weight(this).scorer(this.reader, this);
        if (scorer == null) {
            return new TopDocs(0, new ScoreDoc[0]);
        }
        final BitSet bitSet = filter != null ? filter.bits(this.reader) : null;
        final HitQueue hitQueue = new HitQueue(n);
        final int[] nArray = new int[1];
        scorer.score(new HitCollector(){

            public final void collect(int n, float f) {
                if (f > 0.0f && (bitSet == null || bitSet.get(n))) {
                    nArray[0] = nArray[0] + 1;
                    hitQueue.insert(new ScoreDoc(n, f));
                }
            }
        }, this);
        ScoreDoc[] scoreDocArray = new ScoreDoc[hitQueue.size()];
        for (int i = hitQueue.size() - 1; i >= 0; --i) {
            scoreDocArray[i] = (ScoreDoc)hitQueue.pop();
        }
        return new TopDocs(nArray[0], scoreDocArray);
    }

    public TopFieldDocs search(Query query, Filter filter, int n, Sort sort) throws IOException {
        Scorer scorer = query.weight(this).scorer(this.reader);
        if (scorer == null) {
            return new TopFieldDocs(0, new ScoreDoc[0], sort.fields);
        }
        final BitSet bitSet = filter != null ? filter.bits(this.reader) : null;
        final FieldSortedHitQueue fieldSortedHitQueue = new FieldSortedHitQueue(this.reader, sort.fields, n);
        final int[] nArray = new int[1];
        scorer.score(new HitCollector(){

            public final void collect(int n, float f) {
                if (f > 0.0f && (bitSet == null || bitSet.get(n))) {
                    nArray[0] = nArray[0] + 1;
                    fieldSortedHitQueue.insert(new FieldDoc(n, f));
                }
            }
        });
        ScoreDoc[] scoreDocArray = new ScoreDoc[fieldSortedHitQueue.size()];
        for (int i = fieldSortedHitQueue.size() - 1; i >= 0; --i) {
            scoreDocArray[i] = fieldSortedHitQueue.fillFields((FieldDoc)fieldSortedHitQueue.pop());
        }
        return new TopFieldDocs(nArray[0], scoreDocArray, fieldSortedHitQueue.getFields());
    }

    public void search(Query query, Filter filter, HitCollector hitCollector) throws IOException {
        Object object;
        HitCollector hitCollector2 = hitCollector;
        if (filter != null) {
            object = filter.bits(this.reader);
            hitCollector2 = new HitCollector((BitSet)object, hitCollector){
                final /* synthetic */ BitSet val$bits;
                final /* synthetic */ HitCollector val$results;
                {
                    this.val$bits = bitSet;
                    this.val$results = hitCollector;
                }

                public final void collect(int n, float f) {
                    if (this.val$bits.get(n)) {
                        this.val$results.collect(n, f);
                    }
                }
            };
        }
        if ((object = query.weight(this).scorer(this.reader)) == null) {
            return;
        }
        ((Scorer)object).score(hitCollector2);
    }

    public Query rewrite(Query query) throws IOException {
        Query query2 = query;
        Query query3 = query2.rewrite(this.reader);
        while (query3 != query2) {
            query2 = query3;
            query3 = query2.rewrite(this.reader);
        }
        return query2;
    }

    public Explanation explain(Query query, int n) throws IOException {
        return query.weight(this).explain(this.reader, n);
    }
}

