/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.search;

import gate.creole.annic.apache.lucene.index.Term;
import gate.creole.annic.apache.lucene.index.TermEnum;
import java.io.IOException;

public abstract class FilteredTermEnum
extends TermEnum {
    private Term currentTerm = null;
    private TermEnum actualEnum = null;

    protected abstract boolean termCompare(Term var1);

    protected abstract float difference();

    protected abstract boolean endEnum();

    protected void setEnum(TermEnum termEnum) throws IOException {
        this.actualEnum = termEnum;
        Term term = termEnum.term();
        if (term != null && this.termCompare(term)) {
            this.currentTerm = term;
        } else {
            this.next();
        }
    }

    public int docFreq() {
        if (this.actualEnum == null) {
            return -1;
        }
        return this.actualEnum.docFreq();
    }

    public boolean next() throws IOException {
        if (this.actualEnum == null) {
            return false;
        }
        this.currentTerm = null;
        while (this.currentTerm == null) {
            if (this.endEnum()) {
                return false;
            }
            if (this.actualEnum.next()) {
                Term term = this.actualEnum.term();
                if (!this.termCompare(term)) continue;
                this.currentTerm = term;
                return true;
            }
            return false;
        }
        this.currentTerm = null;
        return false;
    }

    public Term term() {
        return this.currentTerm;
    }

    public void close() throws IOException {
        this.actualEnum.close();
        this.currentTerm = null;
        this.actualEnum = null;
    }
}

