/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.search;

import gate.creole.annic.apache.lucene.index.IndexReader;
import gate.creole.annic.apache.lucene.search.Explanation;
import gate.creole.annic.apache.lucene.search.Filter;
import gate.creole.annic.apache.lucene.search.IndexSearcher;
import gate.creole.annic.apache.lucene.search.Query;
import gate.creole.annic.apache.lucene.search.Scorer;
import gate.creole.annic.apache.lucene.search.Searcher;
import gate.creole.annic.apache.lucene.search.Weight;
import java.io.IOException;
import java.util.BitSet;

public class FilteredQuery
extends Query {
    Query query;
    Filter filter;

    public FilteredQuery(Query query, Filter filter) {
        this.query = query;
        this.filter = filter;
    }

    protected Weight createWeight(final Searcher searcher) {
        final Weight weight = this.query.createWeight(searcher);
        return new Weight(){

            public float getValue() {
                return weight.getValue();
            }

            public float sumOfSquaredWeights() throws IOException {
                return weight.sumOfSquaredWeights();
            }

            public void normalize(float f) {
                weight.normalize(f);
            }

            public Explanation explain(IndexReader indexReader, int n) throws IOException {
                return weight.explain(indexReader, n);
            }

            public Query getQuery() {
                return FilteredQuery.this;
            }

            public Scorer scorer(IndexReader indexReader, IndexSearcher indexSearcher) throws IOException {
                return this.scorer(indexReader);
            }

            public Scorer scorer(IndexReader indexReader) throws IOException {
                final Scorer scorer = weight.scorer(indexReader);
                final BitSet bitSet = FilteredQuery.this.filter.bits(indexReader);
                return new Scorer(FilteredQuery.this.query.getSimilarity(searcher)){

                    public boolean next() throws IOException {
                        return scorer.next();
                    }

                    public int doc() {
                        return scorer.doc();
                    }

                    public boolean skipTo(int n) throws IOException {
                        return scorer.skipTo(n);
                    }

                    public float score(IndexSearcher indexSearcher) throws IOException {
                        return this.score();
                    }

                    public float score() throws IOException {
                        return bitSet.get(scorer.doc()) ? scorer.score() : 0.0f;
                    }

                    public Explanation explain(int n) throws IOException {
                        Explanation explanation = scorer.explain(n);
                        if (bitSet.get(n)) {
                            explanation.setDescription("allowed by filter: " + explanation.getDescription());
                        } else {
                            explanation.setDescription("removed by filter: " + explanation.getDescription());
                        }
                        return explanation;
                    }
                };
            }
        };
    }

    public Query rewrite(IndexReader indexReader) throws IOException {
        Query query = this.query.rewrite(indexReader);
        if (query != this.query) {
            FilteredQuery filteredQuery = (FilteredQuery)this.clone();
            filteredQuery.query = query;
            return filteredQuery;
        }
        return this;
    }

    public Query getQuery() {
        return this.query;
    }

    public String toString(String string) {
        return "filtered(" + this.query.toString(string) + ")->" + this.filter;
    }

    public boolean equals(Object object) {
        if (object instanceof FilteredQuery) {
            FilteredQuery filteredQuery = (FilteredQuery)object;
            return this.query.equals(filteredQuery.query) && this.filter.equals(filteredQuery.filter);
        }
        return false;
    }

    public int hashCode() {
        return this.query.hashCode() ^ this.filter.hashCode();
    }
}

