/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.search;

import gate.creole.annic.apache.lucene.search.FieldDoc;
import gate.creole.annic.apache.lucene.search.SortField;
import gate.creole.annic.apache.lucene.util.PriorityQueue;
import java.io.IOException;
import java.text.Collator;
import java.util.Locale;

class FieldDocSortedHitQueue
extends PriorityQueue {
    volatile SortField[] fields;
    volatile Collator[] collators;

    FieldDocSortedHitQueue(SortField[] sortFieldArray, int n) throws IOException {
        this.fields = sortFieldArray;
        this.collators = this.hasCollators(sortFieldArray);
        this.initialize(n);
    }

    synchronized void setFields(SortField[] sortFieldArray) {
        if (this.fields == null) {
            this.fields = sortFieldArray;
            this.collators = this.hasCollators(sortFieldArray);
        }
    }

    SortField[] getFields() {
        return this.fields;
    }

    private Collator[] hasCollators(SortField[] sortFieldArray) {
        if (sortFieldArray == null) {
            return null;
        }
        Collator[] collatorArray = new Collator[sortFieldArray.length];
        for (int i = 0; i < sortFieldArray.length; ++i) {
            Locale locale = sortFieldArray[i].getLocale();
            if (locale == null) continue;
            collatorArray[i] = Collator.getInstance(locale);
        }
        return collatorArray;
    }

    protected final boolean lessThan(Object object, Object object2) {
        FieldDoc fieldDoc = (FieldDoc)object;
        FieldDoc fieldDoc2 = (FieldDoc)object2;
        int n = this.fields.length;
        int n2 = 0;
        block16: for (int i = 0; i < n && n2 == 0; ++i) {
            float f;
            float f2;
            String string;
            String string2;
            int n3;
            int n4;
            float f3;
            float f4;
            int n5 = this.fields[i].getType();
            if (this.fields[i].getReverse()) {
                switch (n5) {
                    case 0: {
                        f4 = ((Float)fieldDoc.fields[i]).floatValue();
                        f3 = ((Float)fieldDoc2.fields[i]).floatValue();
                        if (f4 < f3) {
                            n2 = -1;
                        }
                        if (!(f4 > f3)) continue block16;
                        n2 = 1;
                        break;
                    }
                    case 1: 
                    case 4: {
                        n4 = (Integer)fieldDoc.fields[i];
                        n3 = (Integer)fieldDoc2.fields[i];
                        if (n4 > n3) {
                            n2 = -1;
                        }
                        if (n4 >= n3) continue block16;
                        n2 = 1;
                        break;
                    }
                    case 3: {
                        string2 = (String)((Object)fieldDoc.fields[i]);
                        string = (String)((Object)fieldDoc2.fields[i]);
                        if (string == null) {
                            n2 = -1;
                            break;
                        }
                        if (string2 == null) {
                            n2 = 1;
                            break;
                        }
                        if (this.fields[i].getLocale() == null) {
                            n2 = string.compareTo(string2);
                            break;
                        }
                        n2 = this.collators[i].compare(string, string2);
                        break;
                    }
                    case 5: {
                        f2 = ((Float)fieldDoc.fields[i]).floatValue();
                        f = ((Float)fieldDoc2.fields[i]).floatValue();
                        if (f2 > f) {
                            n2 = -1;
                        }
                        if (!(f2 < f)) continue block16;
                        n2 = 1;
                        break;
                    }
                    case 9: {
                        n2 = fieldDoc2.fields[i].compareTo(fieldDoc.fields[i]);
                        break;
                    }
                    case 2: {
                        throw new RuntimeException("FieldDocSortedHitQueue cannot use an AUTO SortField");
                    }
                    default: {
                        throw new RuntimeException("invalid SortField type: " + n5);
                    }
                }
                continue;
            }
            switch (n5) {
                case 0: {
                    f4 = ((Float)fieldDoc.fields[i]).floatValue();
                    f3 = ((Float)fieldDoc2.fields[i]).floatValue();
                    if (f4 > f3) {
                        n2 = -1;
                    }
                    if (!(f4 < f3)) continue block16;
                    n2 = 1;
                    continue block16;
                }
                case 1: 
                case 4: {
                    n4 = (Integer)fieldDoc.fields[i];
                    n3 = (Integer)fieldDoc2.fields[i];
                    if (n4 < n3) {
                        n2 = -1;
                    }
                    if (n4 <= n3) continue block16;
                    n2 = 1;
                    continue block16;
                }
                case 3: {
                    string2 = (String)((Object)fieldDoc.fields[i]);
                    string = (String)((Object)fieldDoc2.fields[i]);
                    if (string2 == null) {
                        n2 = -1;
                        continue block16;
                    }
                    if (string == null) {
                        n2 = 1;
                        continue block16;
                    }
                    if (this.fields[i].getLocale() == null) {
                        n2 = string2.compareTo(string);
                        continue block16;
                    }
                    n2 = this.collators[i].compare(string2, string);
                    continue block16;
                }
                case 5: {
                    f2 = ((Float)fieldDoc.fields[i]).floatValue();
                    f = ((Float)fieldDoc2.fields[i]).floatValue();
                    if (f2 < f) {
                        n2 = -1;
                    }
                    if (!(f2 > f)) continue block16;
                    n2 = 1;
                    continue block16;
                }
                case 9: {
                    n2 = fieldDoc.fields[i].compareTo(fieldDoc2.fields[i]);
                    continue block16;
                }
                case 2: {
                    throw new RuntimeException("FieldDocSortedHitQueue cannot use an AUTO SortField");
                }
                default: {
                    throw new RuntimeException("invalid SortField type: " + n5);
                }
            }
        }
        return n2 > 0;
    }
}

