/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.search;

import gate.creole.annic.apache.lucene.index.IndexReader;
import gate.creole.annic.apache.lucene.index.Term;
import gate.creole.annic.apache.lucene.index.TermDocs;
import gate.creole.annic.apache.lucene.index.TermEnum;
import gate.creole.annic.apache.lucene.search.FieldCache;
import gate.creole.annic.apache.lucene.search.SortComparator;
import java.io.IOException;
import java.util.Map;
import java.util.WeakHashMap;

class FieldCacheImpl
implements FieldCache {
    final Map cache = new WeakHashMap();

    FieldCacheImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object lookup(IndexReader indexReader, String string, int n) {
        Entry entry = new Entry(indexReader, string, n);
        FieldCacheImpl fieldCacheImpl = this;
        synchronized (fieldCacheImpl) {
            return this.cache.get(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object lookup(IndexReader indexReader, String string, Object object) {
        Entry entry = new Entry(indexReader, string, object);
        FieldCacheImpl fieldCacheImpl = this;
        synchronized (fieldCacheImpl) {
            return this.cache.get(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object store(IndexReader indexReader, String string, int n, Object object) {
        Entry entry = new Entry(indexReader, string, n);
        FieldCacheImpl fieldCacheImpl = this;
        synchronized (fieldCacheImpl) {
            return this.cache.put(entry, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object store(IndexReader indexReader, String string, Object object, Object object2) {
        Entry entry = new Entry(indexReader, string, object);
        FieldCacheImpl fieldCacheImpl = this;
        synchronized (fieldCacheImpl) {
            return this.cache.put(entry, object2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getInts(IndexReader indexReader, String string) throws IOException {
        Object object = this.lookup(indexReader, string = string.intern(), 4);
        if (object == null) {
            int[] nArray = new int[indexReader.maxDoc()];
            if (nArray.length > 0) {
                TermDocs termDocs = indexReader.termDocs();
                TermEnum termEnum = indexReader.terms(new Term(string, ""));
                try {
                    if (termEnum.term() == null) {
                        throw new RuntimeException("no terms in field " + string);
                    }
                    do {
                        Term term;
                        if ((term = termEnum.term()).field() != string) {
                            break;
                        }
                        int n = Integer.parseInt(term.text());
                        termDocs.seek(termEnum);
                        while (termDocs.next()) {
                            nArray[termDocs.doc()] = n;
                        }
                    } while (termEnum.next());
                }
                finally {
                    termDocs.close();
                    termEnum.close();
                }
            }
            this.store(indexReader, string, 4, (Object)nArray);
            return nArray;
        }
        return (int[])object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] getFloats(IndexReader indexReader, String string) throws IOException {
        Object object = this.lookup(indexReader, string = string.intern(), 5);
        if (object == null) {
            float[] fArray = new float[indexReader.maxDoc()];
            if (fArray.length > 0) {
                TermDocs termDocs = indexReader.termDocs();
                TermEnum termEnum = indexReader.terms(new Term(string, ""));
                try {
                    if (termEnum.term() == null) {
                        throw new RuntimeException("no terms in field " + string);
                    }
                    do {
                        Term term;
                        if ((term = termEnum.term()).field() != string) {
                            break;
                        }
                        float f = Float.parseFloat(term.text());
                        termDocs.seek(termEnum);
                        while (termDocs.next()) {
                            fArray[termDocs.doc()] = f;
                        }
                    } while (termEnum.next());
                }
                finally {
                    termDocs.close();
                    termEnum.close();
                }
            }
            this.store(indexReader, string, 5, (Object)fArray);
            return fArray;
        }
        return (float[])object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getStrings(IndexReader indexReader, String string) throws IOException {
        Object object = this.lookup(indexReader, string = string.intern(), 3);
        if (object == null) {
            String[] stringArray = new String[indexReader.maxDoc()];
            if (stringArray.length > 0) {
                TermDocs termDocs = indexReader.termDocs();
                TermEnum termEnum = indexReader.terms(new Term(string, ""));
                try {
                    if (termEnum.term() == null) {
                        throw new RuntimeException("no terms in field " + string);
                    }
                    do {
                        Term term;
                        if ((term = termEnum.term()).field() != string) {
                            break;
                        }
                        String string2 = term.text();
                        termDocs.seek(termEnum);
                        while (termDocs.next()) {
                            stringArray[termDocs.doc()] = string2;
                        }
                    } while (termEnum.next());
                }
                finally {
                    termDocs.close();
                    termEnum.close();
                }
            }
            this.store(indexReader, string, 3, (Object)stringArray);
            return stringArray;
        }
        return (String[])object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldCache.StringIndex getStringIndex(IndexReader indexReader, String string) throws IOException {
        Object object = this.lookup(indexReader, string = string.intern(), -1);
        if (object == null) {
            Object object2;
            int[] nArray = new int[indexReader.maxDoc()];
            String[] stringArray = new String[indexReader.maxDoc() + 1];
            if (nArray.length > 0) {
                String[] stringArray2;
                object2 = indexReader.termDocs();
                TermEnum termEnum = indexReader.terms(new Term(string, ""));
                int n = 0;
                stringArray[n++] = null;
                try {
                    if (termEnum.term() == null) {
                        throw new RuntimeException("no terms in field " + string);
                    }
                    do {
                        if ((stringArray2 = termEnum.term()).field() != string) {
                            break;
                        }
                        if (n >= stringArray.length) {
                            throw new RuntimeException("there are more terms than documents in field \"" + string + "\"");
                        }
                        stringArray[n] = stringArray2.text();
                        object2.seek(termEnum);
                        while (object2.next()) {
                            nArray[object2.doc()] = n;
                        }
                        ++n;
                    } while (termEnum.next());
                }
                finally {
                    object2.close();
                    termEnum.close();
                }
                if (n == 0) {
                    stringArray = new String[1];
                } else if (n < stringArray.length) {
                    stringArray2 = new String[n];
                    System.arraycopy(stringArray, 0, stringArray2, 0, n);
                    stringArray = stringArray2;
                }
            }
            object2 = new FieldCache.StringIndex(nArray, stringArray);
            this.store(indexReader, string, -1, object2);
            return object2;
        }
        return (FieldCache.StringIndex)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAuto(IndexReader indexReader, String string) throws IOException {
        Object object;
        block11: {
            object = this.lookup(indexReader, string = string.intern(), 2);
            if (object == null) {
                TermEnum termEnum = indexReader.terms(new Term(string, ""));
                try {
                    Term term = termEnum.term();
                    if (term == null) {
                        throw new RuntimeException("no terms in field " + string + " - cannot determine sort type");
                    }
                    if (term.field() == string) {
                        String string2 = term.text().trim();
                        try {
                            Integer.parseInt(string2);
                            object = this.getInts(indexReader, string);
                        }
                        catch (NumberFormatException numberFormatException) {
                            try {
                                Float.parseFloat(string2);
                                object = this.getFloats(indexReader, string);
                            }
                            catch (NumberFormatException numberFormatException2) {
                                object = this.getStringIndex(indexReader, string);
                            }
                        }
                        if (object != null) {
                            this.store(indexReader, string, 2, object);
                        }
                        break block11;
                    }
                    throw new RuntimeException("field \"" + string + "\" does not appear to be indexed");
                }
                finally {
                    termEnum.close();
                }
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Comparable[] getCustom(IndexReader indexReader, String string, SortComparator sortComparator) throws IOException {
        Object object = this.lookup(indexReader, string = string.intern(), sortComparator);
        if (object == null) {
            Comparable[] comparableArray = new Comparable[indexReader.maxDoc()];
            if (comparableArray.length > 0) {
                TermDocs termDocs = indexReader.termDocs();
                TermEnum termEnum = indexReader.terms(new Term(string, ""));
                try {
                    if (termEnum.term() == null) {
                        throw new RuntimeException("no terms in field " + string);
                    }
                    do {
                        Term term;
                        if ((term = termEnum.term()).field() != string) {
                            break;
                        }
                        Comparable comparable = sortComparator.getComparable(term.text());
                        termDocs.seek(termEnum);
                        while (termDocs.next()) {
                            comparableArray[termDocs.doc()] = comparable;
                        }
                    } while (termEnum.next());
                }
                finally {
                    termDocs.close();
                    termEnum.close();
                }
            }
            this.store(indexReader, string, 9, (Object)comparableArray);
            return comparableArray;
        }
        return (String[])object;
    }

    static class Entry {
        final IndexReader reader;
        final String field;
        final int type;
        final Object custom;
        final int hashcode;

        Entry(IndexReader indexReader, String string, int n) {
            this.reader = indexReader;
            this.field = string.intern();
            this.type = n;
            this.custom = null;
            this.hashcode = indexReader.hashCode() ^ string.hashCode() ^ n;
        }

        Entry(IndexReader indexReader, String string, Object object) {
            this.reader = indexReader;
            this.field = string.intern();
            this.type = 9;
            this.custom = object;
            this.hashcode = indexReader.hashCode() ^ string.hashCode() ^ this.type ^ object.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof Entry) {
                Entry entry = (Entry)object;
                if (entry.reader == this.reader && entry.field == this.field && entry.type == this.type && (entry.custom == null ? this.custom == null : entry.custom.equals(this.custom))) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return this.hashcode;
        }
    }
}

