/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.search;

import gate.creole.annic.apache.lucene.index.TermPositions;
import gate.creole.annic.apache.lucene.search.IndexSearcher;
import gate.creole.annic.apache.lucene.search.PhrasePositions;
import gate.creole.annic.apache.lucene.search.PhraseScorer;
import gate.creole.annic.apache.lucene.search.Similarity;
import gate.creole.annic.apache.lucene.search.Weight;
import gate.creole.annic.lucene.LuceneIndexSearcher;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;

final class ExactPhraseScorer
extends PhraseScorer {
    int patternSize = 0;

    ExactPhraseScorer(Weight weight, TermPositions[] termPositionsArray, Similarity similarity, byte[] byArray) throws IOException {
        super(weight, termPositionsArray, similarity, byArray);
    }

    ExactPhraseScorer(Weight weight, TermPositions[] termPositionsArray, Vector vector, int n, Similarity similarity, byte[] byArray) throws IOException {
        super(weight, termPositionsArray, vector, similarity, byArray);
        this.patternSize = n;
    }

    ExactPhraseScorer(Weight weight, TermPositions[] termPositionsArray, Vector vector, int n, Similarity similarity, byte[] byArray, IndexSearcher indexSearcher) throws IOException {
        super(weight, termPositionsArray, vector, similarity, byArray, indexSearcher);
        this.patternSize = n;
    }

    protected final float phraseFreq() throws IOException {
        PhrasePositions phrasePositions = this.first;
        while (phrasePositions != null) {
            phrasePositions.firstPosition();
            this.pq.put(phrasePositions);
            phrasePositions = phrasePositions.next;
        }
        this.pqToList();
        int n = 0;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        while (true) {
            if (this.first.position < this.last.position) {
                do {
                    if (this.first.nextPosition()) continue;
                    ((LuceneIndexSearcher)this.searcher).setFirstTermPositions(1, this.first.doc, arrayList, this.patternSize);
                    return n;
                } while (this.first.position < this.last.position);
                this.firstToLast();
                continue;
            }
            arrayList.add(new Integer(this.first.position));
            ++n;
            if (!this.last.nextPosition()) break;
        }
        ((LuceneIndexSearcher)this.searcher).setFirstTermPositions(1, this.first.doc, arrayList, this.patternSize);
        return n;
    }
}

