/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.search;

import gate.creole.annic.apache.lucene.document.DateField;
import gate.creole.annic.apache.lucene.index.IndexReader;
import gate.creole.annic.apache.lucene.index.Term;
import gate.creole.annic.apache.lucene.index.TermDocs;
import gate.creole.annic.apache.lucene.index.TermEnum;
import gate.creole.annic.apache.lucene.search.Filter;
import java.io.IOException;
import java.util.BitSet;
import java.util.Date;

public class DateFilter
extends Filter {
    String field;
    String start = DateField.MIN_DATE_STRING();
    String end = DateField.MAX_DATE_STRING();

    private DateFilter(String string) {
        this.field = string;
    }

    public DateFilter(String string, Date date, Date date2) {
        this.field = string;
        this.start = DateField.dateToString(date);
        this.end = DateField.dateToString(date2);
    }

    public DateFilter(String string, long l, long l2) {
        this.field = string;
        this.start = DateField.timeToString(l);
        this.end = DateField.timeToString(l2);
    }

    public static DateFilter Before(String string, Date date) {
        DateFilter dateFilter = new DateFilter(string);
        dateFilter.end = DateField.dateToString(date);
        return dateFilter;
    }

    public static DateFilter Before(String string, long l) {
        DateFilter dateFilter = new DateFilter(string);
        dateFilter.end = DateField.timeToString(l);
        return dateFilter;
    }

    public static DateFilter After(String string, Date date) {
        DateFilter dateFilter = new DateFilter(string);
        dateFilter.start = DateField.dateToString(date);
        return dateFilter;
    }

    public static DateFilter After(String string, long l) {
        DateFilter dateFilter = new DateFilter(string);
        dateFilter.start = DateField.timeToString(l);
        return dateFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BitSet bits(IndexReader indexReader) throws IOException {
        BitSet bitSet = new BitSet(indexReader.maxDoc());
        TermEnum termEnum = indexReader.terms(new Term(this.field, this.start));
        TermDocs termDocs = indexReader.termDocs();
        if (termEnum.term() == null) {
            return bitSet;
        }
        try {
            Term term = new Term(this.field, this.end);
            while (termEnum.term().compareTo(term) <= 0) {
                termDocs.seek(termEnum.term());
                while (termDocs.next()) {
                    bitSet.set(termDocs.doc());
                }
                if (termEnum.next()) continue;
                break;
            }
        }
        finally {
            termEnum.close();
            termDocs.close();
        }
        return bitSet;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.field);
        stringBuffer.append(":");
        stringBuffer.append(DateField.stringToDate(this.start).toString());
        stringBuffer.append("-");
        stringBuffer.append(DateField.stringToDate(this.end).toString());
        return stringBuffer.toString();
    }
}

