/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.search;

import gate.creole.annic.apache.lucene.search.Explanation;
import gate.creole.annic.apache.lucene.search.IndexSearcher;
import gate.creole.annic.apache.lucene.search.Scorer;
import gate.creole.annic.apache.lucene.search.Similarity;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;

final class ConjunctionScorer
extends Scorer {
    private LinkedList scorers = new LinkedList();
    private boolean firstTime = true;
    private boolean more = true;
    private float coord;
    IndexSearcher searcher = null;

    public ConjunctionScorer(Similarity similarity) {
        super(similarity);
    }

    final void add(Scorer scorer) throws IOException {
        this.scorers.addLast(scorer);
    }

    private Scorer first() {
        return (Scorer)this.scorers.getFirst();
    }

    private Scorer last() {
        return (Scorer)this.scorers.getLast();
    }

    public int doc() {
        return this.first().doc();
    }

    public boolean next() throws IOException {
        if (this.firstTime) {
            this.init();
        } else if (this.more) {
            this.more = this.last().next();
        }
        return this.doNext();
    }

    private boolean doNext() throws IOException {
        while (this.more && this.first().doc() < this.last().doc()) {
            this.more = this.first().skipTo(this.last().doc());
            this.scorers.addLast(this.scorers.removeFirst());
        }
        return this.more;
    }

    public boolean skipTo(int n) throws IOException {
        Iterator iterator = this.scorers.iterator();
        while (this.more && iterator.hasNext()) {
            this.more = ((Scorer)iterator.next()).skipTo(n);
        }
        if (this.more) {
            this.sortScorers();
        }
        return this.doNext();
    }

    public float score(IndexSearcher indexSearcher) throws IOException {
        this.searcher = indexSearcher;
        return this.score();
    }

    public float score() throws IOException {
        float f = 0.0f;
        Iterator iterator = this.scorers.iterator();
        while (iterator.hasNext()) {
            f += ((Scorer)iterator.next()).score(this.searcher);
        }
        return f *= this.coord;
    }

    private void init() throws IOException {
        this.more = this.scorers.size() > 0;
        this.coord = this.getSimilarity().coord(this.scorers.size(), this.scorers.size());
        Iterator iterator = this.scorers.iterator();
        while (this.more && iterator.hasNext()) {
            this.more = ((Scorer)iterator.next()).next();
        }
        if (this.more) {
            this.sortScorers();
        }
        this.firstTime = false;
    }

    private void sortScorers() throws IOException {
        Scorer[] scorerArray = this.scorers.toArray(new Scorer[this.scorers.size()]);
        this.scorers.clear();
        Arrays.sort(scorerArray, new Comparator(){

            public int compare(Object object, Object object2) {
                return ((Scorer)object).doc() - ((Scorer)object2).doc();
            }

            public boolean equals(Object object, Object object2) {
                return ((Scorer)object).doc() == ((Scorer)object2).doc();
            }
        });
        for (int i = 0; i < scorerArray.length; ++i) {
            this.scorers.addLast(scorerArray[i]);
        }
    }

    public Explanation explain(int n) throws IOException {
        throw new UnsupportedOperationException();
    }
}

