/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.index;

import gate.creole.annic.apache.lucene.index.FieldInfos;
import gate.creole.annic.apache.lucene.index.TermFreqVector;
import gate.creole.annic.apache.lucene.store.Directory;
import gate.creole.annic.apache.lucene.store.OutputStream;
import gate.creole.annic.apache.lucene.util.StringHelper;
import java.io.IOException;
import java.util.Vector;

final class TermVectorsWriter {
    public static final int FORMAT_VERSION = 1;
    public static final int FORMAT_SIZE = 4;
    public static final String TVX_EXTENSION = ".tvx";
    public static final String TVD_EXTENSION = ".tvd";
    public static final String TVF_EXTENSION = ".tvf";
    private OutputStream tvx = null;
    private OutputStream tvd = null;
    private OutputStream tvf = null;
    private Vector fields = null;
    private Vector terms = null;
    private FieldInfos fieldInfos;
    private TVField currentField = null;
    private long currentDocPointer = -1L;

    public TermVectorsWriter(Directory directory, String string, FieldInfos fieldInfos) throws IOException {
        this.tvx = directory.createFile(string + TVX_EXTENSION);
        this.tvx.writeInt(1);
        this.tvd = directory.createFile(string + TVD_EXTENSION);
        this.tvd.writeInt(1);
        this.tvf = directory.createFile(string + TVF_EXTENSION);
        this.tvf.writeInt(1);
        this.fieldInfos = fieldInfos;
        this.fields = new Vector(fieldInfos.size());
        this.terms = new Vector();
    }

    public final void openDocument() throws IOException {
        this.closeDocument();
        this.currentDocPointer = this.tvd.getFilePointer();
    }

    public final void closeDocument() throws IOException {
        if (this.isDocumentOpen()) {
            this.closeField();
            this.writeDoc();
            this.fields.clear();
            this.currentDocPointer = -1L;
        }
    }

    public final boolean isDocumentOpen() {
        return this.currentDocPointer != -1L;
    }

    public final void openField(String string) throws IOException {
        if (!this.isDocumentOpen()) {
            throw new IllegalStateException("Cannot open field when no document is open.");
        }
        this.closeField();
        this.currentField = new TVField(this.fieldInfos.fieldNumber(string));
    }

    public final void closeField() throws IOException {
        if (this.isFieldOpen()) {
            this.writeField();
            this.fields.add(this.currentField);
            this.terms.clear();
            this.currentField = null;
        }
    }

    public final boolean isFieldOpen() {
        return this.currentField != null;
    }

    public final void addTerm(String string, int n) {
        if (!this.isDocumentOpen()) {
            throw new IllegalStateException("Cannot add terms when document is not open");
        }
        if (!this.isFieldOpen()) {
            throw new IllegalStateException("Cannot add terms when field is not open");
        }
        this.addTermInternal(string, n);
    }

    private final void addTermInternal(String string, int n) {
        this.currentField.length += n;
        TVTerm tVTerm = new TVTerm();
        tVTerm.termText = string;
        tVTerm.freq = n;
        this.terms.add(tVTerm);
    }

    public final void addVectors(TermFreqVector[] termFreqVectorArray) throws IOException {
        if (!this.isDocumentOpen()) {
            throw new IllegalStateException("Cannot add term vectors when document is not open");
        }
        if (this.isFieldOpen()) {
            throw new IllegalStateException("Cannot add term vectors when field is open");
        }
        for (int i = 0; i < termFreqVectorArray.length; ++i) {
            this.addTermFreqVector(termFreqVectorArray[i]);
        }
    }

    public final void addTermFreqVector(TermFreqVector termFreqVector) throws IOException {
        if (!this.isDocumentOpen()) {
            throw new IllegalStateException("Cannot add term vector when document is not open");
        }
        if (this.isFieldOpen()) {
            throw new IllegalStateException("Cannot add term vector when field is open");
        }
        this.addTermFreqVectorInternal(termFreqVector);
    }

    private final void addTermFreqVectorInternal(TermFreqVector termFreqVector) throws IOException {
        this.openField(termFreqVector.getField());
        for (int i = 0; i < termFreqVector.size(); ++i) {
            this.addTermInternal(termFreqVector.getTerms()[i], termFreqVector.getTermFrequencies()[i]);
        }
        this.closeField();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void close() throws IOException {
        IOException iOException;
        block20: {
            IOException iOException22;
            block19: {
                block18: {
                    try {
                        this.closeDocument();
                        Object var2_1 = null;
                        iOException = null;
                        if (this.tvx == null) break block18;
                    }
                    catch (Throwable throwable) {
                        IOException iOException3;
                        block23: {
                            IOException iOException42;
                            block22: {
                                block21: {
                                    Object var2_2 = null;
                                    iOException3 = null;
                                    if (this.tvx != null) {
                                        try {
                                            this.tvx.close();
                                        }
                                        catch (IOException iOException42) {
                                            if (iOException3 != null) break block21;
                                            iOException3 = iOException42;
                                        }
                                    }
                                }
                                if (this.tvd != null) {
                                    try {
                                        this.tvd.close();
                                    }
                                    catch (IOException iOException42) {
                                        if (iOException3 != null) break block22;
                                        iOException3 = iOException42;
                                    }
                                }
                            }
                            if (this.tvf != null) {
                                try {
                                    this.tvf.close();
                                }
                                catch (IOException iOException42) {
                                    if (iOException3 != null) break block23;
                                    iOException3 = iOException42;
                                }
                            }
                        }
                        if (iOException3 != null) {
                            throw (IOException)iOException3.fillInStackTrace();
                        }
                        throw throwable;
                    }
                    try {
                        this.tvx.close();
                    }
                    catch (IOException iOException22) {
                        if (iOException != null) break block18;
                        iOException = iOException22;
                    }
                }
                if (this.tvd != null) {
                    try {
                        this.tvd.close();
                    }
                    catch (IOException iOException22) {
                        if (iOException != null) break block19;
                        iOException = iOException22;
                    }
                }
            }
            if (this.tvf != null) {
                try {
                    this.tvf.close();
                }
                catch (IOException iOException22) {
                    if (iOException != null) break block20;
                    iOException = iOException22;
                }
            }
        }
        if (iOException != null) {
            throw (IOException)iOException.fillInStackTrace();
        }
    }

    private void writeField() throws IOException {
        this.currentField.tvfPointer = this.tvf.getFilePointer();
        int n = this.terms.size();
        this.tvf.writeVInt(n);
        this.tvf.writeVInt(this.currentField.length - n);
        String string = "";
        for (int i = 0; i < n; ++i) {
            TVTerm tVTerm = (TVTerm)this.terms.elementAt(i);
            int n2 = StringHelper.stringDifference(string, tVTerm.termText);
            int n3 = tVTerm.termText.length() - n2;
            this.tvf.writeVInt(n2);
            this.tvf.writeVInt(n3);
            this.tvf.writeChars(tVTerm.termText, n2, n3);
            this.tvf.writeVInt(tVTerm.freq);
            string = tVTerm.termText;
        }
    }

    private void writeDoc() throws IOException {
        if (this.isFieldOpen()) {
            throw new IllegalStateException("Field is still open while writing document");
        }
        this.tvx.writeLong(this.currentDocPointer);
        int n = this.fields.size();
        this.tvd.writeVInt(n);
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            TVField tVField = (TVField)this.fields.elementAt(i);
            this.tvd.writeVInt(tVField.number - n2);
            n2 = tVField.number;
        }
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            TVField tVField = (TVField)this.fields.elementAt(i);
            this.tvd.writeVLong(tVField.tvfPointer - l);
            l = tVField.tvfPointer;
        }
    }

    private static class TVTerm {
        String termText;
        String type;
        int position;
        int freq = 0;

        private TVTerm() {
        }
    }

    private static class TVField {
        int number;
        long tvfPointer = 0L;
        int length = 0;

        TVField(int n) {
            this.number = n;
        }
    }
}

