/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.index;

import gate.creole.annic.apache.lucene.index.FieldInfos;
import gate.creole.annic.apache.lucene.index.SegmentTermVector;
import gate.creole.annic.apache.lucene.index.TermFreqVector;
import gate.creole.annic.apache.lucene.store.Directory;
import gate.creole.annic.apache.lucene.store.InputStream;
import java.io.IOException;

class TermVectorsReader {
    private FieldInfos fieldInfos;
    private InputStream tvx;
    private InputStream tvd;
    private InputStream tvf;
    private int size;

    TermVectorsReader(Directory directory, String string, FieldInfos fieldInfos) throws IOException {
        if (directory.fileExists(string + ".tvx")) {
            this.tvx = directory.openFile(string + ".tvx");
            this.checkValidFormat(this.tvx);
            this.tvd = directory.openFile(string + ".tvd");
            this.checkValidFormat(this.tvd);
            this.tvf = directory.openFile(string + ".tvf");
            this.checkValidFormat(this.tvf);
            this.size = (int)this.tvx.length() / 8;
        }
        this.fieldInfos = fieldInfos;
    }

    private void checkValidFormat(InputStream inputStream) throws IOException {
        int n = inputStream.readInt();
        if (n > 1) {
            throw new IOException("Incompatible format version: " + n + " expected " + 1 + " or less");
        }
    }

    synchronized void close() throws IOException {
        if (this.tvx != null) {
            this.tvx.close();
        }
        if (this.tvd != null) {
            this.tvd.close();
        }
        if (this.tvf != null) {
            this.tvf.close();
        }
    }

    int size() {
        return this.size;
    }

    synchronized TermFreqVector get(int n, String string) {
        int n2 = this.fieldInfos.fieldNumber(string);
        SegmentTermVector segmentTermVector = null;
        if (this.tvx != null) {
            try {
                int n3;
                this.tvx.seek((long)n * 8L + 4L);
                long l = this.tvx.readLong();
                this.tvd.seek(l);
                int n4 = this.tvd.readVInt();
                int n5 = 0;
                int n6 = -1;
                for (n3 = 0; n3 < n4; ++n3) {
                    if ((n5 += this.tvd.readVInt()) != n2) continue;
                    n6 = n3;
                }
                if (n6 != -1) {
                    l = 0L;
                    for (n3 = 0; n3 <= n6; ++n3) {
                        l += this.tvd.readVLong();
                    }
                    segmentTermVector = this.readTermVector(string, l);
                }
            }
            catch (Exception exception) {}
        } else {
            System.out.println("No tvx file");
        }
        return segmentTermVector;
    }

    synchronized TermFreqVector[] get(int n) {
        SegmentTermVector[] segmentTermVectorArray = null;
        if (this.tvx != null) {
            try {
                this.tvx.seek((long)n * 8L + 4L);
                long l = this.tvx.readLong();
                this.tvd.seek(l);
                int n2 = this.tvd.readVInt();
                if (n2 != 0) {
                    int n3 = 0;
                    String[] stringArray = new String[n2];
                    for (int i = 0; i < n2; ++i) {
                        stringArray[i] = this.fieldInfos.fieldName(n3 += this.tvd.readVInt());
                    }
                    l = 0L;
                    long[] lArray = new long[n2];
                    for (int i = 0; i < n2; ++i) {
                        lArray[i] = l += this.tvd.readVLong();
                    }
                    segmentTermVectorArray = this.readTermVectors(stringArray, lArray);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else {
            System.out.println("No tvx file");
        }
        return segmentTermVectorArray;
    }

    private SegmentTermVector[] readTermVectors(String[] stringArray, long[] lArray) throws IOException {
        SegmentTermVector[] segmentTermVectorArray = new SegmentTermVector[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            segmentTermVectorArray[i] = this.readTermVector(stringArray[i], lArray[i]);
        }
        return segmentTermVectorArray;
    }

    private SegmentTermVector readTermVector(String string, long l) throws IOException {
        this.tvf.seek(l);
        int n = this.tvf.readVInt();
        if (n == 0) {
            return new SegmentTermVector(string, null, null);
        }
        int n2 = n + this.tvf.readVInt();
        String[] stringArray = new String[n];
        int[] nArray = new int[n];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        char[] cArray = new char[]{};
        String string2 = "";
        for (int i = 0; i < n; ++i) {
            n3 = this.tvf.readVInt();
            n5 = n3 + (n4 = this.tvf.readVInt());
            if (cArray.length < n5) {
                cArray = new char[n5];
                for (int j = 0; j < string2.length(); ++j) {
                    cArray[j] = string2.charAt(j);
                }
            }
            this.tvf.readChars(cArray, n3, n4);
            stringArray[i] = new String(cArray, 0, n5);
            string2 = stringArray[i];
            nArray[i] = this.tvf.readVInt();
        }
        SegmentTermVector segmentTermVector = new SegmentTermVector(string, stringArray, nArray);
        return segmentTermVector;
    }
}

