/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.index;

import gate.creole.annic.apache.lucene.index.TermFreqVector;
import java.util.Arrays;

class SegmentTermVector
implements TermFreqVector {
    private String field;
    private String[] terms;
    private int[] termFreqs;

    SegmentTermVector(String string, String[] stringArray, int[] nArray) {
        this.field = string;
        this.terms = stringArray;
        this.termFreqs = nArray;
    }

    public String getField() {
        return this.field;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('{');
        stringBuffer.append(this.field).append(": ");
        for (int i = 0; i < this.terms.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.terms[i]).append('/').append(this.termFreqs[i]);
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    public int size() {
        return this.terms == null ? 0 : this.terms.length;
    }

    public String[] getTerms() {
        return this.terms;
    }

    public int[] getTermFrequencies() {
        return this.termFreqs;
    }

    public int indexOf(String string) {
        int n = Arrays.binarySearch(this.terms, string);
        return n >= 0 ? n : -1;
    }

    public int[] indexesOf(String[] stringArray, int n, int n2) {
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = this.indexOf(stringArray[i]);
        }
        return nArray;
    }
}

