/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.index;

import gate.creole.annic.apache.lucene.index.SegmentReader;
import gate.creole.annic.apache.lucene.index.SegmentTermDocs;
import gate.creole.annic.apache.lucene.index.TermInfo;
import gate.creole.annic.apache.lucene.index.TermPositions;
import gate.creole.annic.apache.lucene.store.InputStream;
import java.io.IOException;

final class SegmentTermPositions
extends SegmentTermDocs
implements TermPositions {
    private InputStream proxStream;
    private int proxCount;
    private int position;

    SegmentTermPositions(SegmentReader segmentReader) throws IOException {
        super(segmentReader);
        this.proxStream = (InputStream)this.parent.proxStream.clone();
    }

    final void seek(TermInfo termInfo) throws IOException {
        super.seek(termInfo);
        if (termInfo != null) {
            this.proxStream.seek(termInfo.proxPointer);
        }
        this.proxCount = 0;
    }

    public final void close() throws IOException {
        super.close();
        this.proxStream.close();
    }

    public final int nextPosition() throws IOException {
        --this.proxCount;
        return this.position += this.proxStream.readVInt();
    }

    protected final void skippingDoc() throws IOException {
        for (int i = this.freq; i > 0; --i) {
            this.proxStream.readVInt();
        }
    }

    public final boolean next() throws IOException {
        for (int i = this.proxCount; i > 0; --i) {
            this.proxStream.readVInt();
        }
        if (super.next()) {
            this.proxCount = this.freq;
            this.position = 0;
            return true;
        }
        return false;
    }

    public final int read(int[] nArray, int[] nArray2) throws IOException {
        throw new UnsupportedOperationException("TermPositions does not support processing multiple documents in one call. Use TermDocs instead.");
    }

    protected void skipProx(long l) throws IOException {
        this.proxStream.seek(l);
        this.proxCount = 0;
    }
}

