/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.index;

import gate.creole.annic.apache.lucene.index.SegmentReader;
import gate.creole.annic.apache.lucene.index.SegmentTermEnum;
import gate.creole.annic.apache.lucene.index.Term;
import gate.creole.annic.apache.lucene.index.TermDocs;
import gate.creole.annic.apache.lucene.index.TermEnum;
import gate.creole.annic.apache.lucene.index.TermInfo;
import gate.creole.annic.apache.lucene.store.InputStream;
import gate.creole.annic.apache.lucene.util.BitVector;
import java.io.IOException;

class SegmentTermDocs
implements TermDocs {
    protected SegmentReader parent;
    private InputStream freqStream;
    private int count;
    private int df;
    private BitVector deletedDocs;
    int doc = 0;
    int freq;
    private int skipInterval;
    private int numSkips;
    private int skipCount;
    private InputStream skipStream;
    private int skipDoc;
    private long freqPointer;
    private long proxPointer;
    private long skipPointer;
    private boolean haveSkipped;

    SegmentTermDocs(SegmentReader segmentReader) throws IOException {
        this.parent = segmentReader;
        this.freqStream = (InputStream)segmentReader.freqStream.clone();
        this.deletedDocs = segmentReader.deletedDocs;
        this.skipInterval = segmentReader.tis.getSkipInterval();
    }

    public void seek(Term term) throws IOException {
        TermInfo termInfo = this.parent.tis.get(term);
        this.seek(termInfo);
    }

    public void seek(TermEnum termEnum) throws IOException {
        TermInfo termInfo = termEnum instanceof SegmentTermEnum && ((SegmentTermEnum)termEnum).fieldInfos == this.parent.fieldInfos ? ((SegmentTermEnum)termEnum).termInfo() : this.parent.tis.get(termEnum.term());
        this.seek(termInfo);
    }

    void seek(TermInfo termInfo) throws IOException {
        this.count = 0;
        if (termInfo == null) {
            this.df = 0;
        } else {
            this.df = termInfo.docFreq;
            this.doc = 0;
            this.skipDoc = 0;
            this.skipCount = 0;
            this.numSkips = this.df / this.skipInterval;
            this.freqPointer = termInfo.freqPointer;
            this.proxPointer = termInfo.proxPointer;
            this.skipPointer = this.freqPointer + (long)termInfo.skipOffset;
            this.freqStream.seek(this.freqPointer);
            this.haveSkipped = false;
        }
    }

    public void close() throws IOException {
        this.freqStream.close();
        if (this.skipStream != null) {
            this.skipStream.close();
        }
    }

    public final int doc() {
        return this.doc;
    }

    public final int freq() {
        return this.freq;
    }

    protected void skippingDoc() throws IOException {
    }

    public boolean next() throws IOException {
        while (true) {
            if (this.count == this.df) {
                return false;
            }
            int n = this.freqStream.readVInt();
            this.doc += n >>> 1;
            this.freq = (n & 1) != 0 ? 1 : this.freqStream.readVInt();
            ++this.count;
            if (this.deletedDocs == null || !this.deletedDocs.get(this.doc)) break;
            this.skippingDoc();
        }
        return true;
    }

    public int read(int[] nArray, int[] nArray2) throws IOException {
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n && this.count < this.df) {
            int n3 = this.freqStream.readVInt();
            this.doc += n3 >>> 1;
            this.freq = (n3 & 1) != 0 ? 1 : this.freqStream.readVInt();
            ++this.count;
            if (this.deletedDocs != null && this.deletedDocs.get(this.doc)) continue;
            nArray[n2] = this.doc;
            nArray2[n2] = this.freq;
            ++n2;
        }
        return n2;
    }

    protected void skipProx(long l) throws IOException {
    }

    public boolean skipTo(int n) throws IOException {
        if (this.df >= this.skipInterval) {
            if (this.skipStream == null) {
                this.skipStream = (InputStream)this.freqStream.clone();
            }
            if (!this.haveSkipped) {
                this.skipStream.seek(this.skipPointer);
                this.haveSkipped = true;
            }
            int n2 = this.skipDoc;
            long l = this.freqStream.getFilePointer();
            long l2 = -1L;
            int n3 = -1 - this.count % this.skipInterval;
            while (n > this.skipDoc) {
                n2 = this.skipDoc;
                l = this.freqPointer;
                l2 = this.proxPointer;
                if (this.skipDoc != 0 && this.skipDoc >= this.doc) {
                    n3 += this.skipInterval;
                }
                if (this.skipCount >= this.numSkips) break;
                this.skipDoc += this.skipStream.readVInt();
                this.freqPointer += (long)this.skipStream.readVInt();
                this.proxPointer += (long)this.skipStream.readVInt();
                ++this.skipCount;
            }
            if (l > this.freqStream.getFilePointer()) {
                this.freqStream.seek(l);
                this.skipProx(l2);
                this.doc = n2;
                this.count += n3;
            }
        }
        do {
            if (this.next()) continue;
            return false;
        } while (n > this.doc);
        return true;
    }
}

