/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.index;

import gate.creole.annic.apache.lucene.document.Document;
import gate.creole.annic.apache.lucene.index.CompoundFileReader;
import gate.creole.annic.apache.lucene.index.FieldInfo;
import gate.creole.annic.apache.lucene.index.FieldInfos;
import gate.creole.annic.apache.lucene.index.FieldsReader;
import gate.creole.annic.apache.lucene.index.IndexReader;
import gate.creole.annic.apache.lucene.index.SegmentInfo;
import gate.creole.annic.apache.lucene.index.SegmentInfos;
import gate.creole.annic.apache.lucene.index.SegmentTermDocs;
import gate.creole.annic.apache.lucene.index.SegmentTermPositions;
import gate.creole.annic.apache.lucene.index.Term;
import gate.creole.annic.apache.lucene.index.TermDocs;
import gate.creole.annic.apache.lucene.index.TermEnum;
import gate.creole.annic.apache.lucene.index.TermFreqVector;
import gate.creole.annic.apache.lucene.index.TermInfo;
import gate.creole.annic.apache.lucene.index.TermInfosReader;
import gate.creole.annic.apache.lucene.index.TermPositions;
import gate.creole.annic.apache.lucene.index.TermVectorsReader;
import gate.creole.annic.apache.lucene.store.Directory;
import gate.creole.annic.apache.lucene.store.InputStream;
import gate.creole.annic.apache.lucene.store.OutputStream;
import gate.creole.annic.apache.lucene.util.BitVector;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;

final class SegmentReader
extends IndexReader {
    private String segment;
    FieldInfos fieldInfos;
    private FieldsReader fieldsReader;
    TermInfosReader tis;
    TermVectorsReader termVectorsReader;
    BitVector deletedDocs = null;
    private boolean deletedDocsDirty = false;
    private boolean normsDirty = false;
    private boolean undeleteAll = false;
    InputStream freqStream;
    InputStream proxStream;
    CompoundFileReader cfsReader;
    private Hashtable norms = new Hashtable();

    SegmentReader(SegmentInfos segmentInfos, SegmentInfo segmentInfo, boolean bl) throws IOException {
        super(segmentInfo.dir, segmentInfos, bl);
        this.initialize(segmentInfo);
    }

    SegmentReader(SegmentInfo segmentInfo) throws IOException {
        super(segmentInfo.dir);
        this.initialize(segmentInfo);
    }

    private void initialize(SegmentInfo segmentInfo) throws IOException {
        this.segment = segmentInfo.name;
        Directory directory = this.directory();
        if (this.directory().fileExists(this.segment + ".cfs")) {
            this.cfsReader = new CompoundFileReader(this.directory(), this.segment + ".cfs");
            directory = this.cfsReader;
        }
        this.fieldInfos = new FieldInfos(directory, this.segment + ".fnm");
        this.fieldsReader = new FieldsReader(directory, this.segment, this.fieldInfos);
        this.tis = new TermInfosReader(directory, this.segment, this.fieldInfos);
        if (SegmentReader.hasDeletions(segmentInfo)) {
            this.deletedDocs = new BitVector(this.directory(), this.segment + ".del");
        }
        this.freqStream = directory.openFile(this.segment + ".frq");
        this.proxStream = directory.openFile(this.segment + ".prx");
        this.openNorms(directory);
        if (this.fieldInfos.hasVectors()) {
            this.termVectorsReader = new TermVectorsReader(directory, this.segment, this.fieldInfos);
        }
    }

    protected final void doCommit() throws IOException {
        if (this.deletedDocsDirty) {
            this.deletedDocs.write(this.directory(), this.segment + ".tmp");
            this.directory().renameFile(this.segment + ".tmp", this.segment + ".del");
        }
        if (this.undeleteAll && this.directory().fileExists(this.segment + ".del")) {
            this.directory().deleteFile(this.segment + ".del");
        }
        if (this.normsDirty) {
            Enumeration enumeration = this.norms.elements();
            while (enumeration.hasMoreElements()) {
                Norm norm = (Norm)enumeration.nextElement();
                if (!norm.dirty) continue;
                norm.reWrite();
            }
        }
        this.deletedDocsDirty = false;
        this.normsDirty = false;
        this.undeleteAll = false;
    }

    protected final void doClose() throws IOException {
        this.fieldsReader.close();
        this.tis.close();
        if (this.freqStream != null) {
            this.freqStream.close();
        }
        if (this.proxStream != null) {
            this.proxStream.close();
        }
        this.closeNorms();
        if (this.termVectorsReader != null) {
            this.termVectorsReader.close();
        }
        if (this.cfsReader != null) {
            this.cfsReader.close();
        }
    }

    static final boolean hasDeletions(SegmentInfo segmentInfo) throws IOException {
        return segmentInfo.dir.fileExists(segmentInfo.name + ".del");
    }

    public boolean hasDeletions() {
        return this.deletedDocs != null;
    }

    static final boolean usesCompoundFile(SegmentInfo segmentInfo) throws IOException {
        return segmentInfo.dir.fileExists(segmentInfo.name + ".cfs");
    }

    static final boolean hasSeparateNorms(SegmentInfo segmentInfo) throws IOException {
        String[] stringArray = segmentInfo.dir.list();
        String string = segmentInfo.name + ".f";
        int n = string.length();
        for (int i = 0; i < 0; ++i) {
            if (!stringArray[i].startsWith(string) || !Character.isDigit(stringArray[i].charAt(n))) continue;
            return true;
        }
        return false;
    }

    protected final void doDelete(int n) throws IOException {
        if (this.deletedDocs == null) {
            this.deletedDocs = new BitVector(this.maxDoc());
        }
        this.deletedDocsDirty = true;
        this.undeleteAll = false;
        this.deletedDocs.set(n);
    }

    protected final void doUndeleteAll() throws IOException {
        this.deletedDocs = null;
        this.deletedDocsDirty = false;
        this.undeleteAll = true;
    }

    final Vector files() throws IOException {
        Object object;
        int n;
        Vector<Object> vector = new Vector<Object>(16);
        String[] stringArray = new String[]{"cfs", "fnm", "fdx", "fdt", "tii", "tis", "frq", "prx", "del", "tvx", "tvd", "tvf", "tvp"};
        for (n = 0; n < stringArray.length; ++n) {
            object = this.segment + "." + stringArray[n];
            if (!this.directory().fileExists((String)object)) continue;
            vector.addElement(object);
        }
        for (n = 0; n < this.fieldInfos.size(); ++n) {
            object = this.fieldInfos.fieldInfo(n);
            if (!((FieldInfo)object).isIndexed) continue;
            vector.addElement(this.segment + ".f" + n);
        }
        return vector;
    }

    public final TermEnum terms() throws IOException {
        return this.tis.terms();
    }

    public final TermEnum terms(Term term) throws IOException {
        return this.tis.terms(term);
    }

    public final synchronized Document document(int n) throws IOException {
        if (this.isDeleted(n)) {
            throw new IllegalArgumentException("attempt to access a deleted document");
        }
        return this.fieldsReader.doc(n);
    }

    public final synchronized boolean isDeleted(int n) {
        return this.deletedDocs != null && this.deletedDocs.get(n);
    }

    public final TermDocs termDocs() throws IOException {
        return new SegmentTermDocs(this);
    }

    public final TermPositions termPositions() throws IOException {
        return new SegmentTermPositions(this);
    }

    public final int docFreq(Term term) throws IOException {
        TermInfo termInfo = this.tis.get(term);
        if (termInfo != null) {
            return termInfo.docFreq;
        }
        return 0;
    }

    public final int numDocs() {
        int n = this.maxDoc();
        if (this.deletedDocs != null) {
            n -= this.deletedDocs.count();
        }
        return n;
    }

    public final int maxDoc() {
        return this.fieldsReader.size();
    }

    public Collection getFieldNames() throws IOException {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < this.fieldInfos.size(); ++i) {
            FieldInfo fieldInfo = this.fieldInfos.fieldInfo(i);
            hashSet.add(fieldInfo.name);
        }
        return hashSet;
    }

    public Collection getFieldNames(boolean bl) throws IOException {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < this.fieldInfos.size(); ++i) {
            FieldInfo fieldInfo = this.fieldInfos.fieldInfo(i);
            if (fieldInfo.isIndexed != bl) continue;
            hashSet.add(fieldInfo.name);
        }
        return hashSet;
    }

    public Collection getIndexedFieldNames(boolean bl) {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < this.fieldInfos.size(); ++i) {
            FieldInfo fieldInfo = this.fieldInfos.fieldInfo(i);
            if (!fieldInfo.isIndexed || fieldInfo.storeTermVector != bl) continue;
            hashSet.add(fieldInfo.name);
        }
        return hashSet;
    }

    public synchronized byte[] norms(String string) throws IOException {
        Norm norm = (Norm)this.norms.get(string);
        if (norm == null) {
            return null;
        }
        if (norm.bytes == null) {
            byte[] byArray = new byte[this.maxDoc()];
            this.norms(string, byArray, 0);
            Norm.access$302(norm, byArray);
        }
        return norm.bytes;
    }

    protected final void doSetNorm(int n, String string, byte by) throws IOException {
        Norm norm = (Norm)this.norms.get(string);
        if (norm == null) {
            return;
        }
        norm.dirty = true;
        this.normsDirty = true;
        this.norms((String)string)[n] = by;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void norms(String string, byte[] byArray, int n) throws IOException {
        Norm norm = (Norm)this.norms.get(string);
        if (norm == null) {
            return;
        }
        if (norm.bytes != null) {
            System.arraycopy(norm.bytes, 0, byArray, n, this.maxDoc());
            return;
        }
        InputStream inputStream = (InputStream)norm.in.clone();
        try {
            inputStream.seek(0L);
            inputStream.readBytes(byArray, n, this.maxDoc());
        }
        finally {
            inputStream.close();
        }
    }

    private final void openNorms(Directory directory) throws IOException {
        for (int i = 0; i < this.fieldInfos.size(); ++i) {
            FieldInfo fieldInfo = this.fieldInfos.fieldInfo(i);
            if (!fieldInfo.isIndexed) continue;
            String string = this.segment + ".f" + fieldInfo.number;
            Directory directory2 = this.directory().fileExists(string) ? this.directory() : directory;
            this.norms.put(fieldInfo.name, new Norm(directory2.openFile(string), fieldInfo.number));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void closeNorms() throws IOException {
        Hashtable hashtable = this.norms;
        synchronized (hashtable) {
            Enumeration enumeration = this.norms.elements();
            while (enumeration.hasMoreElements()) {
                Norm norm = (Norm)enumeration.nextElement();
                norm.in.close();
            }
        }
    }

    public TermFreqVector getTermFreqVector(int n, String string) throws IOException {
        FieldInfo fieldInfo = this.fieldInfos.fieldInfo(string);
        if (fieldInfo == null || !fieldInfo.storeTermVector) {
            return null;
        }
        return this.termVectorsReader.get(n, string);
    }

    public TermFreqVector[] getTermFreqVectors(int n) throws IOException {
        if (this.termVectorsReader == null) {
            return null;
        }
        return this.termVectorsReader.get(n);
    }

    private class Norm {
        private InputStream in;
        private byte[] bytes;
        private boolean dirty;
        private int number;

        public Norm(InputStream inputStream, int n) {
            this.in = inputStream;
            this.number = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reWrite() throws IOException {
            OutputStream outputStream = SegmentReader.this.directory().createFile(SegmentReader.this.segment + ".tmp");
            try {
                outputStream.writeBytes(this.bytes, SegmentReader.this.maxDoc());
            }
            finally {
                outputStream.close();
            }
            String string = SegmentReader.this.segment + ".f" + this.number;
            SegmentReader.this.directory().renameFile(SegmentReader.this.segment + ".tmp", string);
            this.dirty = false;
        }

        static /* synthetic */ byte[] access$302(Norm norm, byte[] byArray) {
            norm.bytes = byArray;
            return byArray;
        }
    }
}

