/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.index;

import gate.creole.annic.apache.lucene.index.CompoundFileWriter;
import gate.creole.annic.apache.lucene.index.FieldInfo;
import gate.creole.annic.apache.lucene.index.FieldInfos;
import gate.creole.annic.apache.lucene.index.FieldsWriter;
import gate.creole.annic.apache.lucene.index.IndexReader;
import gate.creole.annic.apache.lucene.index.SegmentMergeInfo;
import gate.creole.annic.apache.lucene.index.SegmentMergeQueue;
import gate.creole.annic.apache.lucene.index.Term;
import gate.creole.annic.apache.lucene.index.TermEnum;
import gate.creole.annic.apache.lucene.index.TermFreqVector;
import gate.creole.annic.apache.lucene.index.TermInfo;
import gate.creole.annic.apache.lucene.index.TermInfosWriter;
import gate.creole.annic.apache.lucene.index.TermPositions;
import gate.creole.annic.apache.lucene.index.TermVectorsWriter;
import gate.creole.annic.apache.lucene.store.Directory;
import gate.creole.annic.apache.lucene.store.OutputStream;
import gate.creole.annic.apache.lucene.store.RAMOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;

final class SegmentMerger {
    private boolean useCompoundFile;
    private Directory directory;
    private String segment;
    private Vector readers = new Vector();
    private FieldInfos fieldInfos;
    private static final String[] COMPOUND_EXTENSIONS = new String[]{"fnm", "frq", "prx", "fdx", "fdt", "tii", "tis"};
    private static final String[] VECTOR_EXTENSIONS = new String[]{"tvx", "tvd", "tvf"};
    private OutputStream freqOutput = null;
    private OutputStream proxOutput = null;
    private TermInfosWriter termInfosWriter = null;
    private int skipInterval;
    private SegmentMergeQueue queue = null;
    private final TermInfo termInfo = new TermInfo();
    private RAMOutputStream skipBuffer = new RAMOutputStream();
    private int lastSkipDoc;
    private long lastSkipFreqPointer;
    private long lastSkipProxPointer;

    SegmentMerger(Directory directory, String string, boolean bl) {
        this.directory = directory;
        this.segment = string;
        this.useCompoundFile = bl;
    }

    final void add(IndexReader indexReader) {
        this.readers.addElement(indexReader);
    }

    final IndexReader segmentReader(int n) {
        return (IndexReader)this.readers.elementAt(n);
    }

    final int merge() throws IOException {
        int n = this.mergeFields();
        this.mergeTerms();
        this.mergeNorms();
        if (this.fieldInfos.hasVectors()) {
            this.mergeVectors();
        }
        if (this.useCompoundFile) {
            this.createCompoundFile();
        }
        return n;
    }

    final void closeReaders() throws IOException {
        for (int i = 0; i < this.readers.size(); ++i) {
            IndexReader indexReader = (IndexReader)this.readers.elementAt(i);
            indexReader.close();
        }
    }

    private final void createCompoundFile() throws IOException {
        int n;
        CompoundFileWriter compoundFileWriter = new CompoundFileWriter(this.directory, this.segment + ".cfs");
        ArrayList<String> arrayList = new ArrayList<String>(COMPOUND_EXTENSIONS.length + this.fieldInfos.size());
        for (n = 0; n < COMPOUND_EXTENSIONS.length; ++n) {
            arrayList.add(this.segment + "." + COMPOUND_EXTENSIONS[n]);
        }
        for (n = 0; n < this.fieldInfos.size(); ++n) {
            FieldInfo fieldInfo = this.fieldInfos.fieldInfo(n);
            if (!fieldInfo.isIndexed) continue;
            arrayList.add(this.segment + ".f" + n);
        }
        if (this.fieldInfos.hasVectors()) {
            for (n = 0; n < VECTOR_EXTENSIONS.length; ++n) {
                arrayList.add(this.segment + "." + VECTOR_EXTENSIONS[n]);
            }
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            compoundFileWriter.addFile((String)iterator.next());
        }
        compoundFileWriter.close();
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.directory.deleteFile((String)iterator.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int mergeFields() throws IOException {
        this.fieldInfos = new FieldInfos();
        int n = 0;
        for (int i = 0; i < this.readers.size(); ++i) {
            IndexReader indexReader = (IndexReader)this.readers.elementAt(i);
            this.fieldInfos.addIndexed(indexReader.getIndexedFieldNames(true), true);
            this.fieldInfos.addIndexed(indexReader.getIndexedFieldNames(false), false);
            this.fieldInfos.add(indexReader.getFieldNames(false), false);
        }
        this.fieldInfos.write(this.directory, this.segment + ".fnm");
        FieldsWriter fieldsWriter = new FieldsWriter(this.directory, this.segment, this.fieldInfos);
        try {
            for (int i = 0; i < this.readers.size(); ++i) {
                IndexReader indexReader = (IndexReader)this.readers.elementAt(i);
                int n2 = indexReader.maxDoc();
                for (int j = 0; j < n2; ++j) {
                    if (indexReader.isDeleted(j)) continue;
                    fieldsWriter.addDocument(indexReader.document(j));
                    ++n;
                }
            }
        }
        finally {
            fieldsWriter.close();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void mergeVectors() throws IOException {
        TermVectorsWriter termVectorsWriter = new TermVectorsWriter(this.directory, this.segment, this.fieldInfos);
        try {
            for (int i = 0; i < this.readers.size(); ++i) {
                IndexReader indexReader = (IndexReader)this.readers.elementAt(i);
                int n = indexReader.maxDoc();
                for (int j = 0; j < n; ++j) {
                    if (indexReader.isDeleted(j)) continue;
                    termVectorsWriter.openDocument();
                    TermFreqVector[] termFreqVectorArray = indexReader.getTermFreqVectors(j);
                    if (termFreqVectorArray == null) continue;
                    for (int k = 0; k < termFreqVectorArray.length; ++k) {
                        TermFreqVector termFreqVector = termFreqVectorArray[k];
                        termVectorsWriter.openField(termFreqVector.getField());
                        String[] stringArray = termFreqVector.getTerms();
                        int[] nArray = termFreqVector.getTermFrequencies();
                        for (int i2 = 0; i2 < stringArray.length; ++i2) {
                            termVectorsWriter.addTerm(stringArray[i2], nArray[i2]);
                        }
                    }
                    termVectorsWriter.closeDocument();
                }
            }
        }
        finally {
            termVectorsWriter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void mergeTerms() throws IOException {
        try {
            this.freqOutput = this.directory.createFile(this.segment + ".frq");
            this.proxOutput = this.directory.createFile(this.segment + ".prx");
            this.termInfosWriter = new TermInfosWriter(this.directory, this.segment, this.fieldInfos);
            this.skipInterval = this.termInfosWriter.skipInterval;
            this.queue = new SegmentMergeQueue(this.readers.size());
            this.mergeTermInfos();
        }
        finally {
            if (this.freqOutput != null) {
                this.freqOutput.close();
            }
            if (this.proxOutput != null) {
                this.proxOutput.close();
            }
            if (this.termInfosWriter != null) {
                this.termInfosWriter.close();
            }
            if (this.queue != null) {
                this.queue.close();
            }
        }
    }

    private final void mergeTermInfos() throws IOException {
        SegmentMergeInfo segmentMergeInfo;
        Object object;
        int n = 0;
        for (int i = 0; i < this.readers.size(); ++i) {
            IndexReader indexReader = (IndexReader)this.readers.elementAt(i);
            object = indexReader.terms();
            segmentMergeInfo = new SegmentMergeInfo(n, (TermEnum)object, indexReader);
            n += indexReader.numDocs();
            if (segmentMergeInfo.next()) {
                this.queue.put(segmentMergeInfo);
                continue;
            }
            segmentMergeInfo.close();
        }
        SegmentMergeInfo[] segmentMergeInfoArray = new SegmentMergeInfo[this.readers.size()];
        while (this.queue.size() > 0) {
            int n2 = 0;
            segmentMergeInfoArray[n2++] = (SegmentMergeInfo)this.queue.pop();
            object = segmentMergeInfoArray[0].term;
            segmentMergeInfo = (SegmentMergeInfo)this.queue.top();
            while (segmentMergeInfo != null && ((Term)object).compareTo(segmentMergeInfo.term) == 0) {
                segmentMergeInfoArray[n2++] = (SegmentMergeInfo)this.queue.pop();
                segmentMergeInfo = (SegmentMergeInfo)this.queue.top();
            }
            this.mergeTermInfo(segmentMergeInfoArray, n2);
            while (n2 > 0) {
                SegmentMergeInfo segmentMergeInfo2;
                if ((segmentMergeInfo2 = segmentMergeInfoArray[--n2]).next()) {
                    this.queue.put(segmentMergeInfo2);
                    continue;
                }
                segmentMergeInfo2.close();
            }
        }
    }

    private final void mergeTermInfo(SegmentMergeInfo[] segmentMergeInfoArray, int n) throws IOException {
        long l = this.freqOutput.getFilePointer();
        long l2 = this.proxOutput.getFilePointer();
        int n2 = this.appendPostings(segmentMergeInfoArray, n);
        long l3 = this.writeSkip();
        if (n2 > 0) {
            this.termInfo.set(n2, l, l2, (int)(l3 - l));
            this.termInfosWriter.add(segmentMergeInfoArray[0].term, this.termInfo);
        }
    }

    private final int appendPostings(SegmentMergeInfo[] segmentMergeInfoArray, int n) throws IOException {
        int n2 = 0;
        int n3 = 0;
        this.resetSkip();
        for (int i = 0; i < n; ++i) {
            SegmentMergeInfo segmentMergeInfo = segmentMergeInfoArray[i];
            TermPositions termPositions = segmentMergeInfo.postings;
            int n4 = segmentMergeInfo.base;
            int[] nArray = segmentMergeInfo.docMap;
            termPositions.seek(segmentMergeInfo.termEnum);
            while (termPositions.next()) {
                int n5 = termPositions.doc();
                if (nArray != null) {
                    n5 = nArray[n5];
                }
                if ((n5 += n4) < n2) {
                    throw new IllegalStateException("docs out of order");
                }
                if (++n3 % this.skipInterval == 0) {
                    this.bufferSkip(n2);
                }
                int n6 = n5 - n2 << 1;
                n2 = n5;
                int n7 = termPositions.freq();
                if (n7 == 1) {
                    this.freqOutput.writeVInt(n6 | 1);
                } else {
                    this.freqOutput.writeVInt(n6);
                    this.freqOutput.writeVInt(n7);
                }
                int n8 = 0;
                for (int j = 0; j < n7; ++j) {
                    int n9 = termPositions.nextPosition();
                    this.proxOutput.writeVInt(n9 - n8);
                    n8 = n9;
                }
            }
        }
        return n3;
    }

    private void resetSkip() throws IOException {
        this.skipBuffer.reset();
        this.lastSkipDoc = 0;
        this.lastSkipFreqPointer = this.freqOutput.getFilePointer();
        this.lastSkipProxPointer = this.proxOutput.getFilePointer();
    }

    private void bufferSkip(int n) throws IOException {
        long l = this.freqOutput.getFilePointer();
        long l2 = this.proxOutput.getFilePointer();
        this.skipBuffer.writeVInt(n - this.lastSkipDoc);
        this.skipBuffer.writeVInt((int)(l - this.lastSkipFreqPointer));
        this.skipBuffer.writeVInt((int)(l2 - this.lastSkipProxPointer));
        this.lastSkipDoc = n;
        this.lastSkipFreqPointer = l;
        this.lastSkipProxPointer = l2;
    }

    private long writeSkip() throws IOException {
        long l = this.freqOutput.getFilePointer();
        this.skipBuffer.writeTo(this.freqOutput);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeNorms() throws IOException {
        for (int i = 0; i < this.fieldInfos.size(); ++i) {
            FieldInfo fieldInfo = this.fieldInfos.fieldInfo(i);
            if (!fieldInfo.isIndexed) continue;
            OutputStream outputStream = this.directory.createFile(this.segment + ".f" + i);
            try {
                for (int j = 0; j < this.readers.size(); ++j) {
                    IndexReader indexReader = (IndexReader)this.readers.elementAt(j);
                    byte[] byArray = indexReader.norms(fieldInfo.name);
                    int n = indexReader.maxDoc();
                    for (int k = 0; k < n; ++k) {
                        byte by;
                        byte by2 = by = byArray != null ? byArray[k] : (byte)0;
                        if (indexReader.isDeleted(k)) continue;
                        outputStream.writeByte(by);
                    }
                }
                continue;
            }
            finally {
                outputStream.close();
            }
        }
    }
}

