/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.index;

import gate.creole.annic.apache.lucene.index.SegmentInfo;
import gate.creole.annic.apache.lucene.store.Directory;
import gate.creole.annic.apache.lucene.store.InputStream;
import gate.creole.annic.apache.lucene.store.OutputStream;
import java.io.IOException;
import java.util.Vector;

final class SegmentInfos
extends Vector {
    public static final int FORMAT = -1;
    public int counter = 0;
    private long version = 0L;

    SegmentInfos() {
    }

    public final SegmentInfo info(int n) {
        return (SegmentInfo)this.elementAt(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void read(Directory directory) throws IOException {
        InputStream inputStream = directory.openFile("segments");
        try {
            int n = inputStream.readInt();
            if (n < 0) {
                if (n < -1) {
                    throw new IOException("Unknown format version: " + n);
                }
                this.version = inputStream.readLong();
                this.counter = inputStream.readInt();
            } else {
                this.counter = n;
            }
            for (int i = inputStream.readInt(); i > 0; --i) {
                SegmentInfo segmentInfo = new SegmentInfo(inputStream.readString(), inputStream.readInt(), directory);
                this.addElement(segmentInfo);
            }
            if (n >= 0) {
                this.version = inputStream.getFilePointer() >= inputStream.length() ? 0L : inputStream.readLong();
            }
        }
        finally {
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(Directory directory) throws IOException {
        OutputStream outputStream = directory.createFile("segments.new");
        try {
            outputStream.writeInt(-1);
            outputStream.writeLong(++this.version);
            outputStream.writeInt(this.counter);
            outputStream.writeInt(this.size());
            for (int i = 0; i < this.size(); ++i) {
                SegmentInfo segmentInfo = this.info(i);
                outputStream.writeString(segmentInfo.name);
                outputStream.writeInt(segmentInfo.docCount);
            }
        }
        finally {
            outputStream.close();
        }
        directory.renameFile("segments.new", "segments");
    }

    public long getVersion() {
        return this.version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long readCurrentVersion(Directory directory) throws IOException {
        InputStream inputStream = directory.openFile("segments");
        int n = 0;
        long l = 0L;
        try {
            n = inputStream.readInt();
            if (n < 0) {
                if (n < -1) {
                    throw new IOException("Unknown format version: " + n);
                }
                l = inputStream.readLong();
            }
        }
        finally {
            inputStream.close();
        }
        if (n < 0) {
            return l;
        }
        SegmentInfos segmentInfos = new SegmentInfos();
        segmentInfos.read(directory);
        return segmentInfos.getVersion();
    }
}

