/*
 * Decompiled with CFR 0.152.
 */
package gate.creole.annic.apache.lucene.index;

import gate.creole.annic.apache.lucene.index.IndexReader;
import gate.creole.annic.apache.lucene.index.Term;
import gate.creole.annic.apache.lucene.index.TermDocs;
import gate.creole.annic.apache.lucene.index.TermEnum;
import java.io.IOException;

class MultiTermDocs
implements TermDocs {
    protected IndexReader[] readers;
    protected int[] starts;
    protected Term term;
    protected int base = 0;
    protected int pointer = 0;
    private TermDocs[] readerTermDocs;
    protected TermDocs current;

    public MultiTermDocs(IndexReader[] indexReaderArray, int[] nArray) {
        this.readers = indexReaderArray;
        this.starts = nArray;
        this.readerTermDocs = new TermDocs[indexReaderArray.length];
    }

    public int doc() {
        return this.base + this.current.doc();
    }

    public int freq() {
        return this.current.freq();
    }

    public void seek(Term term) {
        this.term = term;
        this.base = 0;
        this.pointer = 0;
        this.current = null;
    }

    public void seek(TermEnum termEnum) throws IOException {
        this.seek(termEnum.term());
    }

    public boolean next() throws IOException {
        if (this.current != null && this.current.next()) {
            return true;
        }
        if (this.pointer < this.readers.length) {
            this.base = this.starts[this.pointer];
            this.current = this.termDocs(this.pointer++);
            return this.next();
        }
        return false;
    }

    public int read(int[] nArray, int[] nArray2) throws IOException {
        int n;
        while (true) {
            if (this.current == null) {
                if (this.pointer < this.readers.length) {
                    this.base = this.starts[this.pointer];
                    this.current = this.termDocs(this.pointer++);
                    continue;
                }
                return 0;
            }
            n = this.current.read(nArray, nArray2);
            if (n != 0) break;
            this.current = null;
        }
        int n2 = this.base;
        int n3 = 0;
        while (n3 < n) {
            int n4 = n3++;
            nArray[n4] = nArray[n4] + n2;
        }
        return n;
    }

    public boolean skipTo(int n) throws IOException {
        do {
            if (this.next()) continue;
            return false;
        } while (n > this.doc());
        return true;
    }

    private TermDocs termDocs(int n) throws IOException {
        if (this.term == null) {
            return null;
        }
        TermDocs termDocs = this.readerTermDocs[n];
        if (termDocs == null) {
            termDocs = this.readerTermDocs[n] = this.termDocs(this.readers[n]);
        }
        termDocs.seek(this.term);
        return termDocs;
    }

    protected TermDocs termDocs(IndexReader indexReader) throws IOException {
        return indexReader.termDocs();
    }

    public void close() throws IOException {
        for (int i = 0; i < this.readerTermDocs.length; ++i) {
            if (this.readerTermDocs[i] == null) continue;
            this.readerTermDocs[i].close();
        }
    }
}

